<?php

register_top_alerts_dashlet();

function register_top_alerts_dashlet() {

	$dashlet_opts = array(
		DASHLET_NAME 		=> 'top_alerts',
        DASHLET_TYPE        => DASHLET_TYPE_CORE,
		DASHLET_SERVER_TYPE => SERVER_TYPE_XI | SERVER_TYPE_CORE,
		DASHLET_VERSION		=> '1.0.0',
		DASHLET_DATE		=> '01/24/2017',
		DASHLET_AUTHOR		=> 'Nagios Enterprises',
		DASHLET_DESCRIPTION	=> _('Top Alert Producers'),
		DASHLET_COPYRIGHT	=> '&copy; 2017 Nagios Enterprises, LLC',
		DASHLET_HOMEPAGE	=> 'www.nagios.com',
		DASHLET_LICENSE     => _('Nagios Software License'),
		DASHLET_PREVIEW		=> get_dashlets_base_url() . 'top_alerts/top_alerts.png',
		DASHLET_LOAD_URL	=> get_dashlets_base_url() . 'top_alerts/top_alerts.php',
		DASHLET_TITLE		=> _('Top Alerts'),
    	DASHLET_PARAMS		=> 'top_alerts_dashlet_params',
    	DASHLET_WIDTH => 1000,
    	);

	register_dashlet($dashlet_opts);
}

function top_alerts_dashlet_params() {

    $servers = array('all' => _('All Servers'));
    foreach (get_servers() as $server) {
        $servers[$server['server_id']] = $server['name'];
    }
    
    return array(
        'server' => array(
            'name'      => _('Server'),
            'options'   => $servers, // in the format of array(val => humanreadable)
            ), 
        );
}