 <?php

$cbargs = array('child' => false);

$current_year = date('Y');
$base_url = get_base_url();
$product_name = get_product_name();

?>

<!-- PARENT FOOTER START -->
<noframes>
    <!-- This page requires a web browser which supports frames. -->
    <h2><?php echo $product_name; ?></h2>
    <p align="center">
        <a href="https://www.nagios.com/">www.nagios.com</a><br>
        Copyright (c) 2009-<?php echo $current_year; ?> Nagios Enterprises, LLC<br>
    </p>
    <p>
        <i><?php echo _('Note: These pages require a browser which supports frames'); ?></i>
    </p>
</noframes>
<div id="footer">

    <?php do_callbacks(CALLBACK_FOOTER_CONTENT_START, $cbargs); ?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-6 footer-left">
                <a href="https://www.nagios.com/products/nagiosfusion" target="new"><strong><?php echo $product_name; ?></strong></a>
                <?php if (is_authenticated() === true) echo get_product_version_display(); ?>
                <?php if (is_authenticated() === true && is_admin() && !is_v2_license_type('cloud')) { // Admins only for updates ?>
                    &nbsp;&nbsp;&bull;&nbsp;&nbsp;
                    <a href="<?php echo get_update_check_url(); ?>" target="_blank"><?php echo _('Check for Updates'); ?></a>
                <?php } ?>
            </div>
            <div class="col-sm-6 footer-right">
                <?php if (is_authenticated() === true) { ?>
                <a href="<?php echo $base_url; ?>about/"><?php echo _('About'); ?></a> &nbsp;&nbsp;|&nbsp;&nbsp;
                <a href="<?php echo $base_url; ?>about/?fusionwindow=legal.php"><?php echo _('Legal'); ?></a> &nbsp;&nbsp;|&nbsp;&nbsp;
                <?php } ?>
                <?php echo _('Copyright'); ?> &copy; 2017-<?php echo date('Y', time()); ?> <a href="https://www.nagios.com/" target="_blank">Nagios Enterprises, LLC</a>
            </div>
        </div>
    </div>
    <div id="keepalive"></div>

    <?php do_callbacks(CALLBACK_FOOTER_CONTENT_END, $cbargs); ?>

</div><!-- footer -->
<!-- PARENT FOOTER END -->
