<?php

function set_language($language)
{
    ini_set('default_charset', 'UTF-8');
    $langdir = '/usr/local/nagiosfusion/html/includes/lang/locale/';

    // Fix for wrong en_US language name (en and en_EN)
    if ($language == 'en' || $language == 'en_EN') {
        $language = 'en_US';
    }

    // Only set gettext (now _()) locale if we have a language file
    if (!file_exists($langdir . $language)) {
        return;
    }

    // Set session language
    $_SESSION['language'] = $language;

    // Set the locale/environment language
    setlocale(LC_MESSAGES, $language, $language . 'utf-8', $language . 'utf8', "en_GB.utf8");
    putenv("LANG=" . $language);

    // Non-English numeric formats will turn decimals to commas and mess up all kinds of stuff
    // so we aren't going to do that
    setlocale(LC_NUMERIC, 'C');

    // Bind text domains
    bindtextdomain($language, $langdir);
    bind_textdomain_codeset($language, 'UTF-8');
    textdomain($language);
}


function init_language()
{
    // URL override
    $locale = grab_request_var('locale', '');
    
    if (!empty($locale)) {
        set_language($locale);
        $_SESSION['session_lang'] = $locale;
    }
    else {
        $lang = get_option('default_language', 'en_US');
        $user_lang = get_user_meta('language');
        
        if (empty($user_lang)) {
            set_language($lang);
        }
        else {
            set_language(get_user_meta('language', $lang));
        }
    }
    
    // Read session language if available
    if (!empty($_SESSION['session_lang'])) {
        $session_language = $_SESSION['session_lang'];
    } else {
        // Try user-specific and global default language from DB
        $udblang = get_user_meta('language');
        if (!empty($udblang)) {
            $session_language = $udblang;
        } else {
            $dblang = get_option('default_language', DEFAULT_LANGUAGE);
            $session_language = $dblang;
        }
    }

    set_language($session_language);
}

function get_language_nicename($lang) {
    switch ($lang) {
        case "en_US":
            return _("English") . " (English)";
        case "de_DE":
            return _("German") . " (Deutsche)";
        case "es_ES":
            return _("Spanish") . " (Español)";
        case "fr_FR":
            return _("French") . " (Français)";
        case "it_IT":
            return _("Italian") . " (Italiano)";
        case "ja_JP":
            return _("Japanese") . " (日本語)";
        case "ko_KR":
            return _("Korean") . " (한국어)";
        case "pt_PT":
            return _("Portuguese") . " (Português)";
        case "ru_RU":
            return _("Russian") . " (Русский)";
        case "zh_CN":
            return _("Simplified Chinese") . " (简体中文)";
        case "zh_TW":
            return _("Traditional Chinese") . " (繁體中文)";
        case "pl_PL":
            return _("Polish") . " (Polski)";
        case "cs_CZ":
            return _("Czech") . " (Čeština)";
        case "bg_BG":
            return _("Bulgarian") . " (Български)";
        default:
            return $lang;
    }
}

function get_languages_as_array() {
    
    return array(
        'en_US' => _('English'),
        'de_DE' => _('German'),
        'es_ES' => _('Spanish'),
        'fr_FR' => _('French'),
        'it_IT' => _('Italian'),
        'ja_JP' => _('Japanese'),
        'ko_KR' => _('Korean'),
        'pt_PT' => _('Portuguese'),
        'ru_RU' => _('Russian'),
        'zh_CN' => _('Simplified Chinese'),
        'zh_TW' => _('Traditional Chinese'),
        'pl_PL' => _('Polish')
        );
}
