<?php

function init_menu($page = '') {

    global $menu;
    $menu = new menu();

    switch ($page) {

        case 'home':
            //$menu->add_section('home', 'Details', 'home-details');
            $menu->add_section('home', _('Server Status'), 'home-server-status');
            $menu->add_section('home', _('Alerts'), 'home-alerts');
            $menu->add_section('home', _('Visualizations'), 'home-visualizations');

            //$menu->add_link(menu_link('Test', 'test.php', 'class1', 'id1'), 'home-details');
            
            
            break;

        case 'views':
            $menu->add_raw_section('views', 'menuslider', '
                <div class="well" style="margin: 0; padding: 10px;">
                    <button class="btn btn-xxs btn-default btn-view-pr tt-bind" title="' . _('Pause rotation') . '"><i class="fa fa-pause"></i></button>
                    <div class="viewspeed-slider-box">
                        <i class="fa fa-plus l tt-bind" title="' . _('Increase rotation speed') . '" style="font-size: 10px;"></i>
                        <div id="myviewspeedslider"></div>
                        <i class="fa fa-minus r tt-bind" title="' . _('Decrease rotation speed') . '" style="font-size: 10px;"></i>
                    </div>
                    <div class="rotation-stopped hide">' . _('Rotation is stopped') . '</div>
                    <div id="current-time" class="tt-bind" style="cursor: default;" title="' . _('Seconds until view rotation') . '"></div>
                    <div class="clear"></div>
                </div>');
            $menu->add_section('views', _('View Tools'), 'views-tools');
            $menu->add_section('views', _('My Views'), 'views-mine');

            $menu->add_link(menu_link('&nbsp;' . _('Stop Rotation'), '#', 'rotatemyviewslink', '', 'fa-stop', '_self'), 'views-tools');
            $menu->add_link_spacer('views-tools');
            $menu->add_link(menu_link(_('Manage My Views'), 'manage.php', 'managemyviews'), 'views-tools');

            $count = 0;
            $my_views = get_views();
            if ($my_views && is_array($my_views)) {
                foreach ($my_views as $index => $view) {

                    $view_link_class = 'myviewlink';
                    $url = $view['view_url'];
                    if (!filter_var($url, FILTER_VALIDATE_URL)) {
                        $url = "error.php";
                    }

                    $menu->add_link(menu_link(encode_html($view['view_title']), $url, $view_link_class, 'view_' . $count), 'views-mine');

                    $count++;
                }
            }

            break;

        case 'dashboards':
            $menu->add_section('dashboards', _('Dashboard Tools'), 'dashboards-tools');
            $menu->add_link(menu_link(_('Manage Dashboards'), 'manage.php'), 'dashboards-tools');

            $menu->add_section('dashboards', _('My Dashboards'), 'my-dashboards');
            $dashboards = get_dashboards();
            if (count($dashboards) > 0) {
                foreach ($dashboards as $dashboard) {
                    if ($dashboard['show_in_menu'] && !$dashboard['screen'])
                        $menu->add_link(menu_link($dashboard['dashboard_name'], 'dashboard.php?id=' . $dashboard['dashboard_id']), 'my-dashboards');
                }
            }

            $menu->add_section('dashboards', _('Add Dashlets'), 'dashboards-dashlets');
            $menu->add_link(menu_link(_('Available Dashlets'), 'dashlets.php'), 'dashboards-dashlets');

            if (is_admin()) {
              $menu->add_link(menu_link('Manage Dashlets', get_base_url() . 'admin/dashlets.php'), 'dashboards-dashlets');
            }

            break;

        /*case 'reports':
            // you must obtain 7 secret rubies to unlock reports
            $menu->add_section('reports', 'Details', 'reports-details');
            break;*/

        case 'help':
            $menu->add_link(menu_link(_('Deploy Dashboards'), get_components_base_url() . 'deploydashboards/deploydashboards.php', '', '', 'fa-globe'), 'dashboards-tools');

            $menu->add_section('help', _('Help'), 'help-main');
            $menu->add_section('help', _('REST API Docs'), 'help-api');
            $menu->add_section('help', _('External Help Resources'), 'help-resources');
            $menu->add_section('help', _('Documentation Guides'), 'help-docs');

            $menu->add_link(menu_link(_('Help Home'), 'main.php'), 'help-main');
            $menu->add_link(menu_link(_('About Nagios Fusion'), get_base_url() . 'about/about.php'), 'help-main');

            $menu->add_link(menu_link(_('Introduction'), get_base_url() . 'help/api.php'), 'help-api');
            $menu->add_link(menu_link(_('System Reference'), get_base_url() . 'help/api-system-reference.php'), 'help-api');
            $menu->add_link(menu_link(_('Custom API Endpoints'), get_base_url() . 'help/custom-api-endpoints.php'), 'help-api');

            $menu->add_link(menu_link(_('Support Forum'), 'https://support.nagios.com/forum', '', '', 'fa-external-link'), 'help-resources');
            $menu->add_link(menu_link(_('Knowledge Base'), 'https://support.nagios.com/kb/category.php?id=5', '', '', 'fa-external-link'), 'help-resources');
            $menu->add_link_spacer('help-resources');
            $menu->add_link(menu_link(_('Nagios Exchange'), 'https://exchange.nagios.com/', '', '', 'fa-external-link'), 'help-resources');

            $menu->add_link(menu_link(_('Administrator Guide'), 'https://assets.nagios.com/downloads/nagiosfusion/guides/administrator', '', '', 'fa-external-link'), 'help-docs');
            $menu->add_link(menu_link(_('User Guide'), 'https://assets.nagios.com/downloads/nagiosfusion/guides/user', '', '', 'fa-external-link'), 'help-docs');
            $menu->add_link(menu_link(_('Developers Guide'), 'https://assets.nagios.com/downloads/nagiosfusion/guides/developer/', '', '', 'fa-external-link'), 'help-docs');

            break;

        case 'admin':
            //$menu->add_section('admin', 'System Information', 'admin-system-information');
            $menu->add_section('admin', _('Servers'), 'admin-servers');
            $menu->add_section('admin', _('Users'), 'admin-users');
            $menu->add_section('admin', _('System Configuration'), 'admin-system-configuration');
            $menu->add_section('admin', _('System Information'), 'admin-system-information');
            $menu->add_section('admin', _('System Extensions'), 'admin-system-extensions');

            /*$menu->add_section('admin', 'Fused Server Management', 'admin-fused-server-management');
            $menu->add_section('admin', 'System Backups', 'admin-system-backups');
            $menu->add_link(menu_link('Audit Log', 'auditlog.php'), 'admin-system-information');
*/
            $menu->add_link(menu_link(_('Manage Fused Servers'), 'servers.php', '', 'menu-manage-fused-servers', 'fa-hdd-o'), 'admin-servers');
            $menu->add_link(menu_link(_('Centralized Management'), 'centralized-management.php', '', 'menu-manage-fused-servers', 'fa-cog'), 'admin-servers');

            $menu->add_link(menu_link(_('Manage Users'), 'users.php', '', 'menu-manage-users', 'fa-user'), 'admin-users');

            $menu->add_link(menu_link(_('LDAP/AD Integration'), '../includes/components/ldap_ad_integration/manage.php', '', 'menu-adldap', 'fa-exchange'), 'admin-users');
            
            if (!is_v2_license_type('cloud')) {
                $menu->add_link(menu_link(_('Check for Updates'), 'updates.php'), 'admin-system-information');
            }
            $menu->add_link(menu_link(_('System Status'), 'sysstat.php'), 'admin-system-information');
            $menu->add_link(menu_link(_('Fusion Logs'), 'logview.php'), 'admin-system-information');

            //$menu->add_link(menu_link(_('System Profile'), 'profile.php'), 'admin-system-information');
/*          $menu->add_link(menu_link('Fusion SSO', 'sso.php'), 'admin-users');

            $menu->add_link(menu_link('', '.php'), 'admin-fused-server-management');
            $menu->add_link(menu_link('', '.php'), 'admin-fused-server-management');
            $menu->add_link(menu_link('', '.php'), 'admin-fused-server-management');
*/

            $menu->add_link(menu_link(_('System Settings'), 'settings.php', '', '', 'fa-cog'), 'admin-system-configuration');
            $menu->add_link(menu_link(_('System Profile'), 'profile.php', '', '', 'fa-download'), 'admin-system-configuration');
            $menu->add_link(menu_link(_('License Information'), 'license.php', '', '', 'fa-bookmark'), 'admin-system-configuration');
            $menu->add_link(menu_link(_('Email Settings'), 'email.php', '', '', 'fa-envelope'), 'admin-system-configuration');
            $menu->add_link(menu_link(_('Proxy Configuration'), 'proxy.php'), 'admin-system-configuration');

            $menu->add_link(menu_link(_('Manage Components'), 'components.php', '', '', 'fa-cube'), 'admin-system-extensions');
            $menu->add_link(menu_link(_('Manage Dashlets'), 'dashlets.php', '', '', 'fa-folder-o'), 'admin-system-extensions');
/*
            $menu->add_link(menu_link('', '.php'), 'admin-');
            $menu->add_link(menu_link('', '.php'), 'admin-');
            $menu->add_link(menu_link('', '.php'), 'admin-');
            $menu->add_link(menu_link('', '.php'), 'admin-');
            $menu->add_link(menu_link('', '.php'), 'admin-');
            $menu->add_link(menu_link('', '.php'), 'admin-');
            $menu->add_link(menu_link('', '.php'), 'admin-');*/
            break;

        case 'account':
            $menu->add_section('account', _('Details'), 'account-details');
            $menu->add_link(menu_link(_('Account Information'), 'main.php'), 'account-details');
            break;

        case 'about':
            $menu->add_section('about', _('About'), 'about-main');
            $menu->add_link(menu_link(_('About Nagios Fusion'), 'about.php'), 'about-main');
            $menu->add_link(menu_link(_('Legal Information'), 'legal.php'), 'about-main');
            $menu->add_link(menu_link(_('License'), 'license.php'), 'about-main');
            break;

        default:
            // $page_array = array('about', 'home', 'views', 'dashboards', 'help', 'admin', 'account');
            // foreach ($page_array as $page) {

            //  init_menu($page);
            // }
            // break;
    }

    do_callbacks(CALLBACK_MENU_INITIALIZED, $menu);
}


function set_user_menu_preferences($id, $expanded) {

    $settings = get_user_meta('menu_collapse_options');
    if ($settings !== null)
        $settings = unpack_array($settings);

    if ($expanded)
        unset($settings[$id]);
    else
        $settings[$id] = 1;

    set_user_meta('menu_collapse_options', pack_array($settings), false);
}