<?php

// anywhere that uses the pagination functionality along with the transform functionality, the ajax helper needs to have access to those transform functions
// this is the spot where they should live so that there aren't any problems


function users_build_authtype_td($td = '', $row = array()) {

    global $db;

    $user_id = $row['user_id'];

    $auth_type = get_user_meta('auth_type', '', $user_id);
    if (empty($auth_type))
        $auth_type = "local";
    $auth_type = ldap_ad_display_type($auth_type);

    return $auth_type;
}

function users_build_action_td($td = '', $row = array()) {

    $nsp = '&nsp=' . get_nagios_session_protector_id();

    $username = $row['username'];
    $user_id = $row['user_id'];

    $edit = _('Edit');
    $masquerade = _('Masquerade As');
    $delete = _('Delete');
    $disable = _('Disable');
    $enable = _('Enable');
    $unlock = _('Unlock');

//tableItemButton 
//todo UPDATE USERS.JS for the masquerade click
    $action_td = 
        '<a class="action_button" href="?edit=1&user_id=' . $user_id . $nsp . '">' .
        	'<img class="tt-bind" src="' . get_icon_url('pencil.png') . '" border="0" alt="' . $edit .'" title="' . $edit .'" data-original-title="' . $edit .'">' .
        '</a>' .
        '<a class="action_button masquerade" href="?masquerade=1&user_id=' . $user_id . $nsp . '" target="_top">' .
        	'<img class="tt-bind" src="' . get_icon_url('eye.png') . '" border="0" alt="' . $masquerade .'" title="' . $masquerade .'" data-original-title="' . $masquerade .'">' .
        '</a>';

    if (!is_v2_license_type('cloud') || $username != 'nagiosadmin') {
        $action_td .=
            '<a class="action_button delete user" href="?delete=1&user_id=' . $user_id . $nsp . '">' .
            	'<img class="tt-bind" src="' . get_icon_url('cross.png') . '" border="0" alt="' . $delete .'" title="' . $delete .'" data-original-title="' . $delete .'">' .
            '</a>';
    }

    if ($row['enabled'] == 1) {
    	$action_td .=
	        '<a class="action_button" href="?disable=1&user_id=' . $user_id . $nsp . '">' .
	        	'<img class="tt-bind" src="' . get_icon_url('user_disable.png') . '" border="0" alt="' . $disable .'" title="' . $disable .'" data-original-title="' . $disable .'">' .
	        '</a>';
    } else {
    	$action_td .=
	        '<a class="action_button" href="?enable=1&user_id=' . $user_id . $nsp . '">' .
	        	'<img class="tt-bind" src="' . get_icon_url('user_add.png') . '" border="0" alt="' . $enable .'" title="' . $enable .'" data-original-title="' . $enable .'">' .
	        '</a>';
    }

    if ($row['account_locked'] == 1) {
    	$action_td .=
	        '<a class="action_button" href="?unlock=1&user_id=' . $user_id . $nsp . '">' .
	        	'<img class="tt-bind" src="' . get_icon_url('lock_open.png') . '" border="0" alt="' . $unlock .'" title="' . $unlock .'" data-original-title="' . $unlock .'">' .
	        '</a>';
    }

    return $action_td;
}

function views_build_action_td($td = '', $row = array()) {

    $nsp = '&nsp=' . get_nagios_session_protector_id();

    $view_id = $row['view_id'];

    $edit = _('Edit this view');
    $delete = _('Delete this view');

    $td =
        '<a class="action_button" href="?edit=1&view_id=' . $view_id . $nsp . '">' .
            '<img class="tt-bind" src="' . get_icon_url('pencil.png') . '" border="0" alt="' . $edit .'" title="' . $edit .'" data-original-title="' . $edit .'">' .
        '</a>' .
        '<a class="action_button" href="?delete=1&view_id=' . $view_id . $nsp . '">' .
            '<img class="tt-bind" src="' . get_icon_url('cross.png') . '" border="0" alt="' . $delete .'" title="' . $delete .'" data-original-title="' . $delete .'">' .
        '</a>';

    return $td;
}

function servers_build_action_td($td = '', $row = array()) {

    $nsp = '&nsp=' . get_nagios_session_protector_id();

    $server_id = $row['server_id'];

    $edit = _('Edit');
    $delete = _('Delete');
    $disable = _('Disable');
    $enable = _('Enable');

    $action_td = 
        '<a class="action_button" href="?edit=1&server_id=' . $server_id . $nsp . '">' .
            '<img class="tt-bind" src="' . get_icon_url('pencil.png') . '" border="0" alt="' . $edit .'" title="' . $edit .'" data-original-title="' . $edit .'">' .
        '</a>';

    if ($row['enabled'] == 1) {
        $action_td .=
            '<a class="action_button" href="?disable=1&server_id=' . $server_id . $nsp . '">' .
                '<img class="tt-bind" src="' . get_icon_url('server_disable.png') . '" border="0" alt="' . $disable .'" title="' . $disable .'" data-original-title="' . $disable .'">' .
            '</a>';
    } else {
        $action_td .=
            '<a class="action_button" href="?enable=1&server_id=' . $server_id . $nsp . '">' .
                '<img class="tt-bind" src="' . get_icon_url('server_go.png') . '" border="0" alt="' . $enable .'" title="' . $enable .'" data-original-title="' . $enable .'">' .
            '</a>';
    }

    $action_td .= 
        '<a class="action_button delete server" href="?delete=1&server_id=' . $server_id . $nsp . '">' .
            '<img class="tt-bind" src="' . get_icon_url('cross.png') . '" border="0" alt="' . $delete .'" title="' . $delete .'" data-original-title="' . $delete .'">' .
        '</a>';

    return $action_td;
}

function dashboards_build_action_td($td = '', $row = array()) {

    $nsp = '&nsp=' . get_nagios_session_protector_id();

    $dashboard_id = $row['dashboard_id'];

    $show_menu = _('Show in Dashboard Menu');
    $hide_menu = _('Hide from Dashboard Menu');
    $edit = _('Edit');
    $deploy = _('Deploy');
    $delete = _('Delete');

    $action_td = 
        '<a class="action_button" href="?edit=1&dashboard_id=' . $dashboard_id . $nsp . '">' .
            '<img class="tt-bind" src="' . get_icon_url('pencil.png') . '" border="0" alt="' . $edit .'" title="' . $edit .'" data-original-title="' . $edit .'">' .
        '</a>';

    if ($row['show_in_menu'] == 1) {
        $action_td .=
            '<a class="action_button" href="?hide_in_menu=1&dashboard_id=' . $dashboard_id . $nsp . '">' .
                '<img class="tt-bind" src="' . get_icon_url('folder_delete.png') . '" border="0" alt="' . $hide_menu .'" title="' . $hide_menu .'" data-original-title="' . $hide_menu .'">' .
            '</a>';
    } else {
        $action_td .=
            '<a class="action_button" href="?show_in_menu=1&dashboard_id=' . $dashboard_id . $nsp . '">' .
                '<img class="tt-bind" src="' . get_icon_url('folder_add.png') . '" border="0" alt="' . $show_menu .'" title="' . $show_menu .'" data-original-title="' . $show_menu .'">' .
            '</a>';        
    }

    // cant delete home dashboard, or a synced dashboard
    if ($row['home'] != 1 && (empty($row['sync']) || is_admin())) {
        $action_td .=
            '<a class="action_button" href="?delete=1&dashboard_id=' . $dashboard_id . $nsp . '">' .
                '<img class="tt-bind" src="' . get_icon_url('cross.png') . '" border="0" alt="' . $delete .'" title="' . $delete .'" data-original-title="' . $delete .'">' .
            '</a>';
    }

    return $action_td;
}

// we return a class to determine if some value is disabled or not
function show_is_disabled($data, $enabled, $tooltip = '', $class = 'disabled') {

    if (!$enabled) {
        $tt_class = '';
        $title = '';
        if (!empty($tooltip)) {
            $tt_class = 'tt-bind';
            $title = encode_html($tooltip);
        }

        return '<span class="' . $class . ' ' . $tt_class . '" title="' . $title . '">' . $data . '</span>';
    }

    return $data;
}
