<?php
//
// Copyright (c) 2008-2023 Nagios Enterprises, LLC. All rights reserved.
//


////////////////////////////////////////////////////////////////////////
// THEME FUNCTIONS
////////////////////////////////////////////////////////////////////////


// Gets the current theme based on what the user or global default is currently set to
function get_theme()
{
    $theme = get_option('theme', 'modern');
    if(isset($_SESSION["user_id"])){
        $user_theme = get_user_meta('theme', NULL, $_SESSION["user_id"]);
    }
    
    if (!empty($user_theme)) {
        if ($user_theme != "NULL") {
            $theme = $user_theme;
        }
    }

    return $theme;
}

// Gets the current system default theme
function get_system_theme()
{
    $theme = get_option('theme', 'modern');
    return $theme;
}

/**
 * Used for building dropdowns regarding user themes, if you leave theme blank
 * (or if it's invalid) it sets to the global default
 *
 * @param   array   $themes      An array of available themes
 * @param   string  $theme       Theme name
 */
function get_themes_and_selected(&$themes, &$theme)
{
    $themes = array_flip(get_available_themes());

    if (empty($theme))
        $theme = get_theme();

    if (isset($themes[$theme]))
        return;

    $themes[$theme] = $theme;
}

/**
 * Used for building dropdowns regarding global themes
 *
 * @param   array   $themes      An array of available themes
 * @param   string  $theme       Theme name
 */
function get_themes_and_system_selected(&$themes, &$theme)
{
    $themes = array_flip(get_available_themes());

    if (empty($theme))
        $theme = get_system_theme();

    if (isset($themes[$theme]))
        return;

    $themes[$theme] = $theme;
}


function get_available_themes() {
    return array(
        "Modern" => "modern",
        "Modern Dark" => "modern-dark"
    );
}

function is_system_theme_set() {
    $system_theme = get_option('theme', NULL);
    if ($system_theme == NULL) {
        set_option('theme', 'modern');
    }
}

function is_user_theme_set() {
    $user_theme = get_user_meta('theme', NULL, $_SESSION["user_id"]);
    if ($user_theme == NULL) {
        set_user_meta('theme', '', false, $_SESSION["user_id"]);
    }
}


?>