<?php

$escape_request_vars = true;
$request_vars_decoded = false;


// Grabs POST and GET variables
function grab_request_vars($preprocess = true, $type = "")
{
    global $escape_request_vars;
    global $request;

    // Do we need to strip slashes?
    $strip = false;
    if ((function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc()) || (ini_get('magic_quotes_sybase') && (strtolower(ini_get('magic_quotes_sybase')) != "off"))) {
        $strip = true;
    }

    $request = array();

    if ($type == "" || $type == "get") {
        foreach ($_GET as $var => $val) {
            if ($escape_request_vars == true) {
                if (is_array($val)) {
                    $request[$var] = array_map('map_htmlentities', $val);
                } else {
                    $request[$var] = htmlentities(strip_tags($val), ENT_QUOTES);
                }
            } else {
                $request[$var] = $val;
            }
        }
    }

    if ($type == "" || $type == "post") {
        foreach ($_POST as $var => $val) {
            if ($escape_request_vars == true) {
                if (is_array($val)) {
                    $request[$var] = array_map('map_htmlentities', $val);
                } else {
                    $request[$var] = htmlentities($val, ENT_QUOTES);
                }
            } else {
                $request[$var] = $val;
            }
        }
    }

    // Strip slashes - we escape them later in SQL queries
    if ($strip == true) {
        foreach ($request as $var => $val) {
            $request[$var] = stripslashes($val);
        }
    }
}


// Grabs a specific request variable
function grab_request_var($varname, $default = "")
{
    global $request;
    global $escape_request_vars;
    global $request_vars_decoded;

    $v = $default;
    if (isset($request[$varname])) {
        if ($escape_request_vars == true && $request_vars_decoded == false) {
            if (is_array($request[$varname])) {
                $v = array_map('map_htmlentitydecode', $request[$varname]);
            } else {
                $v = html_entity_decode($request[$varname], ENT_QUOTES);
            }
        } else {
            $v = $request[$varname];
        }
    }
    return $v;
}


function decode_request_vars()
{
    global $request;
    global $request_vars_decoded;

    $newarr = array();
    foreach ($request as $var => $val) {
        $newarr[$var] = grab_request_var($var);
    }

    $request_vars_decoded = true;

    $request = $newarr;
}


function get_pageopt($default = '')
{
    global $request;

    $popt = grab_request_var('pageopt', '');
    if ($popt == '') {
        if (count($request) > 0) {
            foreach ($request as $var => $val) {
                $popt = $var;
                break;
            }
        } else {
            $popt = $default;
        }
    }
    return $popt;
}


function map_htmlentities($arrval)
{

    if (is_array($arrval)) {
        return array_map('map_htmlentities', $arrval);
    } else
        return htmlentities($arrval, ENT_QUOTES);
}


function map_htmlentitydecode($arrval)
{

    if (is_array($arrval)) {
        return array_map('map_htmlentitydecode', $arrval);
    } else
        return html_entity_decode($arrval, ENT_QUOTES);
}
