<?php

function get_views($user_id = 0) {

    global $db;

    if ($user_id == 0 && isset($_SESSION['user_id']))
        $user_id = $_SESSION['user_id'];

    $bind_array = array(
        ':user_id' => $user_id,
        );

    $views = $db->exec_query("SELECT * FROM views WHERE user_id = :user_id ORDER BY view_order, view_id", $bind_array);

    if (!$views || !is_array($views))
        $views = array();

    return $views;
}


function get_view_attr($attr, $view_id = 0, $default = null) {

    global $db;

    if (!is_valid_view_attr($attr))
        return false;

    $db->query("SELECT {$attr} AS attr FROM views WHERE view_id = :view_id LIMIT 1");
    $db->bind(':view_id', $view_id, PDO::PARAM_INT);
    $db->exec();

    $rows = $db->fetch_rows();
    if (count($rows) == 1) {

        $value = $rows[0]['attr'];
        return $value;
    }

    return $default;
}

function set_view_attr($attr, $value, $view_id = 0) {

    global $db;

    if (!is_valid_view_attr($attr))
        return false;

    $user_id = 0;
    if (isset($_SESSION['user_id']))
        $user_id = intval($_SESSION['user_id']);

    $db->query("UPDATE views SET {$attr} = :value WHERE view_id = :view_id AND user_id = :user_id LIMIT 1");
    $db->bind(':value', $value);
    $db->bind(':user_id', $user_id);
    $db->bind(':view_id', $view_id, PDO::PARAM_INT);
    return $db->exec();
}


function is_valid_view_attr($attr) {

    return is_valid_column_of_table($attr, 'views');
}

function add_view($url, $title, $user_id = 0) {

    global $db;

    if ($user_id == 0 && isset($_SESSION['user_id']))
        $user_id = $_SESSION['user_id'];

    $bind_array = array(
        ':user_id' => intval($user_id),
        ':view_url' => $url,
        ':view_title' => $title,
        );
    
    return $db->exec_query('INSERT INTO views (user_id, view_url, view_title) VALUES (:user_id, :view_url, :view_title)', $bind_array);

}

function delete_view($view_id = 0) {

    global $db;

    $user_id = 0;
    if (isset($_SESSION['user_id']))
        $user_id = intval($_SESSION['user_id']);

    $bind_array = array(
        ':user_id' => $user_id,
        ':view_id' => $view_id,
        );

    return $db->exec_query('DELETE FROM views WHERE view_id = :view_id AND user_id = :user_id LIMIT 1', $bind_array);
}

// these are the default views that are populated when a user is created
function get_default_views() {

    return array(
        array(
            'view_title'    => _('Tactical Summary'),
            'view_url'      => get_base_url() . 'includes/components/fusioncore/tactical_summary.php',
            ),
        array(
            'view_title'    => _('Recent Alerts'),
            'view_url'      => get_base_url() . 'includes/components/fusioncore/recent_alerts.php',
            ),
        array(
            'view_title'    => _('Host Health'),
            'view_url'      => get_base_url() . 'includes/components/fusioncore/host_health.php',
            ),
        array(
            'view_title'    => _('Service Health'),
            'view_url'      => get_base_url() . 'includes/components/fusioncore/service_health.php',
            ),
        );
}