<?php
require_once(dirname(__FILE__) . '/includes/base.inc.php');

print_static_page();
function print_static_page() {

    global $dashlets;

	$title = _('Welcome to Nagios Fusion 2026');
	child_page($title);

    $edit_page_settings = '';

    global $components;
    if (!empty($components['home_page_modification']))
        $edit_page_settings =
            '&nbsp;&nbsp;&nbsp;<a href="' . get_components_base_url() . 'home_page_modification/home_page_mod_useropts.php" title="' . _('Update Home Page Settings') . '"><i class="fa fa-cog fa-2x"></i></a>';

    echo '
        <div class="well top">
            <h1 class="fl">' . $title . '</h1>
            ' . $edit_page_settings . '
            <div class="clear"></div>
        </div>';

    ?>
    <div class="container-fluid" style="margin: 10px -10px;">
        <div class="row">
            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-4 span6">
    <?php

    if ( get_user_attr('recent_login_failures') > 0){
        echo '<div class="well failed-login-warning">';
        echo get_user_attr('recent_login_failures') . _(' Failed Login Attempts Since Last Login <br>');
        echo _('Last Failed Attempt At: ') . get_user_attr('last_login_failure_time');
        echo '</div>';
        reset_failed_logins($_SESSION['username']);
    }

    // TODO: add gear icon here for updating home page settings


    // TODO: unrelated to this page, but this is where i was when i thought of it: we need widths set on some of the fusioncore dashlet container pages (like recent_alerts, etc.) - as it stands right now they take up 100% of the page width - this is fine for some, but not the tiny tabular dashlets

    $getting_started_dashlet = empty($dashlets['getting_started']) ? false : $dashlets['getting_started'];
    echo '<div style="margin: 20px 10px;">';
    echo get_inline_dashlet_html($getting_started_dashlet, true);
    echo '</div>';

    if (is_admin()) {
        $admin_task_dashlet = empty($dashlets['admin_tasks']) ? false : $dashlets['admin_tasks'];
        echo '<div style="margin: 20px 10px;">';
        echo get_inline_dashlet_html($admin_task_dashlet, true);
        echo '</div>';
    }


    ?>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="well" style="margin: 20px 10px;">
                    <h4><?php echo _("We're here to help!"); ?></h4>
                    <br />
                    <p>
                        <?php echo _("Have a question or technical problem? Our knowledgeable support technicians can help you with any questions or problems you may have getting Nagios Fusion up and running. All you have to do is contact us today:"); ?>
                    </p>
                    <table class="table table-condensed table-no-border" style="width: auto;">
                        <tr>
                            <td><?php echo _("Support"); ?>:</td>
                            <td><a href="//support.nagios.com/forum/" target="_blank"><?php echo _("Online Support Forum"); ?></a></td>
                        </tr>
                        <tr>
                            <td style="vertical-align: top;"><?php echo _("Sales"); ?>:</td>
                            <td>
                                <table>
                                    <tr>
                                        <td><?php echo _("Phone"); ?>:&nbsp;&nbsp;</td><td>(651) 204-9102</td>
                                    </tr>
                                        <td><?php echo _("Fax"); ?>:&nbsp;&nbsp;</td><td>(651) 204-9103</td>
                                    </tr>
                                        <td><?php echo _("Email"); ?>:&nbsp;&nbsp;</td><td>sales@nagios.com</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td valign="top"><?php echo _("Web"); ?>:</td>
                            <td><a href="//www.nagios.com/" target="_blank">www.nagios.com</a></td>
                        </tr>
                    </table>
                </div>
    <?php


    ?>
            </div>
            <?php
            // we only show the tactical overview and open problems dashlets if we have any data
            if (dashlets_data_check(false)) {

                echo '<div class="col-sm-6 col-md-6 col-lg-4 col-xl-5 span6">';

                $tactical_overview_dashlet = empty($dashlets['tactical_overview']) ? false : $dashlets['tactical_overview'];
                {
                    $all_servers_dashlet = $tactical_overview_dashlet;
                    $all_servers_title = _('Tactical Overview for All Servers');
                    $all_servers_dashlet[DASHLET_PARAMS] = array();
                    $all_servers_dashlet[DASHLET_PARAMS]['server']['val'] = 'all';
                    $all_servers_dashlet[DASHLET_TITLE] = $all_servers_title;

                    echo '<div style="margin: 20px 10px;">';
                    echo '<h2>' . _('Tactical Overview') . '</h2>';
                    echo get_inline_dashlet_html($all_servers_dashlet, true);
                    echo '</div>';
                }

                $open_problems_summary = empty($dashlets['open_problems_summary']) ? false : $dashlets['open_problems_summary'];
                echo '<div style="margin: 40px 10px 20px;">';
                echo '<h2>' . _('Open Problems') . '</h2>';
                echo get_inline_dashlet_html($open_problems_summary, true);
                echo '</div>';

                echo '</div>';
            }
            ?>
        </div>
    </div>

    <?php

}

/*




                <div class="well">
                    <div style="background-color: #FFF;">
                        <div class="dashlettable xicore_getting_started_outboard"><div class="dashifybutton"><a class="tt-bind" title="Add This To a Dashboard"><i class="fa fa-sign-in fa-rotate-270" style="font-size: 14px;"></i></a></div><div class="dashlettablecontentargs">YTozOntzOjQ6Im5hbWUiO3M6MjI6InhpY29yZV9nZXR0aW5nX3N0YXJ0ZWQiO3M6NToidGl0bGUiO3M6MjE6IkdldHRpbmcgU3RhcnRlZCBHdWlkZSI7czo0OiJhcmdzIjthOjA6e319</div><div class="dashlettableinnercontent xicore_getting_started_outboard">
            <div class="getting_started_dashlet size-info" data-min-height="338" data-max-height="338" data-min-width="398" data-max-width="398" id="getting_started_lUs6hX"><div class="infotable_title">Getting Started Guide</div>
    <table class="infotable table table-condensed table-striped table-bordered" style="background-color: #FFF;">
    <tbody>
    <tr><td><span class="infotable_subtitle">Common Tasks:</span></td></tr><tr><td><ul><li><a href="http://nagiosxi/nagiosxi/account/" target="_top">Change your account settings</a><br>Change your account password and general preferences.</li><li><a href="http://nagiosxi/nagiosxi/account/?xiwindow=notifyprefs.php" target="_top">Change your notifications settings</a><br>Change how and when you receive alert notifications.</li><li><a href="http://nagiosxi/nagiosxi/config/" target="_top">Configure your monitoring setup</a><br>Add or modify items to be monitored with easy-to-use wizards.</li></ul></td></tr><tr><td><span class="infotable_subtitle">Getting Started:</span></td></tr><tr><td><ul><li><a href="https://www.nagios.com/products/nagios-xi/" target="_blank"><b>Learn about XI</b></a><br>Learn more about XI and its capabilities.</li><li><a href="https://www.nagios.com/products/nagios-xi/#stayinformed" target="_blank"><b>Signup for XI news</b></a><br>Stay informed on the latest updates and happenings for XI.</li></ul></td></tr>
    </tbody>
    </table>
    </div><!--getting_started_dashlet-->

            <script type="text/javascript">
            $(document).ready(function(){

                get_getting_started_lUs6hX_content();

                $("#getting_started_lUs6hX").everyTime(60000, "timer-getting_started_lUs6hX", function(i) {
                    get_getting_started_lUs6hX_content();
                });

                function get_getting_started_lUs6hX_content(){
                    $("#getting_started_lUs6hX").each(function(){
                        var optsarr = {
                            "func": "get_getting_started_html",
                            "args": ""
                            }
                        var opts=array2json(optsarr);
                        get_ajax_data_innerHTML("getxicoreajax",opts,true,this);
                        });
                    }

            });
            </script>
            </div></div>                    </div>
                </div>
                                <div class="well">
                    <div style="background-color: #FFF;">
                        <div class="dashlettable xicore_admin_tasks_outboard"><div class="dashifybutton"><a class="tt-bind" title="Add This To a Dashboard"><i class="fa fa-sign-in fa-rotate-270" style="font-size: 14px;"></i></a></div><div class="dashlettablecontentargs">YTozOntzOjQ6Im5hbWUiO3M6MTg6InhpY29yZV9hZG1pbl90YXNrcyI7czo1OiJ0aXRsZSI7czoyMDoiQWRtaW5pc3RyYXRpdmUgVGFza3MiO3M6NDoiYXJncyI7YTowOnt9fQ==</div><div class="dashlettableinnercontent xicore_admin_tasks_outboard">
            <div class="admin_task_dashlet size-info" data-min-height="198" data-max-height="198" data-min-width="288" data-max-width="288" id="admin_task_5jeRLH"><div class="infotable_title">Administrative Tasks</div>
        <table class="infotable table table-condensed table-striped table-bordered">
        <thead>
        <tr><th>Task</th></tr>
        </thead>
        <tbody>
        <tr><td><span class="infotable_subtitle">Ongoing Tasks:</span></td></tr><tr><td><ul><li><a href="http://nagiosxi/nagiosxi/config/" target="_top">Configure your monitoring setup</a><br>Add or modify items to be monitored.</li><li><a href="http://nagiosxi/nagiosxi/admin/?xiwindow=users.php" target="_top">Add new user accounts</a><br>Setup new users with access to Nagios XI.</li></ul></td></tr>
        </tbody>
        </table>
        </div><!--admin_task_dashlet-->

            <script type="text/javascript">
            $(document).ready(function(){

                get_admin_task_5jeRLH_content();

                $("#admin_task_5jeRLH").everyTime(60000, "timer-admin_task_5jeRLH", function(i) {
                    get_admin_task_5jeRLH_content();
                });

                function get_admin_task_5jeRLH_content(){
                    $("#admin_task_5jeRLH").each(function(){
                        var optsarr = {
                            "func": "get_admin_tasks_html",
                            "args": ""
                            }
                        var opts=array2json(optsarr);
                        get_ajax_data_innerHTML("getxicoreajax",opts,true,this);
                        });
                    }

            });
            </script>
            </div></div>                    </div>
                </div>
                            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3 span6">
                <div class="well">
                    <div style="background-color: #FFF;">
                        <div class="dashlettable xicore_host_status_summary_outboard"><div class="dashifybutton"><a class="tt-bind" title="Add This To a Dashboard"><i class="fa fa-sign-in fa-rotate-270" style="font-size: 14px;"></i></a></div><div class="dashlettablecontentargs">YTozOntzOjQ6Im5hbWUiO3M6MjY6InhpY29yZV9ob3N0X3N0YXR1c19zdW1tYXJ5IjtzOjU6InRpdGxlIjtzOjE5OiJIb3N0IFN0YXR1cyBTdW1tYXJ5IjtzOjQ6ImFyZ3MiO2E6MDp7fX0=</div><div class="dashlettableinnercontent xicore_host_status_summary_outboard">
            <div class="host_status_summary_dashlet size-info" data-min-height="158" data-max-height="158" data-min-width="258" data-max-width="0" id="host_status_summary_d0pchd"><div class="infotable_title">Host Status Summary</div>
        <table class="infotable table table-condensed table-striped table-bordered">
        <thead>
        <tr><th>Up</th><th>Down</th><th>Unreachable</th><th>Pending</th></tr>
        </thead>

        <tbody>
        <tr><td><div class="hostup havehostup"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=hosts&amp;hoststatustypes=2&amp;servicestatustypes=0">2</a></div></td><td><div class="hostdown"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=hosts&amp;hoststatustypes=4&amp;servicestatustypes=0">0</a></div></td><td><div class="hostunreachable"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=hosts&amp;hoststatustypes=8&amp;servicestatustypes=0">0</a></div></td><td><div class="hostpending"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=hosts&amp;hoststatustypes=1&amp;servicestatustypes=0">0</a></div></td></tr>
        </tbody>

        <thead>
        <tr><th colspan="2">Unhandled</th><th>Problems</th><th>All</th></tr>
        </thead>

        <tbody>
        <tr><td colspan="2"><div class="unhandledhostproblems"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=hosts&amp;servicestatustypes=0&amp;hoststatustypes=12&amp;hostattr=10">0</a></div></td><td><div class="hostproblems"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=hosts&amp;hoststatustypes=12&amp;servicestatustypes=0">0</a></div></td><td><div class="allhosts haveallhosts"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=hosts&amp;servicestatustypes=0">2</a></div></td></tr>
        </tbody>

        </table>
    <div class="ajax_date">Last Updated: 2017-05-10 14:39:00</div>
    </div><!--ahost_status_summary_dashlet-->

            <script type="text/javascript">
            $(document).ready(function(){

                get_host_status_summary_d0pchd_content();

                $("#host_status_summary_d0pchd").everyTime(60000, "timer-host_status_summary_d0pchd", function(i) {
                    get_host_status_summary_d0pchd_content();
                });

                function get_host_status_summary_d0pchd_content(){
                    $("#host_status_summary_d0pchd").each(function(){
                        var optsarr = {
                            "func": "get_host_status_summary_html",
                            "args": {}
                            }
                        var opts=array2json(optsarr);
                        get_ajax_data_innerHTML("getxicoreajax",opts,true,this);
                        });
                    }
            });
            </script>
            </div></div>                    </div>
                </div>
                <div class="well">
                    <div style="background-color: #FFF;">
                        <div class="dashlettable xicore_service_status_summary_outboard"><div class="dashifybutton"><a class="tt-bind" title="Add This To a Dashboard"><i class="fa fa-sign-in fa-rotate-270" style="font-size: 14px;"></i></a></div><div class="dashlettablecontentargs">YTozOntzOjQ6Im5hbWUiO3M6Mjk6InhpY29yZV9zZXJ2aWNlX3N0YXR1c19zdW1tYXJ5IjtzOjU6InRpdGxlIjtzOjIyOiJTZXJ2aWNlIFN0YXR1cyBTdW1tYXJ5IjtzOjQ6ImFyZ3MiO2E6MDp7fX0=</div><div class="dashlettableinnercontent xicore_service_status_summary_outboard">
            <div class="service_status_summary_dashlet size-info" data-min-height="158" data-max-height="158" data-min-width="298" data-max-width="0" id="host_status_summary_naHkgb"><div class="infotable_title">Service Status Summary</div>
        <table class="infotable table table-condensed table-striped table-bordered">
        <thead>
        <tr><th>Ok</th><th>Warning</th><th>Unknown</th><th>Critical</th><th>Pending</th></tr>
        </thead>

        <tbody>
        <tr><td><div class="serviceok haveserviceok"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=services&amp;hoststatustypes=15&amp;servicestatustypes=2">15</a></div></td><td><div class="servicewarning"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=services&amp;hoststatustypes=15&amp;servicestatustypes=4">0</a></div></td><td><div class="serviceunknown"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=services&amp;hoststatustypes=15&amp;servicestatustypes=8">0</a></div></td><td><div class="servicecritical"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=services&amp;hoststatustypes=15&amp;servicestatustypes=16">0</a></div></td><td><div class="servicepending"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=services&amp;hoststatustypes=15&amp;servicestatustypes=1">0</a></div></td></tr>
        </tbody>

        <thead>
        <tr><th colspan="2">Unhandled</th><th colspan="2">Problems</th><th>All</th></tr>
        </thead>

        <tbody>
        <tr><td colspan="2"><div class="unhandledserviceproblems"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=services&amp;hoststatustypes=15&amp;servicestatustypes=28&amp;serviceattr=10">0</a></div></td><td colspan="2"><div class="serviceproblems"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=services&amp;hoststatustypes=15&amp;servicestatustypes=28">0</a></div></td><td><div class="allservices haveallservices"><a href="http://nagiosxi/nagiosxi/includes/components/xicore/status.php?&amp;show=services&amp;hoststatustypes=15">15</a></div></td></tr>
        </tbody>

        </table>
    <div class="ajax_date">Last Updated: 2017-05-10 14:39:00</div>
    </div><!--service_status_summary_dashlet-->

            <script type="text/javascript">
            $(document).ready(function(){

                get_host_status_summary_naHkgb_content();

                $("#host_status_summary_naHkgb").everyTime(60000, "timer-host_status_summary_naHkgb", function(i) {
                    get_host_status_summary_naHkgb_content();
                });

                function get_host_status_summary_naHkgb_content(){
                    $("#host_status_summary_naHkgb").each(function(){
                        var optsarr = {
                            "func": "get_service_status_summary_html",
                            "args": {}
                            }
                        var opts=array2json(optsarr);
                        get_ajax_data_innerHTML("getxicoreajax",opts,true,this);
                        });
                    }
            });
            </script>
            </div></div>                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-5">
                <div class="well" style="overflow: hidden;">
                    <div style="display: table;">
                        <div style="display: table-cell; vertical-align: top; padding-right: 20px;">
                            <h3 style="font-size: 16px; margin: 0 0 10px 0;">We're Here To Help!</h3>
                            <p>Our knowledgeable techs are happy to help you with any questions or problems you may have getting Nagios up and running.</p>
                            <ul style="margin-bottom: 0;">
                                <li><a href="https://support.nagios.com/forum/">Support Forum</a> / <a href="https://support.nagios.com/forum/viewforum.php?f=16">Customer Support Forum</a></li>
                                <li><i class="fa fa-question"></i> <a href="http://nagiosxi/nagiosxi/help" target="_top">Help Resources</a></li>
                                <li>Email Support: <a href="mailto:customersupport@nagios.com">customersupport@nagios.com</a></li>
                                <li>Phone Support: +1 651-204-9102 Ext. 4</li>
                            </ul>
                        </div>
                        <div style="display: table-cell; vertical-align: top;">
                            <div class="ts-splash"></div>
                        </div>
                    </div>
                </div>
                                <div class="well">
                    <h3 style="font-size: 16px; margin: 0 0 5px 0;">Start Monitoring</h3>
                    <div class="container-fluid">
                        <div class="row" style="margin: 0 -25px;">
                            <div class="col-lg-12 col-xl-4">
                                <a href="http://nagiosxi/nagiosxi/?xiwindow=config/monitoringwizard.php" target="_top" class="sm-link">
                                    <img src="http://nagiosxi/nagiosxi/images/config-wizard.png">
                                    <span>Run a Config Wizard</span>
                                </a>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                <a href="http://nagiosxi/nagiosxi/?xiwindow=includes/components/autodiscovery/" target="_top" class="sm-link">
                                    <img src="http://nagiosxi/nagiosxi/includes/components/nagioscore/ui/images/logos/autodiscovery.png">
                                    <span>Run Auto-Discovery</span>
                                </a>
                            </div>
                            <div class="col-lg-12 col-xl-4">
                                                                <a href="http://nagiosxi/nagiosxi/includes/components/ccm/xi-index.php" target="_top" class="sm-link" style="padding-top: 14px;">
                                    <img src="http://nagiosxi/nagiosxi/includes/components/ccm/images/ccm.png" style="width: 70px;">
                                    <span>Advanced Config</span>
                                </a>
                                                            </div>
                        </div>
                    </div>
                </div>
                            </div>

        </div>
    </div>

    */