#!/bin/bash
PATH=$PATH:/sbin:/usr/sbin

BASEDIR=$(dirname $(readlink -f $0))

# Import Fusion config vars
. $BASEDIR/utils.sh
nagios_source_vars $BASEDIR/../var/fusion-sys.cfg

###############################
# USAGE / HELP
###############################
usage () {
	echo ""
	echo "Use this script change your Timezone for your Nagios Fusion system. (PHP and Localtime)"
	echo ""
	echo " -z | --zone             	The Posix & PHP supported timezone you want to change to"
	echo "                                  Example Timezone: America/Chicago"
	echo ""
	echo " -h | --help             	Show the help section"
	echo ""
}

###############################
# GET THE VARIABLES
###############################
while [ -n "$1" ]; do
	case "$1" in
		-h | --help)
			usage
			exit 0
			;;
		-z | --zone)
			TZONE=$2
			;;
	esac
	shift
done

if [ "x$TZONE" == "x" ] || [ ! -e /usr/share/zoneinfo/$TZONE ]; then
	echo "You must enter a proper time zone to change to (i.e. America/Chicago)"
	exit 1
fi

# Set the sysconfig clock time
if [ -e /etc/sysconfig/clock ]; then
	echo 'ZONE="'$TZONE'"' > /etc/sysconfig/clock
fi

# Set the localtime
ln -sf /usr/share/zoneinfo/$TZONE /etc/localtime

# Set the PHP timezone
for file in $(find /etc -name "php.ini"); do
	cp -f $file $file.backup
	sed -ri "s~^;?date\.timezone *=.*~date.timezone = $TZONE~" $file

# sleep so mysql doesn't die in the web application right after command is submitted
sleep 2

# Restart apache and databases to make sure timezone is properly set
$BASEDIR/manage_services.sh reload httpd
$BASEDIR/manage_services.sh restart mysqld

echo 'All timezone configurations updated to "'$TZONE'"'