#!/usr/bin/php
<?php
//
// Truncate All Polled Data
// Copyright (c) 2008-2017 Nagios Enterprises, LLC. All rights reserved.
//
define('SUBSYSTEM', 1);
require_once(dirname(__FILE__) . '/../html/includes/base.inc.php');

truncate_polled();

function truncate_polled() {

    global $db;

    $data = $db->exec_query('TRUNCATE polled_data');
    $extras = $db->exec_query('TRUNCATE polled_extras');
    $averages = $db->exec_query('TRUNCATE polled_averages');
    $deltas = $db->exec_query('TRUNCATE polled_deltas');

    // don't care about this status though
    $polling_lock = $db->exec_query('TRUNCATE polling_lock');

    if (!($data && $extras && $averages && $deltas)) {

        echo "Something went wrong:\n";
        print_r($db->get_errors());
        exit(1);
    }

    echo "polled tables truncated!\n";
}


