#!/bin/bash -e

. ./fusion-sys.cfg

# Was previous step completed?
if [ ! -f installed.general ]; then
    echo "General setup was not completed" >&2
    exit 1
fi

# Is basedir already installed?
if [ -f installed.basedir ]; then
    echo "Base directory structure already installed - skipping..."
    exit 0
fi

echo "Installing Nagios Fusion base files..."

echo "Creating product directory..."
if [ ! -d "$proddir" ]; then
    eval "$mkdirbin" -p "$proddir"
fi

# Copy over Fusion files
cp -r ../fusion/* "$proddir"

# Change ownership on directories and files
chown -R "root:$nagiosgroup" "$proddir"
chown -R "$nagiosuser:$nagiosgroup" "$proddir/var"
chmod 755 "$proddir"
chmod 775 "$proddir/var"
chmod 775 "$proddir/var/log"


# Ensure sudoers scripts are owned by root
for script in "upgrade_to_latest.sh" "change_timezone.sh" "manage_services.sh" "utils.sh" "import_fusionconfig.php"
do
    chown "root:$nagiosgroup" "$proddir/scripts/$script"
    chmod 554 "$proddir/scripts/$script"
done

# Set permissions on temp directory
chown -R "$apacheuser:$nagiosgroup" "$proddir/tmp"
chmod -R 6775 "$proddir/tmp"

# Add main Apache conf file
if [ "$distro" == "Debian" ] || [ "$distro" == "Ubuntu" ]; then
    cp inc/apache_2.4.conf "$httpdconfdir/nagiosfusion.conf"
    
    # Do some apache setup on debian/ubuntu
    a2enmod ssl
    a2enmod rewrite
    a2ensite default-ssl
    a2dissite 000-default
else
    if [ "$dist" == "el7" ] || [ "$dist" == "el8" ] || [ "$dist" == "el9" ]; then
        cp inc/apache_2.4.conf "$httpdconfdir/nagiosfusion.conf"
    else
        cp inc/httpd.conf "$httpdconfdir/nagiosfusion.conf"
    fi
fi

# Fix SSL sections to work
if [ "$distro" == "Debian" ] || [ "$distro" == "Ubuntu" ]; then
    ssl_conf="/etc/apache2/sites-available/default-ssl.conf"
    if [ -f $ssl_conf ] && [ $(grep "nagiosfusion/html/api" $ssl_conf | wc -l) -eq 0 ] && [ $(grep -c "</VirtualHost>" $ssl_conf) -eq 1 ]; then
        # Remove mod_ssl check
        sed -i 's/<IfModule mod_ssl.c>//' $ssl_conf
        sed -i 's/<\/IfModule>//' $ssl_conf
        # Generate a new ssl.conf with api mods
        grep -v "</VirtualHost>" $ssl_conf > $ssl_conf.new
        cat inc/apache_api.conf >> $ssl_conf.new
        echo "</VirtualHost>" >> $ssl_conf.new
        mv -f $ssl_conf.new $ssl_conf
    fi
else
    if [ -f $httpdconfdir/ssl.conf ] && [ $(grep "nagiosfusion/html/api" $httpdconfdir/ssl.conf | wc -l) -eq 0 ] && [ $(grep -c "</VirtualHost>" $httpdconfdir/ssl.conf) -eq 1 ]; then
        # Generate a new ssl.conf with api mods
        grep -v "</VirtualHost>" $httpdconfdir/ssl.conf > $httpdconfdir/ssl.conf.new
        cat inc/apache_api.conf >> $httpdconfdir/ssl.conf.new
        echo "</VirtualHost>" >> $httpdconfdir/ssl.conf.new
        mv -f  $httpdconfdir/ssl.conf.new  $httpdconfdir/ssl.conf
    fi
fi

# Restart Apache to apply perms
if [ ! `command -v systemctl` ]; then
    service $httpd restart
else
    systemctl restart $httpd
fi

# Install system config file
cp fusion-sys.cfg "$proddir/var/"
cp fusion-sys.cfg ../fusion/var/

# Set fusion uuid and source install type
if [ ! -f $proddir/var/fusion-uuid ]; then
    uuidgen >> $proddir/var/fusion-uuid
fi
echo "source" >> $proddir/var/fusion-itype
chown $nagiosuser:$nagiosgroup $proddir/var/fusion-*

echo "Base directory structure installed OK"
touch installed.basedir