#!/bin/bash -e

. ./fusion-sys.cfg

# Was previous step completed?
if [ ! -f installed.sourceguardian ]; then
    echo "SourceGuardian was not installed - run previous script" >&2
    exit 1
fi

# Is general already installed?
if [ -f installed.subsystem ]; then
    echo "Subsystem already installed - skipping..."
    exit 0
fi

# =============
# Cron
# -------------

# Install Nagios Fusion cron jobs
# We sleep so our calculations in finish.sh aren't off...
install -m 644 inc/cron.root /etc/cron.d/nagiosfusion
sleep 1

# Logrotate entry
cp inc/logrotate /etc/logrotate.d/nagiosfusion
sed -i "s|PRODDIR|$proddir|" /etc/logrotate.d/nagiosfusion

# Create backup directory
mkdir -p /store/backups/nagiosfusion

echo "Subsystem installed OK"
touch installed.subsystem