#!/bin/bash -e

. ./fusion-sys.cfg

# Save old web root page
if [ -f $httpdroot/index.html ]; then
    mv -f $httpdroot/index.html $httpdroot/index.html.orig
fi
if [ -f $httpdroot/index.php ]; then
    mv -f $httpdroot/index.php $httpdroot/index.php.orig
fi

# Apply to top level directory too
if [ "$distro" == "Ubuntu" ] || [ "$distro" == "Debian" ]; then
	cp inc/webroot.php /var/www/index.php
fi

# New web root index page
cp inc/webroot.php $httpdroot/index.php

# Determine how much time we have until the next cron */5 (for poll_subsys)
SECONDS=$(( 60 - 10#$(date +%S) ))

# Start the cron scripts running
if [ $SECONDS -lt 60 ]; then
    su - nagios -c "/usr/bin/php -q /usr/local/nagiosfusion/cron/auth_subsys.php --max-time=$SECONDS >/usr/local/nagiosfusion/var/log/auth_subsys.log 2>&1 &"
    su - nagios -c "/usr/bin/php -q /usr/local/nagiosfusion/cron/cmd_subsys.php --max-time=$SECONDS >/usr/local/nagiosfusion/var/log/cmd_subsys.log 2>&1 &"
    su - nagios -c "/usr/bin/php -q /usr/local/nagiosfusion/cron/log_subsys.php --max-time=$SECONDS >/usr/local/nagiosfusion/var/log/log_subsys.log 2>&1 &"
    su - nagios -c "/usr/bin/php -q /usr/local/nagiosfusion/cron/sysstat_subsys.php --max-time=$SECONDS >/usr/local/nagiosfusion/var/log/sysstat_subsys.log 2>&1 &"
    su - nagios -c "/usr/bin/php -q /usr/local/nagiosfusion/cron/poll_subsys.php --max-time=$SECONDS >/usr/local/nagiosfusion/var/log/poll_subsys.log 2>&1 &"
fi
