#!/bin/bash

. ./fusion-sys.cfg

echo "Installing AD/LDAP component..."

# Install php-ldap if it's not already installed
# comes pre-installed in ubuntu and debian XI versions
if [ `command -v yum` ]; then
	yum install php-ldap -y
fi

if [ "$distro" == "Ubuntu" ] || [ "$distro" == "Debian" ]; then
	ldap_config="/etc/ldap/ldap.conf"
	ldap_dir="/etc/ldap"
	cacerts_dir="/etc/ldap/cacerts"
else
	ldap_config="/etc/openldap/ldap.conf"
	ldap_dir="/etc/openldap"
	cacerts_dir="/etc/openldap/cacerts"
fi

# Set the permissions of the openldap configuration files/folders
mkdir -p $cacerts_dir
if [ "$distro" == "Ubuntu" ] || [ "$distro" == "Debian" ]; then
	mkdir -p /etc/ldap/certs
	chown $apacheuser.$nagiosgroup /etc/ldap /etc/ldap/certs $cacerts_dir $ldap_config
	chmod 775 /etc/ldap /etc/ldap/certs $cacerts_dir
else
	mkdir -p /etc/openldap/certs
	chown $apacheuser.$nagiosgroup /etc/openldap /etc/openldap/certs $cacerts_dir $ldap_config
	chmod 775 /etc/openldap /etc/openldap/certs $cacerts_dir
fi
chmod 664 $ldap_config

# Edit line in ldap config
sed -i 's/TLS_CACERTDIR/#TLS_CACERTDIR/g' $ldap_config
echo "TLS_CACERTDIR $ldap_dir/cacerts" >> $ldap_config

