# API key for NLS
DROP PROCEDURE IF EXISTS `SERVERS_LOGSERVER_TOKEN`;
DELIMITER //
CREATE PROCEDURE `SERVERS_LOGSERVER_TOKEN`()
BEGIN
    DECLARE CONTINUE HANDLER FOR SQLEXCEPTION BEGIN END;
    ALTER TABLE `fusion`.`servers` ADD COLUMN logserver_token varchar(128);
END //
DELIMITER ;
CALL `SERVERS_LOGSERVER_TOKEN`();
DROP PROCEDURE `SERVERS_LOGSERVER_TOKEN`;

# XI version for determining which authentication method to use
DROP PROCEDURE IF EXISTS `SERVERS_VERSION`;
DELIMITER //
CREATE PROCEDURE `SERVERS_VERSION`()
BEGIN
    DECLARE CONTINUE HANDLER FOR SQLEXCEPTION BEGIN END;
    ALTER TABLE `fusion`.`servers` ADD COLUMN version varchar(128);
END //
DELIMITER ;
CALL `SERVERS_VERSION`();
DROP PROCEDURE `SERVERS_VERSION`;

# Add auth tokens table
CREATE TABLE IF NOT EXISTS `fusion`.`auth_tokens` (
    `auth_token_id` int auto_increment,
    `auth_user_id` int NOT NULL,
    `auth_session_id` int NOT NULL,
    `auth_token` varchar(128),
    `auth_valid_until` datetime,
    `auth_expires_at` datetime,
    `auth_restrictions` mediumtext,
    `auth_used` smallint default 0,
    primary key (`auth_token_id`),
    unique (`auth_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
