
CREATE DATABASE IF NOT EXISTS `fusion`;
CREATE USER 'fusion'@'localhost' IDENTIFIED BY 'fusion';
GRANT ALL ON fusion.* TO 'fusion'@'localhost';


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`log` (
    `log_id` int unsigned auto_increment,

    `processed` tinyint not null default 0,

    `log_time` timestamp not null default current_timestamp,

    `server_id` int unsigned not null default 0,
    `user_id` int unsigned not null default 0,

    `level` tinyint unsigned not null default 0, 
    `type` tinyint unsigned not null default 0,

    `message` text not null,

    primary key (`log_id`)

    # major performance enhancements via indexes for queries
    # TODO: automate this (similar to large_installation_tweaks in core)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`commands` (
    `command_id` int unsigned auto_increment,

    `user_id` int unsigned not null default 0,

    `command` smallint unsigned not null default 0,

    `submission_time` timestamp not null default current_timestamp,
    `scheduled_time` timestamp not null default current_timestamp,
    `start_time` timestamp not null default current_timestamp,
    `processing_time` int,

    `status_code` int not null default 0,
    `result_code` int not null default 0,

    `command_data` text,
    `result` text,

    primary key (`command_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`views` (
    `view_id` int unsigned auto_increment,

    `user_id` int unsigned not null default 0,

    `view_order` smallint unsigned not null default 65535,
    `view_title` varchar(64) not null,
    `view_url` text,

    primary key (`view_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`meta` (
    `meta_id` int unsigned auto_increment,

    `obj_type` smallint unsigned default 0,
    `obj_id` int unsigned default 0,

    `meta_key` varchar(128) not null,
    `meta_value` text,
    `autoload` tinyint not null default 0,

    primary key (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`options` (
    `option_id` int unsigned auto_increment,

    `name` varchar(128) not null,
    `value` text,

    primary key (`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`sysstat` (
    `sysstat_id` int unsigned auto_increment,

    `server_id` int unsigned not null default 0,

    `metric` varchar(32) not null,
    `value` text,

    `update_time` timestamp not null default current_timestamp on update current_timestamp,

    primary key (`sysstat_id`),
    constraint `sysstat_uniq` unique (`server_id`, `metric`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`users` (
    `user_id` int unsigned auto_increment,

    `username` varchar(64) not null,
    `password` varchar(64) not null,

    `name` varchar(100),
    `email` varchar(128) not null,
    `level` smallint default 0,

    `backend_ticket` varchar(128),
    `enabled` smallint default 1,
    `api_key` varchar(128),
    `api_enabled` smallint default 0,

    `password_set_time` timestamp not null default current_timestamp,
    `account_locked` tinyint unsigned default 0,
    `last_login_time` timestamp,
    `recent_login_failures` tinyint unsigned default 0,
    `last_login_failure_time` timestamp,
    `skip_local_auth` tinyint unsigned default 0,
    `times_logged_in` int unsigned,

    primary key (`user_id`),
    constraint `users_uniq` unique (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`users_servers` (
    `user_id` int unsigned,
    `server_id` int unsigned,

    `type` tinyint unsigned default 0,
    `enabled` tinyint unsigned default 1,

    `username` varchar(128),
    `password` varchar(128),

    primary key (`user_id`, `server_id`, `type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`servers` (
    `server_id` int unsigned auto_increment,

    `enabled` tinyint unsigned default 1,
    `auto_login` tinyint unsigned default 1,

    `name` varchar(128) not null,
    `address` varchar(128) not null default '',

    `server_type` smallint not null default 0,
    `authentication_type` smallint not null default 0,

    `url` varchar(128) not null,
    `cgi_bin` varchar(64),
    `ssl_hostname_verify` tinyint default 0,
    `location` varchar(128),
    `notes` text,

    `fusekey` varchar(128),
    `username` varchar(128) not null default '',
    `password` varchar(128),
    `logserver_token` varchar(128),
    `version` varchar(128),

    `last_auth_time` timestamp null default null,
    `polling_interval` smallint unsigned not null default 0,
    `auth_interval` smallint unsigned not null default 0,
    `ignore_xi_meta` tinyint unsigned not null default 0,
    `timezone` varchar(32),

    primary key (`server_id`),
    constraint `servers_uniq` unique (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`dashboards` (
    `dashboard_id` int unsigned auto_increment,

    `user_id` int unsigned,

    `dashboard_name` varchar(256) not null,

    `sync` int unsigned not null default 0,
    `home` tinyint unsigned not null default 0,
    `screen` tinyint unsigned not null default 0,
    `show_in_menu` tinyint unsigned not null default 1,
    `bgcolor` varchar(6) not null default 'ffffff',
    `dashlet_x` smallint unsigned not null default 10,
    `dashlet_y` smallint unsigned not null default 10,

    primary key (`dashboard_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`dashlets` (
    `dashlet_id` int unsigned auto_increment,

    `dashboard_id` int unsigned,

    `dashlet_name` text not null,
    `load_url` text not null,

    `show_title` tinyint unsigned not null default 1,
    `pinned` tinyint unsigned not null default 0,
    `title` varchar(256) not null default '',
    `bgcolor` varchar(6) not null default 'ffffff',
    `opacity` decimal(3, 2) not null default 1.00,
    `refresh` smallint not null default 0,
    `zindex` smallint not null default 1,
    `padding` tinyint unsigned not null default 10,
    `width` smallint unsigned not null default 300,
    `height` smallint unsigned not null default 200,
    `x` smallint not null,
    `y` smallint not null,

    primary key (`dashlet_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;



##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`dashlets_params` (
    `dashlet_id` int unsigned,

    `param` varchar(128),
    `val` text,

    primary key (`dashlet_id`, `param`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`polling_lock` (
    `polling_lock_id` int unsigned auto_increment,

    `server_id` int unsigned,
    `username` varchar(128) not null,

    `polling_started` timestamp,

    primary key (`polling_lock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`polled_data` (
    `polled_data_id` int unsigned auto_increment,

    `server_id` int unsigned,
    `username` varchar(128) not null default '',

    `polled_time` timestamp not null default current_timestamp,

    `active_checks` tinyint unsigned default 0,
    `passive_checks` tinyint unsigned default 0,
    `event_handlers` tinyint unsigned default 0,
    `monitoring_engine` tinyint unsigned default 0,
    `notifications` tinyint unsigned default 0,

    `hosts_count` int unsigned default 0,
    `hosts_pending` int unsigned default 0,
    `hosts_up` int unsigned default 0,
    `hosts_down` int unsigned default 0,
    `hosts_unreachable` int unsigned default 0,

    `hosts_disabled` int unsigned default 0,
    `hosts_problems` int unsigned default 0,
    `hosts_problems_unhandled` int unsigned default 0,
    `hosts_acknowledged` int unsigned default 0,
    `hosts_flapping` int unsigned default 0,
    `hosts_downtime` int unsigned default 0,
    `hosts_pending_disabled` int unsigned default 0,
    `hosts_up_disabled` int unsigned default 0,
    `hosts_up_downtime` int unsigned default 0,
    `hosts_down_disabled` int unsigned default 0,
    `hosts_down_acknowledged` int unsigned default 0,
    `hosts_down_downtime` int unsigned default 0,
    `hosts_unreachable_disabled` int unsigned default 0,
    `hosts_unreachable_acknowledged` int unsigned default 0,
    `hosts_unreachable_downtime` int unsigned default 0,

    `services_count` int unsigned default 0,
    `services_pending` int unsigned default 0,
    `services_ok` int unsigned default 0,
    `services_warning` int unsigned default 0,
    `services_critical` int unsigned default 0,
    `services_unknown` int unsigned default 0,

    `services_disabled` int unsigned default 0,
    `services_problems` int unsigned default 0,
    `services_problems_unhandled` int unsigned default 0,
    `services_acknowledged` int unsigned default 0,
    `services_flapping` int unsigned default 0,
    `services_downtime` int unsigned default 0,
    `services_pending_disabled` int unsigned default 0,
    `services_ok_disabled` int unsigned default 0,
    `services_ok_downtime` int unsigned default 0,
    `services_warning_disabled` int unsigned default 0,
    `services_warning_acknowledged` int unsigned default 0,
    `services_warning_downtime` int unsigned default 0,
    `services_critical_disabled` int unsigned default 0,
    `services_critical_acknowledged` int unsigned default 0,
    `services_critical_downtime` int unsigned default 0,
    `services_unknown_disabled` int unsigned default 0,
    `services_unknown_acknowledged` int unsigned default 0,
    `services_unknown_downtime` int unsigned default 0,

    primary key (`polled_data_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;



##############################################################################
CREATE TABLE IF NOT EXISTS `fusion`.`polled_extras` (
    `polled_extra_id` int unsigned auto_increment,

    `polled_data_id` int unsigned,

    `poll_key` varchar(128),
    `extra_value` longtext,

    primary key (`polled_extra_id`),
    constraint `polled_extras_uniq` unique (`polled_data_id`, `poll_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;



##############################################################################
# performance index: poll_key,username
CREATE TABLE IF NOT EXISTS `fusion`.`polled_averages` (
    `polled_average_id` int unsigned auto_increment,

    `server_id` int unsigned,
    `username` varchar(128) not null default '',

    `poll_key` varchar(128),
    `count` int unsigned,
    `average_value` decimal(20, 7),

    primary key (`polled_average_id`),
    constraint `polled_averages_uniq` unique (`poll_key`, `username`, `server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



##############################################################################
# performance index: poll_key,username,polled_time
CREATE TABLE IF NOT EXISTS `fusion`.`polled_deltas` (
    `polled_delta_id` int unsigned auto_increment,

    `server_id` int unsigned,
    `username` varchar(128) not null default '',

    `poll_key` varchar(128),
    `polled_time` timestamp not null default current_timestamp,
    `delta` decimal(20, 7),

    primary key (`polled_delta_id`),
    constraint `polled_deltas_uniq` unique (`poll_key`, `username`, `server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


##############################################################################
# auth_tokens
CREATE TABLE IF NOT EXISTS `fusion`.`auth_tokens` (
    `auth_token_id` int auto_increment,
    `auth_user_id` int NOT NULL,
    `auth_session_id` int NOT NULL,
    `auth_token` varchar(128),
    `auth_valid_until` datetime,
    `auth_expires_at` datetime,
    `auth_restrictions` mediumtext,
    `auth_used` smallint default 0,
    primary key (`auth_token_id`),
    unique (`auth_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


##############################################################################
# sessions
CREATE TABLE IF NOT EXISTS `fusion`.`users_sessions` (
    `session_id` int auto_increment,
    `session_phpid` varchar(128),
    `session_created` datetime,
    `session_user_id` int NOT NULL,
    `session_address` varchar(128),
    `session_page` varchar(255),
    `session_data` text,
    `session_last_active` timestamp,
    primary key (`session_id`),
    unique (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

