#!/bin/bash

######################################################################
# Print usage
usage() {
    fmt -s -w $(tput cols) <<-EOF

Nagios Fusion installer script
Copyright 2017-2019 - Nagios Enterprises LLC.
License:
    Nagios Software License <http://assets.nagios.com/licenses/nagios_software_license.txt>
Support:
    Nagios Support <http://support.nagios.com/>

Usage: install [options...]

Options:
    -h | --help
        Display this help text
    -n | --non-interactive
        Assume defaults for all questions (for scripted installs)
    -f | --force-addon-update (for upgrade only)
        Force components and dashlets to be updated
    -p | --mysql-password (for install only)
        Specify custom MySQL root password.
    -v | --version
        Show the version of Fusion to be installed (and existing version, for upgrades)

IMPORTANT: This script should only be used on a 'clean' install of CentOS or RedHat. To create such a clean install you should have selected ONLY the 'Base' package in the OS installer.

EOF
}


######################################################################
# Wrapper function for installation scripts
run_sub() {
    echo "Running '$1'..."

    # Run the command and copy output to installer log
    # Fail file is a portable bourne shell alternative to $PIPESTATUS
    FAILFILE=".fail-$$"
    rm -f "$FAILFILE"
    (eval "$@" 2>&1 || echo $? > "$FAILFILE") | tee -a "$log"
    echo "RESULT=$(cat "$FAILFILE" 2>/dev/null || echo 0)"
    if [ -f "$FAILFILE" ]; then
        cat >&2 <<-EOF

===================
INSTALLATION ERROR!
===================
Installation step failed - exiting.
Check for error messages in the install log (install.log).

If you require assistance in resolving the issue, please include install.log
in your communications with Nagios technical support.

The script that failed was: '$1'

EOF
        exit 1
    fi
    rm -f "$FAILFILE"
}


######################################################################
# Check that /sbin & /usr/sbin are in $PATH
path_is_ok() {
    echo "$PATH" \
    | awk 'BEGIN{RS=":"} {p[$0]++} END{if (p["/sbin"] && p["/usr/sbin"]) exit(0); exit(1)}'
}


######################################################################
# Do OS check (EOL for CentOS/RHEL 5)
if [ "$dist" == "el5" ]; then
    {
    echo "------------------------------"
    echo " CentOS/RHEL 5 - End of Life"
    echo "------------------------------"
    echo ""
    echo "Nagios Fusion no longer supports CentOS/RHEL 5 due to it being EOL as of 3/31/2017."
    echo "If you'd like to install Nagios Fusion, you will need to install it on"
    echo "a supported distro such as CentOS/RHEL 6 or 7."
    echo ""
    echo "Or for more detailed information on how to transition, please visit "
    echo "the Nagios support forum:"
    echo "https://support.nagios.com/forum/"
    echo ""
    } | tee -a "$log"
    exit 1
fi
