#!/bin/bash
 
#
# Sets up the fusion-sys.cfg file on install
#

SETVARDIR=$(dirname $(readlink -f $0))
setvar() {
    ${SETVARDIR}/set-fusion-var.sh "$1" "$2"
    eval "$1"=\"\$2\"
}

# Add a newline at end of file just in case there isn't one
printf "\n" >> fusion-sys.cfg

# Fusion version
setvar fusionver $(sed -n '/full/ s/.*=\(.*\)/\L\1/p' ./../fusion/var/fusionversion)

# OS-related variables have a detailed long variable, and a more useful short
# one: distro/dist, version/ver, architecture/arch. If in doubt, use the short
. ./get-os-info.sh
setvar distro  "$distro"
setvar version "$version"
setvar ver     "${version%%.*}" # short major version, e.g. "6" instead of "6.2"
setvar architecture "$architecture"

# Set dist variable like before (el5/el6 on both CentOS & Red Hat)
case "$distro" in
    CentOS | RedHatEnterpriseServer | OracleServer | CloudLinux )
        setvar dist "el$ver"
        ;;
    Fedora )
        setvar dist "fedora$ver"
        ;;
    Debian )
        setvar dist "debian$ver"
        ;;
    "SUSE LINUX" )
        setvar dist "suse$ver"
        ;;
    *)
        setvar dist $(echo "$distro$ver" | tr A-Z a-z)
esac

# Architecture for el5
if [ "$dist $architecture" = "el5 i686" ]; then
    setvar arch i386
else
    setvar arch "$architecture"
fi

case "$dist" in
    el6 | el7 | el8 | el9)
        if [ "$arch" = "x86_64" ]; then
            setvar php_extension_dir /usr/lib64/php/modules
        fi
        if [ "$dist" == "el7" ] || [ "$dist" == "el8" ] || [ "$dist" == "el9" ]; then
            setvar mysqld mariadb
        fi
        if [ "$dist" == "el8" ] || [ "$dist" == "el9" ]; then
            setvar ntpd chronyd
        fi
        ;;
    suse11 | suse12 )
        if [ "$arch" = "x86_64" ]; then
            setvar php_extension_dir /usr/lib64/php5/extensions
            setvar apacheuser wwwrun
            setvar apachegroup www
            setvar httpdconfdir /etc/apache2/conf.d
            setvar httpdconf /etc/apache2/httpd.conf
            setvar httpdroot /srv/www/htdocs
            setvar phpini /etc/php5/cli/php.ini
            setvar phpconfd /etc/php5/conf.d
            setvar htpasswdbin /usr/bin/htpasswd2
            setvar httpd apache2
            setvar ntpd ntp
            setvar crond cron
            setvar mysqld mysql
        fi
        ;;
    ubuntu14 | ubuntu16 | ubuntu18 | ubuntu20 | ubuntu22 | ubuntu24 | debian8 | debian9 | debian10  | debian11 | debian12 )
            setvar apacheuser www-data
            setvar apachegroup www-data
            setvar httpdconf /etc/apache2/apache2.conf
            setvar httpdconfdir /etc/apache2/conf-enabled
            setvar httpdroot /var/www/html
            setvar phpini /etc/php5/apache2/php.ini
            setvar phpconfd /etc/php5/apache2/conf.d
            setvar phpconfdcli /etc/php5/cli/conf.d
            setvar mibsdir /usr/share/mibs
            setvar httpd apache2
            setvar ntpd ntp
            setvar crond cron
            setvar mysqld mysql
        if [ "$dist" == "ubuntu16" ]; then
            setvar phpini /etc/php/7.0/apache2/php.ini
            setvar phpconfd /etc/php/7.0/apache2/conf.d
            setvar phpconfdcli /etc/php/7.0/cli/conf.d
        elif [ "$dist" == "ubuntu18" ]; then
            setvar mibsdir /usr/share/snmp/mibs
            setvar phpini /etc/php/7.2/apache2/php.ini
            setvar phpconfd /etc/php/7.2/apache2/conf.d
            setvar phpconfdcli /etc/php/7.2/cli/conf.d
        elif [ "$dist" == "ubuntu20" ]; then
            setvar mibsdir /usr/share/snmp/mibs
            setvar phpini /etc/php/7.4/apache2/php.ini
            setvar phpconfd /etc/php/7.4/apache2/conf.d
            setvar phpconfdcli /etc/php/7.4/cli/conf.d
        elif [ "$dist" == "ubuntu22" ]; then
            setvar mibsdir /usr/share/snmp/mibs
            setvar phpini /etc/php/8.1/apache2/php.ini
            setvar phpconfd /etc/php/8.1/apache2/conf.d
            setvar phpconfdcli /etc/php/8.1/cli/conf.d
        elif [ "$dist" == "ubuntu24" ]; then
            setvar ntpd ntpsec
            setvar mibsdir /usr/share/snmp/mibs
            setvar phpini /etc/php/8.3/apache2/php.ini
            setvar phpconfd /etc/php/8.3/apache2/conf.d
            setvar phpconfdcli /etc/php/8.3/cli/conf.d
        elif [ "$dist" == "debian9" ]; then
            setvar mibsdir /usr/share/snmp/mibs
            setvar phpini /etc/php/7.0/apache2/php.ini
            setvar phpconfd /etc/php/7.0/apache2/conf.d
            setvar phpconfdcli /etc/php/7.0/cli/conf.d
        elif [ "$dist" == "debian10" ]; then
            setvar mibsdir /usr/share/snmp/mibs
            setvar phpini /etc/php/7.3/apache2/php.ini
            setvar phpconfd /etc/php/7.3/apache2/conf.d
            setvar phpconfdcli /etc/php/7.3/cli/conf.d
            setvar mysqld mariadb
        elif [ "$dist" == "debian11" ]; then
            setvar mibsdir /usr/share/snmp/mibs
            setvar phpini /etc/php/7.4/apache2/php.ini
            setvar phpconfd /etc/php/7.4/apache2/conf.d
            setvar phpconfdcli /etc/php/7.4/cli/conf.d
            setvar mysqld mariadb
        elif [ "$dist" == "debian12" ]; then
            setvar ntpd ntpsec
            setvar mibsdir /usr/share/snmp/mibs
            setvar phpini /etc/php/8.2/apache2/php.ini
            setvar phpconfd /etc/php/8.2/apache2/conf.d
            setvar phpconfdcli /etc/php/8.2/cli/conf.d
            setvar mysqld mariadb
        fi
        ;;
    *)
        :
esac

# Make sure we are using the exact php extension dir
if [ `command -v php-config` ]; then
    php_extension_dir=$(php-config --extension-dir)
    setvar php_extension_dir $php_extension_dir
fi
