#!/bin/bash -e

# Version 2014 R1.1 was Release 301
# Anything before that needs to be upgraded
# To Version 2014 R1.1 before attempting to upgrade to Fusion 4
if [ "$oldversion" -lt 301 ]; then
    {
    echo ""
    echo "----------------------------------------------"
    echo " Fusion 4 Incompatible with Installed Version"
    echo "----------------------------------------------"
    echo ""
    echo "In order to upgrade to Nagios Fusion 4, you'll first need to upgrade"
    echo "your version of Nagios Fusion to 2014r1.1."
    echo ""
    echo "You can find previous versions of Nagios Fusion here:"
    echo "https://assets.nagios.com/downloads/nagiosfusion/versions.php"
    echo ""
    echo "And don't you can reach out for help at the Nagios support forum:"
    echo "https://support.nagios.com/forum/"
    echo ""
    } | tee -a "$log"
    exit 1
fi