<?php
define('SUBSYSTEM', 1);
require_once('/usr/local/nagiosfusion/html/includes/base.inc.php');

$servers = file_get_contents('/tmp/servers.csv');
$credentials = file_get_contents('/tmp/credentials.csv');

// there are some double quote issues, and some escaped double quote issues (rhel/cent7), and then after that..
$servers = str_replace(array('\\""', '""'), '"', $servers);
$credentials = str_replace(array('\\""', '""'), '"', $credentials);

// sometimes it removes the quotes that are required for a 0 len serialized string
$servers = str_replace('0:";', '0:"";', $servers);
$credentials = str_replace('0:";', '0:"";', $credentials);

$servers = unserialize($servers);
$credentials = unserialize($credentials);

if (($servers === false) || ($credentials === false)) {

    echo "There was a problem importing servers and credentials.\n";
    $cont = strtolower(readline("Would you like to continue with the upgrade? [Y/n] "));
    if (strpos($cont, 'y') === 0) {
        echo "\nContinuing...\n";
    } else {
        echo "\nExiting...\n";
        exit(1);
    }
}

foreach ($servers as $id => $server) {

    // check for valid credentials..
    if (!isset($credentials[$id]) || !isset($credentials[$id]['username']) || !isset($credentials[$id]['password'])) {

        echo "Unable to grab credential data for server: {$server['name']}\n";
        $cont = strtolower(readline("Would you like to continue with the upgrade? [Y/n] "));
        if (strpos($cont, 'y') !== 0) {
            echo "\nExiting...\n";
            exit(1);
        }
        continue;
    }

    // check for valid server data
    if (empty($server['name']) || empty($server['type']) || empty($server['url'])) {

        echo "Unable to grab credential data for server: {$server['name']}\n";
        $cont = strtolower(readline("Would you like to continue with the upgrade? [Y/n] "));
        if (strpos($cont, 'y') !== 0) {
            echo "\nExiting...\n";
            exit(1);
        }
        continue;
    }

    $username = $credentials[$id]['username'];
    $password = _encrypt($credentials[$id]['password']);

    $url = $server['url'];
    if (!empty($server['internal_url']))
        $url = $server['internal_url'];

    $name = $server['name'];

    $cgi_bin = '';
    if ($server['type'] == 'nagiosxi') {

        $server_type = SERVER_TYPE_XI;
        $authentication_type = AUTH_TYPE_SESSION;

    } else if ($server['type'] == 'nagioscore') {

        $server_type = SERVER_TYPE_CORE;
        $authentication_type = AUTH_TYPE_BASIC;
        $cgi_bin = '/cgi-bin/';

    } else {

        echo "Unable to determine server type for server: {$server['name']}\n";
        $cont = strtolower(readline("Would you like to continue with the upgrade? [Y/n] "));
        if (strpos($cont, 'y') !== 0) {
            echo "\nExiting...\n";
            exit(1);
        }
    }

    $location = '';
    if (!empty($server['location']))
        $location = $server['location'];

    $notes = '';
    if (!empty($server['notes']))
        $notes = $server['notes'];

    $timezone = date_default_timezone_get();

    $server_id = add_server($enabled = 1, $name, $server_type, $authentication_type, $url, $cgi_bin, $location, $timezone, $notes);
    if ($server_id == false) {

        echo "Recreating failed for server: {$server['name']}\n";
        $cont = strtolower(readline("Would you like to continue with the upgrade? [Y/n] "));
        if (strpos($cont, 'y') !== 0) {
            echo "\nExiting...\n";
            exit(1);
        }
    } else {
        set_server_attr('username', $username, $server_id);
        set_server_attr('password', $password, $server_id);
    }
}

// update this so that we don't need to install fusion again
set_option('install_version', '2014r1.1');
set_option('db_version', '1');
/*
    `server_id` int unsigned auto_increment,

    `enabled` tinyint unsigned default 1,
    `auto_login` tinyint unsigned default 1,

    `name` varchar(128) not null,
    `address` varchar(128) not null,

    `server_type` smallint not null default 0,
    `authentication_type` smallint not null default 0,

    `url` varchar(128) not null,
    `cgi_bin` varchar(64),
    `location` varchar(128),
    `notes` text,

    `fusekey` varchar(128),
    `username` varchar(128) not null default '',
    `password` varchar(128),

    `last_auth_time` timestamp null default null,
    `polling_interval` smallint unsigned not null default 0,
    `auth_interval` smallint unsigned not null default 0,
    `ignore_xi_meta` tinyint unsigned not null default 0,
    `timezone` varchar(32),


this is the values of two servers added to old fusion in the options table

Array
(
    [k22rl0] => Array
        (
            [name] => Heden
            [address] => 192.168.6.252
            [type] => nagiosxi
            [auth] => session
            [url] => http://192.168.6.252/nagiosxi/
            [internal_url] => 
            [location] => VMWare Workstation
            [notes] => 
        )

    [e4sioh] => Array
        (
            [name] => HedenCore
            [address] => 192.168.6.252
            [type] => nagioscore
            [auth] => basic
            [url] => http://192.168.6.252/nagios/
            [internal_url] => 
            [location] => VMWare Workstation
            [notes] => 
        )

)
Array
(
    [k22rl0] => Array
        (
            [display] => 1
            [username] => nagiosadmin
            [password] => nagiosadmin
        )

    [e4sioh] => Array
        (
            [display] => 1
            [username] => nagiosadmin
            [password] => nagiosadmin
        )

)

$servers = unserialize('a:2:{s:6:"k22rl0";a:8:{s:4:"name";s:5:"Heden";s:7:"address";s:13:"192.168.6.252";s:4:"type";s:8:"nagiosxi";s:4:"auth";s:7:"session";s:3:"url";s:30:"http://192.168.6.252/nagiosxi/";s:12:"internal_url";s:0:"";s:8:"location";s:18:"VMWare Workstation";s:5:"notes";s:0:"";}s:6:"e4sioh";a:8:{s:4:"name";s:9:"HedenCore";s:7:"address";s:13:"192.168.6.252";s:4:"type";s:10:"nagioscore";s:4:"auth";s:5:"basic";s:3:"url";s:28:"http://192.168.6.252/nagios/";s:12:"internal_url";s:0:"";s:8:"location";s:18:"VMWare Workstation";s:5:"notes";s:0:"";}}');
$server_credentials = unserialize('a:2:{s:6:"k22rl0";a:3:{s:7:"display";i:1;s:8:"username";s:11:"nagiosadmin";s:8:"password";s:11:"nagiosadmin";}s:6:"e4sioh";a:3:{s:7:"display";i:1;s:8:"username";s:11:"nagiosadmin";s:8:"password";s:11:"nagiosadmin";}}');

print_r($servers);
print_r($server_credentials);

$servers_sql = "SELECT * FROM fusion_options WHERE name = 'servers' OR name = 'server_credentials';"
$users_sql = "SELECT * FROM fusion_users;";

\copy (SELECT * FROM fusion_options WHERE name = 'servers') To '/tmp/servers.csv' With CSV DELIMITER ','
\copy (SELECT * FROM fusion_options WHERE name = 'server_credentials') To '/tmp/credentials.csv' With CSV DELIMITER ','
\copy (SELECT * FROM fusion_users) To '/tmp/users.csv' With CSV DELIMITER ','



echo "test1,test2,\"test,3\"" | awk 'BEGIN { FPAT = "([^, ]+)|([^\"]+)" } END { gsub(/"/, ""); print $1 $2 $3 }'
cat users.csv | awk -F, -v q="'" '{ print "INSERT INTO users (username, password, name, email, enabled, level) VALUES ("q $2 q", "q $3 q", "q $4 q", "q $5 q", " $7 ", 1)" }'
*/