#!/bin/bash -e

# Fusion 4.1
if [ "$oldversion" -lt 4100 ]; then

    # force components to update
    export FORCE_ADDON_UPGRADE="True"

    . ./000-fix-ibdata.sh

    echo "Installing AD/LDAP component..."
    pushd ../
   
    ./11-ad-ldap-integration.sh
    
    popd
    
    # Cleanup scratch data files
    if [ "$errors" = "False" ]; then
        echo "Removing tmp data.."

        rm databases
        rm -r databasebackups
    fi

    # Update apache config
    echo "Update apache configuration..."
    # We use the absolute path of cp here due to default aliasing on some distros
    if [ "$dist" == "debian9" ] || [ "$dist" == "el7" ]; then
        /bin/cp -f ../inc/apache_2.4.conf "$httpdconfdir/nagiosfusion.conf"
    else
        /bin/cp -f ../inc/httpd.conf "$httpdconfdir/nagiosfusion.conf"
    fi
    "$proddir/scripts/manage_services.sh" restart httpd

fi
