#!/bin/bash -e

# Fusion 4.2.0
if [ "$oldversion" -lt 4200 ]; then

    # Set up languages for the install
    if [ "$distro" == "RedHatEnterpriseServer" ] || [ "$distro" == "CentOS" ] || [ "$distro" == "OracleServer" ] || [ "$distro" == "CloudLinux" ]; then
        # I would prefer to have this reworked in the future to be a bit more elegant -AC
        if [ "$dist" == "el8" ] || [ "$dist" == "el9" ]; then
            yum install -y glibc-langpack-de glibc-langpack-es glibc-langpack-fr glibc-langpack-it glibc-langpack-ko glibc-langpack-pt glibc-langpack-ru glibc-langpack-zh glibc-langpack-ja glibc-langpack-pl
        fi
        
    elif [ "$distro" == "Raspbian" ] || [ "$distro" == "Ubuntu" ] || [ "$distro" == "Debian" ]; then
        (
            cd ../../fusion/html/includes/lang/locale
            for lang in *; do
                if [ -d "$lang" ]; then
                    if [ "$distro" == "Debian" ]; then
                        sed -i "/#[[:blank:]]*$lang/s/#//" /etc/locale.gen
                    else
                        locale-gen "$lang" &> /dev/null
                        locale-gen "$lang.UTF-8" &> /dev/null
                        if [ "$distro" == "Ubuntu" ]; then
                            if [ "$lang" == "ja_JP" ]; then
                                locale-gen "$lang.EUC-JP" &> /dev/null
                            elif [ "$lang" == "ko_KR" ]; then
                                locale-gen "$lang.EUC-KR" &> /dev/null
                            fi
                        fi
                    fi
                fi
            done
            echo "Configuring locale... this might take a minute..."
            if [ `command -v locale-update` ]; then
                locale-update &> /dev/null
            else
                locale-gen &> /dev/null
            fi
        )
    fi

    echo "Restarting Apache..."
    "$proddir/scripts/manage_services.sh" restart httpd
fi