<h5 class="ul"><?= _('Mountpoint Details') ?></h5>

<table class="table table-condensed table-no-border table-auto-width">
    <tr>
        <td class="vt">
            <label><?= _('Service Description') ?>:</label>
        </td>
        <td>
            <input type="text" size="20" name="service_description" id="service_description" value="<?= encode_form_val($service_description) ?>" class="textfield form-control">
        </td>
    </tr>
    <tr>
        <td class="vt">
            <label><?= _('mtab Path') ?>:</label>
        </td>
        <td>
            <input type="text" size="20" class="textfield form-control" name="mtab" id="mtab" value="<?= encode_form_val($mtab) ?>">
            <div class="subtext"><?= _('Use this field to indicate mtab path.') ?></div>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <label><?= _('fstab') ?>:</label>
        </td>
        <td style="padding-bottom:0px">
            <input type="text" size="20" class="textfield form-control" name="fstab" id="fstab" value="<?= encode_form_val($fstab) ?>">
            <input type="text" size="1" class="textfield form-control" name="FSF" id="FSF" value="<?= encode_form_val($FSF) ?>">
            <input type="text" size="1" class="textfield form-control" name="MF" id="MF" value="<?= encode_form_val($MF) ?>">
            <input type="text" size="1" class="textfield form-control" name="OF" id="OF" value="<?= encode_form_val($OF) ?>">
        </td>
    </tr>
    <tr>
        <td></td>
        <td style="padding-top:0px;">
            <div class="subtext"><?= _('Use this field to indicate fstab path, FS Field number, Mount Field number and Option Field number.') ?></div>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <label><?= _('Response Time') ?>:</label>
        </td>
        <td>
            <input type="text" size="1" class="textfield form-control" name="rtime" id="rtime" value="<?= encode_form_val($rtime) ?>">
            <div class="subtext"><?= _('Response time as which NFS is declared as staled') ?></div>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <label><?= _('Softlinks') ?>:</label>
        </td>
        <td>
            <input type="checkbox" class="checkbox" name="softlink" <?= is_checked($softlink) ?>>
            <div class="subtext"><?= _('Allow softlinks to be accepted instead of mount points.') ?></div>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <label><?= _('Ignore fstab') ?>:</label>
        </td>
        <td>
            <input type="checkbox" class="checkbox" name="ignorefs" <?= is_checked($ignorefs) ?>>
            <div class="subtext"><?= _('Do not fail just because mount is not in fstab.') ?></div>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <label><?= _('Auto Select') ?>:</label>
        </td>
        <td>
            <input type="checkbox" class="checkbox" name="auto" <?= is_checked($auto) ?>>
            <div class="subtext"><?= _('This will turn the automatic mountpoint service on.') ?></div>
        </td>
    </tr>
    <tr>
        <td class="vt">
            <label><?= _('Write Test') ?>:</label>
        </td>
        <td>
            <input type="checkbox" class="checkbox" name="write" <?= is_checked($write) ?>>
            <div class="subtext"><?= _('This will create a temporary file and return OK if the write test was successful.') ?></div>
        </td>
    </tr>
</table>

<h5 class="ul"><?= _('Mountpoint Service') ?></h5>
<?= _('A Basic service that checks if the mountpoint that was set in the description is available.  The Scanned Mount List is a general scan of available mounts and their status using the plugin defaults.') ?><br>
<div class="message">
</div><br>

<div style="display: inline-block; vertical-align: top; height: auto;">
    <table class="adddeleterow table table-condensed table-no-border table-auto-width" style="margin-bottom: 0;" id="hosts">
        <tr>
            <th><?= _('Mountpoint Path') ?></th>
        </tr>
        <tr>
            <td>
                <input type="text" size="25" name="mount[0]" value="" class="textfield form-control" />
            </td>
        </tr>

    </table>
</div>

<?php 
// only display select box if we have mounts to display
if (!empty($mounts)) { ?>
    <div style="display: inline-block; vertical-align: top; height: auto; margin: 5px 0 0 10px;">
        <b><?= _("Scanned Mount List") ?></b><br>
        <select multiple id="mountList" class="form-control" style="width: 400px; min-height: 72px; margin: 5px 5px 5px 15px;" size="4"></select><br>
        <a href="#" onClick="return false;" id="addMount">Add Selected</a>
    </div>
<?php } ?>
<script type="text/javascript">
    $(document).ready(function() {
        wizard_populate();

        // smart service selecter
        $("#addMount").click(move_mounts);

        // allow single double-click selector
        $("#mountList").on("dblclick", "option", move_mounts);
    });
    
    function move_mounts() {
        var element = "";
        var element = $("#mountList option:selected");
        var selected = element.length;
        var value = element.text();

        var count = 0;
        row_count = get_empty_field_count();

        if (selected > row_count) {
            // count how many rows we need to trigger
            var create_inputs = selected - row_count;
            for (i = 0; i < create_inputs; i++) {
                $("[class=wizard-add-row]").trigger("click");
            }
        }
        $.each(element, function() {
            nameText = $(this).html();
            // find empty input
            let targetmount = $("[name^=mount]").filter(function() { return $(this).val() == ""; });
            let targetName = targetmount[0].getAttribute("name");
            $("[name=\'" + targetName + "\']").val(nameText);
        });
    }

    function wizard_populate() {
        // populate scanned data
        var mountlist = [<?= $mounts ?>];
        mountlist.sort(function (a, b) {
            return a.toLowerCase().localeCompare(b.toLowerCase());
        });

        var mount_list = $("#mountList");
        $.each(mountlist, function(key, value) {
            mount_list.append($("<option></option>").attr("value", value).text(value)); 
        });
    }
    function get_empty_field_count() {
        target = "";

        // find empty input fields
        target = $("[name^=mount]").filter(function() { return $(this).val() == ""; });
        var row_count = target.length;

        return row_count;
    }
</script>