    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="ul"><?= _('SNMP Trap Details') ?></h2>
        <p><?= _('Select the hosts you would like to enable SNMP Traps for') ?></p>

        <div id="HostPages" class="row">
            <div class="col-sm-auto border-block ms-3 hostpage">
                <div class="row pb-2">
                    <div class="col-sm-auto">
                        <input type="checkbox" id="allhosts" class="form-check-input me-2" name="all_hosts" autofocus="off">
                        <label for="allhosts" class="form-check-label bold"><?= _('Host Name') ?></label>
                    </div>
                </div>
<?php
    $args = array(
        "orderby" => "host_name:a",
    );

    $xml = get_xml_host_objects($args);

    if ($xml) {
        $x = 0;

        foreach ($xml->host as $h) {
            $x++;

            $host_name = encode_form_val(strval($h->host_name));
?>

                <div class="row">
                    <div class="col-sm">
                        <input type="checkbox" class="form-check-input me-2" id="host_<?= $x ?>" name="services[host][<?= $host_name ?>]">
                        <label for="host_<?= $x ?>" class="form-check-label"><?= _($host_name) ?></label>
                    </div>
                </div>
<?php
            if (($x % ($hosts_per_page)) == 0) {
?>
            </div> <!-- border-block -->
            <div class="col-sm-auto border-block ms-3 hostpage visually-hidden"> <!-- visually-hidden"> -->
<?php
            }

        }
    }
?>
            </div> <!-- border-block -->
        </div> <!-- HostPages -->

<?php
    if ($x > $hosts_per_page) {
?>
        <div class="row mt-2 mb-2">
            <div class="col-sm-auto">
                <a href="#" onClick="return false;" id="showPrevTab" class="btn btn-link invisible">&lt; <?= _('Previous ').$hosts_per_page ?></a>
            </div>
            <div class="col-sm-auto">
                <a href="#" onClick="return false;" id="showNextTab" class="btn btn-link visually-hidden"><?= _('Next ').$hosts_per_page ?> &gt;</a>
            </div>
        </div>
<?php
    }
?>    </div> <!-- container -->

    <script type="text/javascript">
        var contentDivs = new Array();
        var contentDivsinit = -1;
        var lasttabid = 0; // By default show the first one.
        var hostsCount = <?= $x ?>;
        var hostsPerPage = <?= $hosts_per_page ?>;

        if (contentDivsinit > 0) {
            $("#showPrevTab").removeClass('visually-hidden');
        }

        if (hostsCount > hostsPerPage) {
            $("#showNextTab").removeClass('visually-hidden');
        }

        $("#showPrevTab").click(function() {
            showPrevTab();
        });

        $("#showNextTab").click(function() {
            showNextTab();
        });

        $("#allhosts").click(function() {
            checkall();
        });

        function checkall() {
            var checkboxes = $("input[name^='services[host]']");

            if ($("input[name='all_hosts']").is(":checked")) {
                checkboxes.prop("checked", true);
            } else {
                checkboxes.prop("checked", false);
            }
        }

        function showNextTab() {
            if (contentDivsinit) {
                contentDivs = $("#HostPages").children(".hostpage");
                contentDivsinit = 0;
            }

            selectedId = lasttabid;
            selectedId++;

            if (contentDivs.length < selectedId) { return false; }

            // Invisible keeps the space of the element
            $("#showPrevTab").removeClass('invisible');
            $(contentDivs[selectedId]).removeClass('visually-hidden');
            $(contentDivs[lasttabid]).addClass('visually-hidden');
            lasttabid = selectedId;

            if (lasttabid >= (contentDivs.length - 1)) {
                $("#showNextTab").addClass('visually-hidden');
            }

            // Stop the browser following the link
            return false;
        }

        function showPrevTab() {
            if (contentDivsinit) {
                contentDivs = $("#HostPages").children(".hostpage");
                contentDivsinit = 0;
            }

            selectedId = lasttabid;
            selectedId--;

            if (-1 >= selectedId) { return false; }

            $("#showNextTab").removeClass('visually-hidden');
            $(contentDivs[selectedId]).removeClass('visually-hidden');
            $(contentDivs[lasttabid]).addClass('visually-hidden');
            lasttabid = selectedId;

            if (lasttabid == 0) {
                // Invisible keeps the space of the element
                $("#showPrevTab").addClass('invisible');
            }

            // Stop the browser following the link
            return false;
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
