<?php
//
// Copyright (c) 2024 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../includes/common.inc.php');


// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs();
check_authentication();

// This component does not use do_page_start() from pageparts.inc.php, so we have to add
// the call for telemetry here.
$user_id = grab_array_var($_SESSION, 'user_id');

record_page_usage($user_id, 'Azure AD Tenant Management', basename(__FILE__), '');

// Only admins can access this page
if (is_admin() == false) {
    echo _("You are not authorized to access this feature. Contact your system administrator for more information, or to obtain access to this feature.");
    exit();
}

route_to_neptune(true);

?>