<?php

namespace api\v2\dashboards;
use api\v2\Base;
use Exception;

use function api\v2\import_common;
import_common();

/**
 * Manages importing of dashboards.
 */
class import extends Base {
    /**
     * Auth function for post request method on api/v2/account/dashboards/import
     * All necessary auth is done in check_authentication so this just returns true.
     */
    public function authorized_for_post() {
        return true;
    }

    /**
     * Imports a dashboard configuration from provided data.
     */
    public function post() {
        $import = grab_request_var("import");
        if(importDashboard($import)) {
            return ['message' => _("Successfully imported dashboard")];
        } else {
            return ['message' => _("Invalid dashboard file!")];
        }
    }
}