<?php
//
// Basic dashlet wrapper for external functions
// Copyright (c) 2008-2020 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/common.inc.php');
include_once(dirname(__FILE__) . '/components/xicore/ajaxhelpers-status.inc.php');

// Initialization stuff
pre_init();
init_session();
do_page();

function do_page() {
    $page_title = "Nagios XI";
    do_page_start(array("page_title" => $page_title), true);
?>

    <style>
        .auto-scale {
            transform-origin: top left;
        }
    </style>

    <script type="text/javascript">

        var autoscale = <?php echo json_encode($_GET["autoscale"]); ?> == "true";

        // Hypermap not compatible with auto-scale due to large page size
        if (<?php echo json_encode($_GET["dashlet"]); ?> == "hypermap")
        {
            autoscale = false;
        }

        function scaleContent() {
            var content = $('.child, .childpage').first();
            var scaleWidth = Math.min(1, window.innerWidth / content.width());
            var scaleHeight = Math.min(1, window.innerHeight / content.height());
            var scale = Math.max(Math.min(scaleWidth, scaleHeight), 0.1);
            
            if (autoscale)
            {
                content.addClass('auto-scale').css({
                    'transform': 'scale(' + scale + ')'
                });
            }
        }
        
        /*
            The purpose of this function is to attempt an auto-scale 1 second after the dashlet loads.
            This is a fallback in case the dashlet fails to grab content width/height reliably upon load.
            It's not a graceful solution and mostly put together out of exhaustion, but it should work for now.
            Please improve if you have the knowledge and time. - JC
        */
        function initialScale()
        {
            setTimeout(function() {
                scaleContent();
            }, 1000);
        }

        $(document).ready(function() {
            if (autoscale)
            {
                $('div').parents('.child, .childpage').css({
                    'padding-bottom': '10%',
                    'overflow': 'hidden',
                    'width': 'fit-content'
                });
            }

            // Scale on window resize and load
            $(window).load(scaleContent);
            $(window).load(initialScale);
            $(window).resize(scaleContent);
        });
        
    </script>

    <?php
        $urlargs = $_GET["args"];
        $dargs = json_decode(base64_decode($urlargs), true);

        display_dashlet(
            $_GET["dashlet"],
            "",
            $dargs,
            DASHLET_MODE_INBOARD
        );
    ?>
<?php
    do_page_end(true);
}
