<?php

include_once(dirname(__FILE__) . '/../dashlethelper.inc.php');

// Initialization stuff
pre_init();
init_session(true);

grab_request_vars();
check_prereqs();
check_authentication(false);

sansrisingports_route_request();

function sansrisingports_route_request() {
    
    // check if we're only interested in the highcharts graph before we do anything else
    $height = intval(grab_request_var('height', 300));
    $width = intval(grab_request_var('width', 400));
    $id = grab_request_var('id');

    echo sansrisingports_get_hc($id, $height, $width);    
}

// simply return the highcharts data necessary to create the graph
function sansrisingports_get_hc($id, $height, $width) {

    $date = date("Y-m-d");
    $url = "https://isc.sans.edu/api/topports/records/10/$date"; // Use dynamic date
    $port_data_array = array();

    // Get the XML data
    $data = file_get_contents($url);

    if ($data === false) {
        die("Failed to retrieve data.");
    }

    // Parse XML
    $xml = simplexml_load_string($data);

    if ($xml === false) {
        die("Failed to parse XML.");
    }

    // Loop through each <port> element
    foreach ($xml->port as $port) {
        $port_data_array[] = array(
            'port' => (string) $port->targetport,
            'records' => (int) $port->records,
            'targets' => (int) $port->targets,
            'sources' => (int) $port->sources
        );
    }

    // Prepare data for output
    $categories = '';
    $records = '';
    foreach ($port_data_array as $port) {
        $categories .= "'" . $port['port'] . "',";
        $records .= $port['records'] . ',';
    }

    // Trim trailing comma
    $categories = rtrim($categories, ',');
    $records = rtrim($records, ',');
    
    
    // LOCAL EXPORTING lOGIC
    $exporting_url = get_exporting_url();
    $export_buttons = overwrite_hc_exporting_buttons();

    $title = 'SANS Internet Storm Center Top 10 Rising Ports for ' . $date;
    $filename = strtolower(str_replace(' ', '-', $title));
    $text_color = '#999';
    $font_title = "16px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif";
    $font_subtitle = "12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif";
    $line_color = "grey";
    if (is_neptune()) {
        $text_color = 'var(--foreground)';
        $font_title = "14px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif";
        $font_subtitle = "10px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif";
        $line_color = 'var(--foreground)';
    }
    
    $container = $id;
    $output = "
        <script type='text/javascript'>

        Highcharts.setOptions({
            colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'] 
        });

        $(function () {
            $('#".$container."').highcharts({
                chart: {
                    type: 'bar',
                    height: " . $height . ",
                    width: " . $width . ",
                    backgroundColor: 'transparent'
                },
                exporting: {
                    url: '" . $exporting_url . "',
                    filename: '" . $filename . "',
                    buttons: {" . $export_buttons . "}
                },
                title: {
                    text: '" . $title . "',
                    style: {
                        color: '" . $text_color . "',
                        font: '" . $font_title . "'
                    }
                },
                subtitle: {
                    text: 'Source: <a href=" . $url . ">Internet Storm Center</a>',
                    style: {
                        color: '" . $text_color . "',
                        font: '" . $font_subtitle . "'
                    }
                },
                xAxis: {
                    categories: [" . $categories . "],
                    title: {
                        text: 'Ports',
                        style: {
                            color: '" . $line_color . "'
                        }
                    },
                    labels: {
                        style: {
                            color: '" . $line_color . "'
                        }
                    }
                },
                yAxis: {
                    min: 0,
                    title: {
                        text: 'Records',
                        align: 'high',
                        style: {
                            color: '" . $line_color . "'
                        }
                    },
                    labels: {
                        overflow: 'justify'
                    },
                    gridLineColor: '" . $line_color . "',
                    labels: {
                        style: {
                            color: '" . $line_color . "'
                        }
                    }
                },
                plotOptions: {
                    bar: {
                        dataLabels: {
                            enabled: true,
                        }
                    }
                },
                legend: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                series: [{
                    name: 'Records',
                    data: [" . $records . "]
                }]
            });
        });
        </script>
    ";

    return $output;
}