/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Boost module
 *
 * (c) 2010-2021 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/boost-canvas",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/Boost/Boostables.js",[],function(){return["area","areaspline","arearange","column","columnrange","bar","line","scatter","heatmap","bubble","treemap"]}),i(e,"Extensions/Boost/BoostableMap.js",[e["Extensions/Boost/Boostables.js"]],function(t){let e={};return t.forEach(t=>{e[t]=!0}),e}),i(e,"Extensions/Boost/BoostChart.js",[e["Extensions/Boost/BoostableMap.js"],e["Core/Utilities.js"]],function(t,e){let{addEvent:i,pick:s}=e,o=[];function r(e){let i=e.series,o=e.boost=e.boost||{},r=e.options.boost||{},n=s(r.seriesThreshold,50);if(i.length>=n)return!0;if(1===i.length)return!1;let a=r.allowForce;if(void 0===a){for(let t of(a=!0,e.xAxis))if(s(t.min,-1/0)>s(t.dataMin,-1/0)||s(t.max,1/0)<s(t.dataMax,1/0)){a=!1;break}}if(void 0!==o.forceChartBoost){if(a)return o.forceChartBoost;o.forceChartBoost=void 0}let l=0,h=0,c;for(let e of i)0!==(c=e.options).boostThreshold&&!1!==e.visible&&"heatmap"!==e.type&&(t[e.type]&&++l,function(...t){let e=-Number.MAX_VALUE;return t.forEach(function(t){if(null!=t&&void 0!==t.length&&t.length>0)return e=t.length,!0}),e}(e.processedXData,c.data,e.points)>=(c.boostThreshold||Number.MAX_VALUE)&&++h);return o.forceChartBoost=a&&(l===i.length&&h===l||h>5),o.forceChartBoost}function n(t){i(t,"predraw",function(){t.boost=t.boost||{},t.boost.forceChartBoost=void 0,t.boosted=!1,t.boost.clear&&t.boost.clear(),t.boost.canvas&&t.boost.wgl&&r(t)&&t.boost.wgl.allocateBuffer(t),t.boost.markerGroup&&t.xAxis&&t.xAxis.length>0&&t.yAxis&&t.yAxis.length>0&&t.boost.markerGroup.translate(t.xAxis[0].pos,t.yAxis[0].pos)}),i(t,"render",function(){t.boost&&t.boost.wgl&&r(t)&&t.boost.wgl.render(t)});let e=-1,s=-1;i(t.pointer,"afterGetHoverData",()=>{let i=t.hoverSeries;if(t.boost=t.boost||{},t.boost.markerGroup&&i){let o=t.inverted?i.yAxis:i.xAxis,r=t.inverted?i.xAxis:i.yAxis;(o&&o.pos!==e||r&&r.pos!==s)&&(t.boost.markerGroup.translate(o.pos,r.pos),e=o.pos,s=r.pos)}})}return{compose:function(t,i){return i&&e.pushUnique(o,t)&&t.prototype.callbacks.push(n),t},getBoostClipRect:function(t,e){let i={x:t.plotLeft,y:t.plotTop,width:t.plotWidth,height:t.navigator?t.navigator.top+t.navigator.height-t.plotTop:t.plotHeight};if(e.getClipBox){let{xAxis:s,yAxis:o}=e;if(i=e.getClipBox(),t.inverted){let t=i.width;i.width=i.height,i.height=t,i.x=o.pos,i.y=s.pos}else i.x=s.pos,i.y=o.pos}if(e===t){let e=t.inverted?t.xAxis:t.yAxis;e.length<=1&&(i.y=Math.min(e[0].pos,i.y),i.height=e[0].pos-t.plotTop+e[0].len)}return i},isChartSeriesBoosting:r}}),i(e,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}}),i(e,"Extensions/Boost/WGLShader.js",[e["Core/Utilities.js"]],function(t){let{clamp:e,error:i,pick:s}=t;return class{constructor(t){if(this.errors=[],this.uLocations={},this.gl=t,t&&!this.createShader())return}bind(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)}createShader(){let t=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),e=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),i=t=>this.gl.getUniformLocation(this.shaderProgram,t);return t&&e?(this.shaderProgram=this.gl.createProgram(),this.gl.attachShader(this.shaderProgram,t),this.gl.attachShader(this.shaderProgram,e),this.gl.linkProgram(this.shaderProgram),this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))?(this.gl.useProgram(this.shaderProgram),this.gl.bindAttribLocation(this.shaderProgram,0,"aVertexPosition"),this.pUniform=i("uPMatrix"),this.psUniform=i("pSize"),this.fcUniform=i("fillColor"),this.isBubbleUniform=i("isBubble"),this.bubbleSizeAbsUniform=i("bubbleSizeAbs"),this.bubbleSizeAreaUniform=i("bubbleSizeByArea"),this.uSamplerUniform=i("uSampler"),this.skipTranslationUniform=i("skipTranslation"),this.isCircleUniform=i("isCircle"),this.isInverted=i("isInverted"),!0):(this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1,!1):(this.shaderProgram=!1,this.handleErrors(),!1)}handleErrors(){this.errors.length&&i("[highcharts boost] shader error - "+this.errors.join("\n"))}stringToProgram(t,e){let i=this.gl.createShader("vertex"===e?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);return(this.gl.shaderSource(i,t),this.gl.compileShader(i),this.gl.getShaderParameter(i,this.gl.COMPILE_STATUS))?i:(this.errors.push("when compiling "+e+" shader:\n"+this.gl.getShaderInfoLog(i)),!1)}destroy(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)}fillColorUniform(){return this.fcUniform}getProgram(){return this.shaderProgram}pointSizeUniform(){return this.psUniform}perspectiveUniform(){return this.pUniform}reset(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))}setBubbleUniforms(t,i,o,r=1){let n=t.options,a=Number.MAX_VALUE,l=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&t.is("bubble")){let h=t.getPxExtremes();a=s(n.zMin,e(i,!1===n.displayNegative?n.zThreshold:-Number.MAX_VALUE,a)),l=s(n.zMax,Math.max(l,o)),this.gl.uniform1i(this.isBubbleUniform,1),this.gl.uniform1i(this.isCircleUniform,1),this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==t.options.sizeBy),this.gl.uniform1i(this.bubbleSizeAbsUniform,t.options.sizeByAbsoluteValue),this.setUniform("bubbleMinSize",h.minPxSize*r),this.setUniform("bubbleMaxSize",h.maxPxSize*r),this.setUniform("bubbleZMin",a),this.setUniform("bubbleZMax",l),this.setUniform("bubbleZThreshold",t.options.zThreshold)}}setColor(t){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,t[0]/255,t[1]/255,t[2]/255,t[3])}setDrawAsCircle(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,t?1:0)}setInverted(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,t)}setPMatrix(t){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,!1,t)}setPointSize(t){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,t)}setSkipTranslation(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===t?1:0)}setTexture(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,t)}setUniform(t,e){if(this.gl&&this.shaderProgram){let i=this.uLocations[t]=this.uLocations[t]||this.gl.getUniformLocation(this.shaderProgram,t);this.gl.uniform1f(i,e)}}}}),i(e,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return class{constructor(t,e,i){this.buffer=!1,this.iterator=0,this.preAllocated=!1,this.vertAttribute=!1,this.components=i||2,this.dataComponents=i,this.gl=t,this.shader=e}allocate(t){this.iterator=-1,this.preAllocated=new Float32Array(4*t)}bind(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)}build(t,e,i){let s;return(this.data=t||[],this.data&&0!==this.data.length||this.preAllocated)?(this.components=i||this.components,this.buffer&&this.gl.deleteBuffer(this.buffer),this.preAllocated||(s=new Float32Array(this.data)),this.buffer=this.gl.createBuffer(),this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||s,this.gl.STATIC_DRAW),this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),e),this.gl.enableVertexAttribArray(this.vertAttribute),s=!1,!0):(this.destroy(),!1)}destroy(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.buffer=!1,this.vertAttribute=!1),this.iterator=0,this.components=this.dataComponents||2,this.data=[]}push(t,e,i,s){this.preAllocated&&(this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=e,this.preAllocated[++this.iterator]=i,this.preAllocated[++this.iterator]=s)}render(t,e,i){let s=this.preAllocated?this.preAllocated.length:this.data.length;return!!this.buffer&&!!s&&((!t||t>s||t<0)&&(t=0),(!e||e>s)&&(e=s),!(t>=e)&&(i=i||"POINTS",this.gl.drawArrays(this.gl[i],t/this.components,(e-t)/this.components),!0))}}}),i(e,"Extensions/Boost/WGLRenderer.js",[e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLDrawMode.js"],e["Extensions/Boost/WGLShader.js"],e["Extensions/Boost/WGLVertexBuffer.js"]],function(t,e,i,s,o,r){let{parse:n}=t,{doc:a,win:l}=e,{isNumber:h,isObject:c,merge:d,objectEach:u,pick:g}=i,f={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},p={scatter:!0,bubble:!0},m=["webgl","experimental-webgl","moz-webgl","webkit-3d"];class b{static orthoMatrix(t,e){return[2/t,0,0,0,0,-(2/e),0,0,0,0,-2,0,-1,1,-1,1]}static seriesPointCount(t){let e,i,s;return t.boosted?(e=!!t.options.stacking,i=t.xData||t.options.xData||t.processedXData,s=(e?t.data:i||t.options.data).length,"treemap"===t.type?s*=12:"heatmap"===t.type?s*=6:f[t.type]&&(s*=2),s):0}constructor(t){this.data=[],this.height=0,this.isInited=!1,this.markerData=[],this.series=[],this.textureHandles={},this.width=0,this.postRenderCallback=t,this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}getPixelRatio(){return this.settings.pixelRatio||l.devicePixelRatio||1}setOptions(t){"pixelRatio"in t||(t.pixelRatio=1),d(!0,this.settings,t)}allocateBuffer(t){let e=this.vbuffer,i=0;this.settings.usePreallocated&&(t.series.forEach(t=>{t.boosted&&(i+=b.seriesPointCount(t))}),e&&e.allocate(i))}allocateBufferForSingleSeries(t){let e=this.vbuffer,i=0;this.settings.usePreallocated&&(t.boosted&&(i=b.seriesPointCount(t)),e&&e.allocate(i))}clear(){let t=this.gl;t&&t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)}pushSeriesData(t,e){let i=this.data,s=this.settings,o=this.vbuffer,r=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),{chart:a,options:l,sorted:h,xAxis:d,yAxis:u}=t,g=!!l.stacking,p=l.data,m=t.xAxis.getExtremes(),b=m.min,x=m.max,A=t.yAxis.getExtremes(),v=A.min,y=A.max,P=t.xData||l.xData||t.processedXData,T=t.yData||l.yData||t.processedYData,E=t.zData||l.zData||t.processedZData,S=!P||0===P.length,C=l.connectNulls,M=t.points||!1,U=g?t.data:P||p,R={x:Number.MAX_VALUE,y:0},k={x:-Number.MAX_VALUE,y:0},w=void 0===a.index,D=f[t.type],B=l.zoneAxis||"y",L=l.zones||!1,z=l.threshold,N=this.getPixelRatio(),_=t.chart.plotWidth,I=!1,G=!1,O,X,V=0,j=!1,F,H,W,Y,q=-1,Z=!1,K=!1,Q,J=!1,$=!1,tt=!1,te=!1,ti=!0,ts=!0,to,tr=!1,tn=!1,ta=0;if(l.boostData&&l.boostData.length>0)return;if(l.gapSize&&(tn="value"!==l.gapUnit?l.gapSize*t.closestPointRange:l.gapSize),L&&(to=[],L.forEach((t,e)=>{if(t.color){let i=n(t.color).rgba;i[0]/=255,i[1]/=255,i[2]/=255,to[e]=i,tr||void 0!==t.value||(tr=i)}}),!tr)){let e=t.pointAttribs&&t.pointAttribs().fill||t.color;tr=n(e).rgba,tr[0]/=255,tr[1]/=255,tr[2]/=255}a.inverted&&(_=t.chart.plotHeight),t.closestPointRangePx=Number.MAX_VALUE;let tl=t=>{t&&(e.colorData.push(t[0]),e.colorData.push(t[1]),e.colorData.push(t[2]),e.colorData.push(t[3]))},th=(t,r,n,a=1,l)=>{tl(l),1!==N&&(!s.useGPUTranslations||e.skipTranslation)&&(t*=N,r*=N,a*=N),s.usePreallocated&&o?(o.push(t,r,n?1:0,a),ta+=4):(i.push(t),i.push(r),i.push(n?N:0),i.push(a))},tc=()=>{e.segments.length&&(e.segments[e.segments.length-1].to=i.length||ta)},td=()=>{e.segments.length&&e.segments[e.segments.length-1].from===(i.length||ta)||(tc(),e.segments.push({from:i.length||ta}))},tu=(t,e,i,s,o)=>{tl(o),th(t+i,e),tl(o),th(t,e),tl(o),th(t,e+s),tl(o),th(t,e+s),tl(o),th(t+i,e+s),tl(o),th(t+i,e)};if(td(),M&&M.length>0){e.skipTranslation=!0,e.drawMode="TRIANGLES",M[0].node&&M[0].node.levelDynamic&&M.sort((t,e)=>{if(t.node){if(t.node.levelDynamic>e.node.levelDynamic)return 1;if(t.node.levelDynamic<e.node.levelDynamic)return -1}return 0}),M.forEach(e=>{let i,s;let o=e.plotY;if(void 0!==o&&!isNaN(o)&&null!==e.y&&e.shapeArgs){let{x:o=0,y:r=0,width:l=0,height:h=0}=e.shapeArgs;i=(s=a.styledMode?e.series.colorAttribs(e):s=e.series.pointAttribs(e))["stroke-width"]||0,tt=n(s.fill).rgba,tt[0]/=255,tt[1]/=255,tt[2]/=255,t.is("treemap")&&(i=i||1,X=n(s.stroke).rgba,X[0]/=255,X[1]/=255,X[2]/=255,tu(o,r,l,h,X),i/=2),t.is("heatmap")&&a.inverted&&(o=d.len-o,r=u.len-r,l=-l,h=-h),tu(o+i,r+i,l-2*i,h-2*i,tt)}}),tc();return}for(;q<U.length-1;){if(void 0===(W=U[++q]))continue;if(w)break;let i=p&&p[q];if(!S&&c(i,!0)&&i.color&&(tt=n(i.color).rgba,tt[0]/=255,tt[1]/=255,tt[2]/=255),S?(F=W[0],H=W[1],U[q+1]&&(K=U[q+1][0]),U[q-1]&&(Z=U[q-1][0]),W.length>=3&&(Y=W[2],W[2]>e.zMax&&(e.zMax=W[2]),W[2]<e.zMin&&(e.zMin=W[2]))):(F=W,H=T[q],U[q+1]&&(K=U[q+1]),U[q-1]&&(Z=U[q-1]),E&&E.length&&(Y=E[q],E[q]>e.zMax&&(e.zMax=E[q]),E[q]<e.zMin&&(e.zMin=E[q]))),!C&&(null===F||null===H)){td();continue}if(K&&K>=b&&K<=x&&(J=!0),Z&&Z>=b&&Z<=x&&($=!0),r?(S&&(H=W.slice(1,3)),Q=H[0],H=H[1]):g&&(F=W.x,Q=(H=W.stackY)-W.y),null!=v&&null!=y&&(ti=H>=v&&H<=y),F>x&&k.x<x&&(k.x=F,k.y=H),F<b&&R.x>b&&(R.x=F,R.y=H),null!==H||!C){if(null===H||!ti&&!J&&!$){td();continue}if(h&&(K>=b||F>=b)&&(Z<=x||F<=x)&&(te=!0),te||J||$){if(tn&&F-Z>tn&&td(),L){let t;L.some((e,i)=>{let s=L[i-1];return"x"===B?void 0!==e.value&&F<=e.value&&(to[i]&&(!s||F>=s.value)&&(t=to[i]),!0):void 0!==e.value&&H<=e.value&&(to[i]&&(!s||H>=s.value)&&(t=to[i]),!0)}),tt=t||tr||tt}if(s.useGPUTranslations||(e.skipTranslation=!0,F=d.toPixels(F,!0),H=u.toPixels(H,!0),!(F>_)||"POINTS"!==e.drawMode)){if(e.hasMarkers&&te&&!1!==I&&(t.closestPointRangePx=Math.min(t.closestPointRangePx,Math.abs(F-I))),!s.useGPUTranslations&&!s.usePreallocated&&I&&1>Math.abs(F-I)&&G&&1>Math.abs(H-G)){s.debug.showSkipSummary&&++V;continue}D&&(O=Q,(!1===Q||void 0===Q)&&(O=H<0?H:0),r||g||(O=Math.max(null===z?v:z,v)),s.useGPUTranslations||(O=u.toPixels(O,!0)),th(F,O,0,0,tt)),l.step&&!ts&&th(F,G,0,2,tt),th(F,H,0,"bubble"===t.type?Y||1:2,tt),I=F,G=H,j=!0,ts=!1}}}}s.debug.showSkipSummary&&console.log("skipped points:",V);let tg=(t,i)=>{if(s.useGPUTranslations||(e.skipTranslation=!0,t.x=d.toPixels(t.x,!0),t.y=u.toPixels(t.y,!0)),i){this.data=[t.x,t.y,0,2].concat(this.data);return}th(t.x,t.y,0,2)};!j&&!1!==C&&"line_strip"===t.drawMode&&(R.x<Number.MAX_VALUE&&tg(R,!0),k.x>-Number.MAX_VALUE&&tg(k)),tc()}pushSeries(t){let e=this.markerData,i=this.series,o=this.settings;i.length>0&&i[i.length-1].hasMarkers&&(i[i.length-1].markerTo=e.length),o.debug.timeSeriesProcessing&&console.time("building "+t.type+" series");let r={segments:[],markerFrom:e.length,colorData:[],series:t,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!t.options.marker&&!1!==t.options.marker.enabled,showMarkers:!0,drawMode:s[t.type]||"LINE_STRIP"};t.index>=i.length?i.push(r):i[t.index]=r,this.pushSeriesData(t,r),o.debug.timeSeriesProcessing&&console.timeEnd("building "+t.type+" series")}flush(){let t=this.vbuffer;this.data=[],this.markerData=[],this.series=[],t&&t.destroy()}setXAxis(t){let e=this.shader;if(!e)return;let i=this.getPixelRatio();e.setUniform("xAxisTrans",t.transA*i),e.setUniform("xAxisMin",t.min),e.setUniform("xAxisMinPad",t.minPixelPadding*i),e.setUniform("xAxisPointRange",t.pointRange),e.setUniform("xAxisLen",t.len*i),e.setUniform("xAxisPos",t.pos*i),e.setUniform("xAxisCVSCoord",!t.horiz),e.setUniform("xAxisIsLog",!!t.logarithmic),e.setUniform("xAxisReversed",!!t.reversed)}setYAxis(t){let e=this.shader;if(!e)return;let i=this.getPixelRatio();e.setUniform("yAxisTrans",t.transA*i),e.setUniform("yAxisMin",t.min),e.setUniform("yAxisMinPad",t.minPixelPadding*i),e.setUniform("yAxisPointRange",t.pointRange),e.setUniform("yAxisLen",t.len*i),e.setUniform("yAxisPos",t.pos*i),e.setUniform("yAxisCVSCoord",!t.horiz),e.setUniform("yAxisIsLog",!!t.logarithmic),e.setUniform("yAxisReversed",!!t.reversed)}setThreshold(t,e){let i=this.shader;i&&(i.setUniform("hasThreshold",t),i.setUniform("translatedThreshold",e))}renderChart(i){let s=this.gl,o=this.settings,a=this.shader,l=this.vbuffer,c=this.getPixelRatio();if(!i)return!1;this.width=i.chartWidth*c,this.height=i.chartHeight*c;let d=this.height,u=this.width;if(!s||!a||!u||!d)return!1;o.debug.timeRendering&&console.time("gl rendering"),s.canvas.width=u,s.canvas.height=d,a.bind(),s.viewport(0,0,u,d),a.setPMatrix(b.orthoMatrix(u,d)),o.lineWidth>1&&!e.isMS&&s.lineWidth(o.lineWidth),l&&(l.build(this.data,"aVertexPosition",4),l.bind()),a.setInverted(i.inverted),this.series.forEach((e,d)=>{let u=e.series.options,f=u.marker,m=void 0!==u.lineWidth?u.lineWidth:1,b=u.threshold,x=h(b),A=e.series.yAxis.getThreshold(b),v=g(u.marker?u.marker.enabled:null,!!e.series.xAxis.isRadial||null,e.series.closestPointRangePx>2*((u.marker?u.marker.radius:10)||10)),y=this.textureHandles[f&&f.symbol||e.series.symbol]||this.textureHandles.circle,P,T,E,S=[];if(0!==e.segments.length&&e.segments[0].from!==e.segments[0].to&&(y.isReady&&(s.bindTexture(s.TEXTURE_2D,y.handle),a.setTexture(y.handle)),i.styledMode?E=e.series.markerGroup&&e.series.markerGroup.getStyle("fill"):(E="POINTS"===e.drawMode&&e.series.pointAttribs&&e.series.pointAttribs().fill||e.series.color,u.colorByPoint&&(E=e.series.chart.options.colors[d])),e.series.fillOpacity&&u.fillOpacity&&(E=new t(E).setOpacity(g(u.fillOpacity,1)).get()),S=n(E).rgba,o.useAlpha||(S[3]=1),"LINES"===e.drawMode&&o.useAlpha&&S[3]<1&&(S[3]/=10),"add"===u.boostBlending?(s.blendFunc(s.SRC_ALPHA,s.ONE),s.blendEquation(s.FUNC_ADD)):"mult"===u.boostBlending||"multiply"===u.boostBlending?s.blendFunc(s.DST_COLOR,s.ZERO):"darken"===u.boostBlending?(s.blendFunc(s.ONE,s.ONE),s.blendEquation(s.FUNC_MIN)):s.blendFuncSeparate(s.SRC_ALPHA,s.ONE_MINUS_SRC_ALPHA,s.ONE,s.ONE_MINUS_SRC_ALPHA),a.reset(),e.colorData.length>0?(a.setUniform("hasColor",1),(T=new r(s,a)).build(Array(e.segments[0].from).concat(e.colorData),"aColor",4),T.bind()):(a.setUniform("hasColor",0),s.disableVertexAttribArray(s.getAttribLocation(a.getProgram(),"aColor"))),a.setColor(S),this.setXAxis(e.series.xAxis),this.setYAxis(e.series.yAxis),this.setThreshold(x,A),"POINTS"===e.drawMode&&a.setPointSize(2*g(u.marker&&u.marker.radius,.5)*c),a.setSkipTranslation(e.skipTranslation),"bubble"===e.series.type&&a.setBubbleUniforms(e.series,e.zMin,e.zMax,c),a.setDrawAsCircle(p[e.series.type]||!1),l)){if(m>0||"LINE_STRIP"!==e.drawMode)for(P=0;P<e.segments.length;P++)l.render(e.segments[P].from,e.segments[P].to,e.drawMode);if(e.hasMarkers&&v)for(a.setPointSize(2*g(u.marker&&u.marker.radius,5)*c),a.setDrawAsCircle(!0),P=0;P<e.segments.length;P++)l.render(e.segments[P].from,e.segments[P].to,"POINTS")}}),o.debug.timeRendering&&console.timeEnd("gl rendering"),this.postRenderCallback&&this.postRenderCallback(this),this.flush()}render(t){if(this.clear(),t.renderer.forExport)return this.renderChart(t);this.isInited?this.renderChart(t):setTimeout(()=>{this.render(t)},1)}setSize(t,e){let i=this.shader;i&&(this.width!==t||this.height!==e)&&(this.width=t,this.height=e,i.bind(),i.setPMatrix(b.orthoMatrix(t,e)))}init(t,e){let i=this.settings;if(this.isInited=!1,!t)return!1;i.debug.timeSetup&&console.time("gl setup");for(let e=0;e<m.length&&(this.gl=t.getContext(m[e],{}),!this.gl);++e);let s=this.gl;if(!s)return!1;e||this.flush(),s.enable(s.BLEND),s.blendFunc(s.SRC_ALPHA,s.ONE_MINUS_SRC_ALPHA),s.disable(s.DEPTH_TEST),s.depthFunc(s.LESS);let n=this.shader=new o(s);if(!n)return!1;this.vbuffer=new r(s,n);let l=(t,e)=>{let i={isReady:!1,texture:a.createElement("canvas"),handle:s.createTexture()},o=i.texture.getContext("2d");this.textureHandles[t]=i,i.texture.width=512,i.texture.height=512,o.mozImageSmoothingEnabled=!1,o.webkitImageSmoothingEnabled=!1,o.msImageSmoothingEnabled=!1,o.imageSmoothingEnabled=!1,o.strokeStyle="rgba(255, 255, 255, 0)",o.fillStyle="#FFF",e(o);try{s.activeTexture(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,i.handle),s.texImage2D(s.TEXTURE_2D,0,s.RGBA,s.RGBA,s.UNSIGNED_BYTE,i.texture),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.bindTexture(s.TEXTURE_2D,null),i.isReady=!0}catch(t){}};return l("circle",t=>{t.beginPath(),t.arc(256,256,256,0,2*Math.PI),t.stroke(),t.fill()}),l("square",t=>{t.fillRect(0,0,512,512)}),l("diamond",t=>{t.beginPath(),t.moveTo(256,0),t.lineTo(512,256),t.lineTo(256,512),t.lineTo(0,256),t.lineTo(256,0),t.fill()}),l("triangle",t=>{t.beginPath(),t.moveTo(0,512),t.lineTo(256,0),t.lineTo(512,512),t.lineTo(0,512),t.fill()}),l("triangle-down",t=>{t.beginPath(),t.moveTo(0,0),t.lineTo(256,512),t.lineTo(512,0),t.lineTo(0,0),t.fill()}),this.isInited=!0,i.debug.timeSetup&&console.timeEnd("gl setup"),!0}destroy(){let t=this.gl,e=this.shader,i=this.vbuffer;this.flush(),i&&i.destroy(),e&&e.destroy(),t&&(u(this.textureHandles,e=>{e.handle&&t.deleteTexture(e.handle)}),t.canvas.width=1,t.canvas.height=1)}}return b}),i(e,"Extensions/Boost/BoostSeries.js",[e["Extensions/Boost/BoostableMap.js"],e["Extensions/Boost/Boostables.js"],e["Extensions/Boost/BoostChart.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"],e["Extensions/Boost/WGLRenderer.js"]],function(t,e,i,s,o,r,n){let a,l;let{getBoostClipRect:h,isChartSeriesBoosting:c}=i,{getOptions:d}=s,{doc:u,noop:g,win:f}=o,{addEvent:p,error:m,extend:b,fireEvent:x,isArray:A,isNumber:v,pick:y,wrap:P,defined:T}=r,E=[];function S(t,e){let i=e.boost;t&&i&&i.target&&i.canvas&&!c(e.chart)&&t.allocateBufferForSingleSeries(e)}function C(t){return y(t&&t.options&&t.options.boost&&t.options.boost.enabled,!0)}function M(t,e){let i=t.constructor,s=t.seriesGroup||e.group,o=t.chartWidth,r=t.chartHeight,a=t,d="undefined"!=typeof SVGForeignObjectElement;a=c(t)?t:e;let g=a.boost=a.boost||{};return d=!1,l||(l=u.createElement("canvas")),!g.target&&(g.canvas=l,t.renderer.forExport||!d?(a.renderTarget=g.target=t.renderer.image("",0,0,o,r).addClass("highcharts-boost-canvas").add(s),g.clear=function(){g.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},g.copy=function(){g.resize(),g.target.attr({href:g.canvas.toDataURL("image/png")})}):(g.targetFo=t.renderer.createElement("foreignObject").add(s),a.renderTarget=g.target=u.createElement("canvas"),g.targetCtx=g.target.getContext("2d"),g.targetFo.element.appendChild(g.target),g.clear=function(){g.target.width=g.canvas.width,g.target.height=g.canvas.height},g.copy=function(){g.target.width=g.canvas.width,g.target.height=g.canvas.height,g.targetCtx.drawImage(g.canvas,0,0)}),g.resize=function(){o=t.chartWidth,r=t.chartHeight,(g.targetFo||g.target).attr({x:0,y:0,width:o,height:r}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1}),a instanceof i&&a.boost.markerGroup.translate(t.plotLeft,t.plotTop)},g.clipRect=t.renderer.clipRect(),(g.targetFo||g.target).attr({zIndex:e.options.zIndex}).clip(g.clipRect),a instanceof i&&(a.boost.markerGroup=a.renderer.g().add(s).translate(e.xAxis.pos,e.yAxis.pos))),g.canvas.width=o,g.canvas.height=r,g.clipRect&&g.clipRect.attr(h(t,a)),g.resize(),g.clear(),!g.wgl&&(g.wgl=new n(t=>{t.settings.debug.timeBufferCopy&&console.time("buffer copy"),g.copy(),t.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),g.wgl.init(g.canvas)||m("[highcharts boost] - unable to init WebGL renderer"),g.wgl.setOptions(t.options.boost||{}),a instanceof i&&g.wgl.allocateBuffer(t)),g.wgl.setSize(o,r),g.wgl}function U(t){let e=t.points;if(e){let t,i;for(i=0;i<e.length;i+=1)(t=e[i])&&t.destroyElements&&t.destroyElements()}if(["graph","area","tracker"].forEach(e=>{let i=t[e];i&&(t[e]=i.destroy())}),t.getZonesGraphs){let e=t.getZonesGraphs([["graph","highcharts-graph"]]);e.forEach(e=>{let i=t[e[0]];i&&(t[e[0]]=i.destroy())})}}function R(t,e,i,s,o,r){o=o||0,s=s||3e3;let n=o+s,a=!0;for(;a&&o<n&&o<t.length;)a=e(t[o],o),++o;a&&(o<t.length?r?R(t,e,i,s,o,r):f.requestAnimationFrame?f.requestAnimationFrame(function(){R(t,e,i,s,o)}):setTimeout(R,0,t,e,i,s,o):i&&i())}function k(t,e){let i=t.options,s=i.data,o=t.xAxis&&t.xAxis.options,r=t.yAxis&&t.yAxis.options,n=t.colorAxis&&t.colorAxis.options;return s.length>(i.boostThreshold||Number.MAX_VALUE)&&v(r.min)&&v(r.max)&&(!e||v(o.min)&&v(o.max))&&(!n||v(n.min)&&v(n.max))}function w(){let t=this,e=t.chart;e.boost&&e.boost.markerGroup===t.markerGroup&&(t.markerGroup=null),e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(function(e){return e.series===t})),e.hoverPoint&&e.hoverPoint.series===t&&(e.hoverPoint=null)}function D(){let t=this.boost;t&&t.canvas&&t.target&&(t.wgl&&t.wgl.clear(),t.clear&&t.clear())}function B(t){let e=t.boost;e&&e.canvas&&e.target&&e.wgl&&!c(t.chart)&&e.wgl.render(t.chart)}function L(t,e){let i=t.options,s=t.xAxis,o=t.pointClass;if(e instanceof o)return e;let r=t.xData||i.xData||t.processedXData||!1,n=new o().init(t,t.options.data[e.i],r?r[e.i]:void 0);return n.category=y(s.categories?s.categories[n.x]:n.x,n.x),n.dist=e.dist,n.distX=e.distX,n.plotX=e.plotX,n.plotY=e.plotY,n.index=e.i,n.percentage=e.percentage,n.isInside=t.isPointInside(n),n}function z(){let t=this.options||{},e=this.chart,i=this.xAxis,s=this.yAxis,o=t.xData||this.processedXData,r=t.yData||this.processedYData,n=t.data,l=i.getExtremes(),h=l.min,d=l.max,u=s.getExtremes(),f=u.min,p=u.max,m={},b=!!this.sampling,A=t.enableMouseTracking,v=t.threshold,y=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),P=!!t.stacking,E=this.cropStart||0,C=this.requireSorting,k=!o,w="x"===t.findNearestPointBy,D=this.xData||this.options.xData||this.processedXData||!1,L=!1,z,N=s.getThreshold(v),_,I,G,O;if(L=M(e,this),e.boosted=!0,!this.visible)return;(this.points||this.graph)&&U(this),c(e)?(this.markerGroup&&this.markerGroup!==e.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=e.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(e.boost&&this.markerGroup===e.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,e.seriesGroup));let X=this.points=[],V=(t,o,r,n)=>{let l=!!D&&D[E+r],h=t=>{e.inverted&&(t=i.len-t,o=s.len-o),X.push({destroy:g,x:l,clientX:t,plotX:t,plotY:o,i:E+r,percentage:n})};t=Math.ceil(t),a=w?t:t+","+o,A&&(m[a]?l===D[D.length-1]&&(X.length--,h(t)):(m[a]=!0,h(t)))};this.buildKDTree=g,L&&(S(L,this),L.pushSeries(this),B(this));let j=L.settings;e.renderer.forExport||(j.debug.timeKDTree&&console.time("kd tree building"),R(P?this.data:o||n,function(t,o){let n=void 0===e.index,a,l,c,u,g,m=!1,x=!0;return!T(t)||(!n&&(k?(a=t[0],l=t[1]):(a=t,l=r[o]),y?(k&&(l=t.slice(1,3)),m=l[0],l=l[1]):P&&(a=t.x,m=(l=t.stackY)-t.y,g=t.percentage),C||(x=(l||0)>=f&&l<=p),null!==l&&a>=h&&a<=d&&x&&(c=i.toPixels(a,!0),b?((void 0===G||c===z)&&(y||(m=l),(void 0===O||l>I)&&(I=l,O=o),(void 0===G||m<_)&&(_=m,G=o)),w&&c===z||(void 0!==G&&(u=s.toPixels(I,!0),N=s.toPixels(_,!0),V(c,u,O,g),N!==u&&V(c,N,G,g)),G=O=void 0,z=c)):V(c,u=Math.ceil(s.toPixels(l,!0)),o,g))),!n)},()=>{x(this,"renderedCanvas"),delete this.buildKDTree,this.buildKDTree(),j.debug.timeKDTree&&console.timeEnd("kd tree building")}))}function N(t){let e=!0;if(this.chart.options&&this.chart.options.boost&&(e=void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled),!e||!this.boosted)return t.call(this);this.chart.boosted=!0;let i=M(this.chart,this);i&&(S(i,this),i.pushSeries(this)),B(this)}function _(t){return this.boosted&&k(this)?{}:t.apply(this,[].slice.call(arguments,1))}function I(e){let i=this.options.data,s=t=>!this.forceCrop&&(c(this.chart)||(t?t.length:0)>=(this.options.boostThreshold||Number.MAX_VALUE));if(C(this.chart)&&t[this.type]){if(s(i)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&k(this,!0)||(e.apply(this,[].slice.call(arguments,1)),i=this.processedXData),this.boosted=s(i),this.boosted){let t;this.options.data&&this.options.data.length&&!v(t=this.getFirstValidPoint(this.options.data))&&!A(t)&&m(12,!1,this.chart),function(t){t.boost=t.boost||{getPoint:e=>L(t,e)};let e=t.boost.altered=[];["allowDG","directTouch","stickyTracking"].forEach(i=>{e.push({prop:i,val:t[i],own:Object.hasOwnProperty.call(t,i)})}),t.allowDG=!1,t.directTouch=!1,t.stickyTracking=!0,t.finishedAnimating=!0,t.labelBySeries&&(t.labelBySeries=t.labelBySeries.destroy())}(this)}else!function(t){let e=t.boost;e&&((e.altered||[]).forEach(e=>{e.own?t[e.prop]=e.val:delete t[e.prop]}),e.clear&&e.clear())}(this)}else e.apply(this,[].slice.call(arguments,1))}function G(t){let e=t.apply(this,[].slice.call(arguments,1));return this.boost&&e?this.boost.getPoint(e):e}return{compose:function(i,s,o){if(r.pushUnique(E,i)){p(i,"destroy",w),p(i,"hide",D);let e=i.prototype;o&&(e.renderCanvas=z),P(e,"getExtremes",_),P(e,"processData",I),P(e,"searchPoint",G),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(i=>(function(e,i,s){function o(e){let i=this.options.stacking&&("translate"===s||"generatePoints"===s);this.boosted&&!i&&C(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&t[this.type]&&0!==this.options.boostThreshold?"render"===s&&this.renderCanvas&&this.renderCanvas():e.call(this)}P(e,s,o),"translate"===s&&["column","arearange","columnrange","heatmap","treemap"].forEach(function(t){i[t]&&P(i[t].prototype,s,o)})})(e,s,i))}if(r.pushUnique(E,d)){let t=d().plotOptions;e.forEach(e=>{let i=t[e];i&&(i.boostThreshold=5e3,i.boostData=[],s[e].prototype.fillOpacity=!0)})}if(o){let{area:t,areaspline:e,bubble:i,column:o,heatmap:n,scatter:a,treemap:l}=s;if(t&&r.pushUnique(E,t)&&b(t.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),e&&r.pushUnique(E,e)&&b(e.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),i&&r.pushUnique(E,i)){let t=i.prototype;delete t.buildKDTree,P(t,"markerAttribs",function(t){return!this.boosted&&t.apply(this,[].slice.call(arguments,1))})}o&&r.pushUnique(E,o)&&b(o.prototype,{fill:!0,sampling:!0}),a&&r.pushUnique(E,a)&&(a.prototype.fill=!0),[n,l].forEach(t=>{t&&r.pushUnique(E,t)&&P(t.prototype,"drawPoints",N)})}return i},destroyGraphics:U,eachAsync:R,getPoint:L}}),i(e,"Extensions/BoostCanvas.js",[e["Extensions/Boost/BoostChart.js"],e["Extensions/Boost/BoostSeries.js"],e["Core/Chart/Chart.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){var n;let{getBoostClipRect:a,isChartSeriesBoosting:l}=t,{destroyGraphics:h}=e,{parse:c}=s,{doc:d,noop:u}=o,{addEvent:g,fireEvent:f,isNumber:p,merge:m,pick:b,pushUnique:x,wrap:A}=r;return function(t){let o;let n="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=",v=[];function y(t,e,i,s,o){o&&e!==o.clientX&&(t.moveTo(o.clientX,o.yBottom),t.lineTo(o.clientX,o.plotY),t.lineTo(e,i),t.lineTo(e,s))}function P(t,e,i,s,o){t.moveTo(e,i),t.arc(e,i,this.radii&&this.radii[o],0,2*Math.PI,!1)}function T(t,e,i,s){t.rect(e-1,i,1,s-i)}function E(){this.boost&&this.boost.copy&&this.boost.copy()}function S(){let t=this.boost||{};t.target&&t.target.attr({href:n}),t.canvas&&t.canvas.getContext("2d").clearRect(0,0,t.canvas.width,t.canvas.height)}function C(){l(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()}function M(t,e,i){t.lineTo(e,i)}function U(){let t;let e=this.chart,i=l(e)?e:this,s=i===e?e.seriesGroup:e.seriesGroup||this.group,o=e.chartWidth,r=e.chartHeight,h=function(t,e,i,s,o,r,n){t.call(this,i,e,s,o,r,n)},c=i.boost=i.boost||{};return t=c.targetCtx,c.canvas||(c.canvas=d.createElement("canvas"),c.target=e.renderer.image("",0,0,o,r).addClass("highcharts-boost-canvas").add(s),t=c.targetCtx=c.canvas.getContext("2d"),e.inverted&&["moveTo","lineTo","rect","arc"].forEach(e=>{A(t,e,h)}),c.copy=function(){c.target.attr({href:c.canvas.toDataURL("image/png")})},c.clear=function(){t.clearRect(0,0,c.canvas.width,c.canvas.height),i===c.target&&c.target.attr({href:n})},c.clipRect=e.renderer.clipRect(),c.target.clip(c.clipRect)),c.canvas.width!==o&&(c.canvas.width=o),c.canvas.height!==r&&(c.canvas.height=r),c.target.attr({x:0,y:0,width:o,height:r,style:"pointer-events: none",href:n}),c.clipRect&&c.clipRect.attr(a(e,i)),t}function R(){let t=this,i=t.options,a=t.chart,l=t.xAxis,d=t.yAxis,x=a.options.boost||{},A={timeRendering:x.timeRendering||!1,timeSeriesProcessing:x.timeSeriesProcessing||!1,timeSetup:x.timeSetup||!1},v=t.processedXData,y=t.processedYData,P=i.data,T=l.getExtremes(),E=T.min,S=T.max,C=d.getExtremes(),M=C.min,U=C.max,R={},k=!!t.sampling,w=i.marker&&i.marker.radius,D=t.cvsStrokeBatch||1e3,B=i.enableMouseTracking,L=i.threshold,z=p(L),N=d.getThreshold(L),_=t.fill,I=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),G=!!i.stacking,O=t.cropStart||0,X=a.options.loading,V=t.requireSorting,j=i.connectNulls,F=!v,H=G?t.data:v||P,W=t.fillOpacity?s.parse(t.color).setOpacity(b(i.fillOpacity,.75)).get():t.color,Y="x"===i.findNearestPointBy,q=this.boost||{},Z=t.cvsDrawPoint,K=i.lineWidth?t.cvsLineTo:void 0,Q=w&&w<=1?t.cvsMarkerSquare:t.cvsMarkerCircle;q.target&&q.target.attr({href:n}),(t.points||t.graph)&&h(t),t.plotGroup("group","series",t.visible?"visible":"hidden",i.zIndex,a.seriesGroup),t.markerGroup=t.group,g(t,"destroy",function(){t.markerGroup=null});let J=this.points=[],$=this.getContext();if(t.buildKDTree=u,q.clear&&q.clear(),!t.visible)return;P.length>99999&&(a.options.loading=m(X,{labelStyle:{backgroundColor:c("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),r.clearTimeout(o),a.showLoading("Drawing..."),a.options.loading=X),A.timeRendering&&console.time("canvas rendering");let tt=0,te,ti,ts=N,to,tr,tn,ta,tl,th,tc=function(){_?($.fillStyle=W,$.fill()):($.strokeStyle=t.color,$.lineWidth=i.lineWidth,$.stroke())},td=function(e,i,s,o){0===tt&&($.beginPath(),K&&($.lineJoin="round")),a.scroller&&"highcharts-navigator-series"===t.options.className?(i+=a.scroller.top,s&&(s+=a.scroller.top)):i+=a.plotTop,e+=a.plotLeft,to?$.moveTo(e,i):Z?Z($,e,i,s,ti):K?K($,e,i):Q&&Q.call(t,$,e,i,w,o),(tt+=1)===D&&(tc(),tt=0),ti={clientX:e,plotY:i,yBottom:s}},tu=this.xData||this.options.xData||this.processedXData||!1,tg=function(t,e,i){th=Y?t:t+","+e,B&&!R[th]&&(R[th]=!0,a.inverted&&(t=l.len-t,e=d.len-e),J.push({x:!!tu&&tu[O+i],clientX:t,plotX:t,plotY:e,i:O+i}))};e.eachAsync(H,(e,i)=>{let s=void 0===a.index,o,r,n,h,c,u,g=!1,f=!1,p=NaN,m=NaN,b=!0;return!s&&(F?(o=e[0],r=e[1],H[i+1]&&(p=H[i+1][0]),H[i-1]&&(m=H[i-1][0])):(o=e,r=y[i],H[i+1]&&(p=H[i+1]),H[i-1]&&(m=H[i-1])),p&&p>=E&&p<=S&&(g=!0),m&&m>=E&&m<=S&&(f=!0),I?(F&&(r=e.slice(1,3)),u=r[0],r=r[1]):G&&(o=e.x,u=(r=e.stackY)-e.y),c=null===r,V||(b=r>=M&&r<=U),!c&&(o>=E&&o<=S&&b||g||f)&&(n=Math.round(l.toPixels(o,!0)),k?((void 0===ta||n===te)&&(I||(u=r),(void 0===tl||r>tn)&&(tn=r,tl=i),(void 0===ta||u<tr)&&(tr=u,ta=i)),n!==te&&(void 0!==ta&&(h=d.toPixels(tn,!0),ts=d.toPixels(tr,!0),td(n,z?Math.min(h,N):h,z?Math.max(ts,N):ts,i),tg(n,h,tl),ts!==h&&tg(n,ts,ta)),ta=tl=void 0,te=n)):(td(n,h=Math.round(d.toPixels(r,!0)),ts,i),tg(n,h,i))),to=c&&!j,i%5e4==0&&(t.boost&&t.boost.copy?t.boost.copy():t.chart.boost&&t.chart.boost.copy&&t.chart.boost.copy())),!s},function(){let e=a.loadingDiv,i=a.loadingShown;tc(),t.canvasToSVG(),A.timeRendering&&console.timeEnd("canvas rendering"),f(t,"renderedCanvas"),i&&(e.style.transition="opacity 250ms",e.opacity=0,a.loadingShown=!1,o=setTimeout(function(){e.parentNode&&e.parentNode.removeChild(e),a.loadingDiv=a.loadingSpan=null},250)),delete t.buildKDTree,t.buildKDTree()},a.renderer.forExport?Number.MAX_VALUE:void 0)}function k(t,e,i,s){t.moveTo(e,i),t.arc(e,i,s,0,2*Math.PI,!1)}function w(t,e,i,s){t.rect(e-s,i-s,2*s,2*s)}function D(){let t=this.chart,e=this.getContext(),i=this.chart.inverted,s=this.xAxis,o=this.yAxis;e?(this.points.forEach(r=>{let n=r.plotY,a;if(void 0!==n&&!isNaN(n)&&null!==r.y&&e){let{x:n=0,y:l=0,width:h=0,height:c=0}=r.shapeArgs||{};a=t.styledMode?r.series.colorAttribs(r):r.series.pointAttribs(r),e.fillStyle=a.fill,i?e.fillRect(o.len-l+s.left,s.len-n+o.top,-c,-h):e.fillRect(n+s.left,l+o.top,h,c)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")}t.compose=function(t,e,s){if(x(v,t)&&i.prototype.callbacks.push(t=>{g(t,"predraw",S),g(t,"render",E)}),x(v,e)){let t=e.prototype;t.canvasToSVG=C,t.cvsLineTo=M,t.getContext=U,t.renderCanvas=R}let{area:o,bubble:r,column:n,heatmap:a,scatter:l}=s;if(o&&x(v,o)){let t=o.prototype;t.cvsDrawPoint=y,t.fill=!0,t.fillOpacity=!0,t.sampling=!0}if(r&&x(v,r)){let t=r.prototype;t.cvsMarkerCircle=P,t.cvsStrokeBatch=1}if(n&&x(v,n)){let t=n.prototype;t.cvsDrawPoint=T,t.fill=!0,t.sampling=!0}if(a&&x(v,a)){let t=a.prototype;A(t,"drawPoints",D)}if(l&&x(v,l)){let t=l.prototype;t.cvsMarkerCircle=k,t.cvsMarkerSquare=w,t.fill=!0}}}(n||(n={})),n}),i(e,"masters/modules/boost-canvas.src.js",[e["Core/Globals.js"],e["Extensions/BoostCanvas.js"]],function(t,e){t.initCanvasBoost=function(){e.compose(t.Chart,t.Series,t.seriesTypes)}})});//# sourceMappingURL=boost-canvas.js.map