<?php
$id = "snmptraps_volume_chart_" . random_string(6);
$chart_id = $id."-chart";

$stylewidth = "";
if ($mode == DASHLET_MODE_INBOARD) {
    $stylewidth = "width: 100%; height: 100%;";
} else {
    $stylewidth = "width: 300px; height: 170px;";
}

$interval_value = intval(grab_array_var($args, 'interval_value', '5'));
$interval_unit  = strtoupper(grab_array_var($args, 'interval_unit', "MINUTE"));
$lookback_value = intval(grab_array_var($args, 'lookback_value', "90"));
$lookback_unit  = strtoupper(grab_array_var($args, 'lookback_unit', "MINUTE"));

?>
<div class="snmptraps_volume_chart" style="height: 100%; width: 100%;">

<table class="infotable table table-condensed table-striped table-bordered" style="<?php echo $stylewidth; ?>">
<thead>
<tr><th><a href="<?php echo get_component_url_base('nxti') . '/index.php'; ?>"><?php echo _('SNMP Trap Volume');?></a></th></tr>
</thead>
<tbody id="">
<tr><td>
<div style="padding: 5px; <?php echo $stylewidth; ?>">

<div id="throbber_<?php echo $id; ?>"><?php echo get_throbber_html(); ?>'</div>

<div style="height: 100%;" id="<?php echo $id; ?>"></div>

</div>
</td></tr>
</tbody>
</table>

</div>

<script type="text/javascript">
$(document).ready(function() {
    get_<?php echo $id; ?>_content();
    // Re-build the content when we resize
    $("#<?php echo $id; ?>").closest(".ui-resizable").on("resizestop", function(e, ui) {
        get_<?php echo $id; ?>_content("false");
    });


    $("#<?php echo $id; ?>").everyTime(<?php echo get_dashlet_refresh_rate(15, "systat_eventqueuechart"); ?>, "timer-<?php echo $id; ?>", function(i) {
        get_<?php echo $id; ?>_content();
    });

    $("#<?php echo $id; ?>").on("click", function() {
        get_<?php echo $id; ?>_content();
    });
});

function delete_<?php echo $id; ?>_throbber() {
    $("#throbber_<?php echo $id; ?>").each(function(){
        $(this).remove();  // remove the throbber if it exists
    });
}
    
function get_<?php echo $id; ?>_content() {
    $("#<?php echo $id; ?>").each(function() {

        var content_this = this;
        var url = '<?php echo get_base_url(). 'includes/dashlets/snmptraps/ajax.php'; ?>';

        $.ajax({
            type: "GET",
            url: url,
            data: { 
                nsp: nsp_str, 
                container: "<?php echo $id; ?>", 
                interval_value: "<?php echo addslashes($interval_value); ?>",
                interval_unit:  "<?php echo addslashes($interval_unit); ?>",
                lookback_value: "<?php echo addslashes($lookback_value); ?>",
                lookback_unit:  "<?php echo addslashes($lookback_unit); ?>",
            },
            success: function(data) {
                $(content_this).html(data);
            }

        });
        delete_<?php echo $id; ?>_throbber();
    });
}
</script>
