<?php
//
// Unconfigured Object Config Wizard
// Copyright (c) 2011-2024 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../configwizardhelper.inc.php');

passiveobject_configwizard_init();

function passiveobject_configwizard_init()
{
    $name = "passiveobject";
    $args = array(
        CONFIGWIZARD_NAME => $name,
        CONFIGWIZARD_VERSION => "2.0.1",
        CONFIGWIZARD_TYPE => CONFIGWIZARD_TYPE_MONITORING,
        CONFIGWIZARD_DESCRIPTION => _("Monitor hosts and services that have been passively submitted to Nagios, but have not yet been configured."),
        CONFIGWIZARD_DISPLAYTITLE => _("Unconfigured Passive Object"),
        CONFIGWIZARD_FUNCTION => 'passiveobject_configwizard_func',
        CONFIGWIZARD_PREVIEWIMAGE => 'passiveobject.png',
        CONFIGWIZARD_SHOWASAVAILABLE => false,
        CONFIGWIZARD_DISPLAYFUNCTION => 'is_admin',
        CONFIGWIZARD_FILTER_GROUPS => array(''),
        CONFIGWIZARD_REQUIRES_VERSION => 60100
    );
    register_configwizard($name, $args);
}

/**
 * @param string $mode
 * @param null   $inargs
 * @param        $outargs
 * @param        $result
 *
 * @return string
 */
function passiveobject_configwizard_func($mode = "", $inargs = null, &$outargs = null, &$result = null)
{
    $wizard_name = "passiveobject";

    // initialize return code and output
    $result = 0;
    $output = "";

    // initialize output args - pass back the same data we got
    $outargs[CONFIGWIZARD_PASSBACK_DATA] = $inargs;

    switch ($mode) {
        case CONFIGWIZARD_MODE_GETSTAGE1HTML:

            # Get the existing host/node configurations.
            # TODO: Include passwords/secrets?
            $nodes = get_configwizard_hosts($wizard_name);

            ########################################################################################
            # Load the html
            # - The html needs to end up in the $output string, so use ob_start() and ob_get_clean()
            #   to load the PHP from the Step1 file into the $output string.
            ########################################################################################
            ob_start();
            include __DIR__.'/steps/step1.php';
            $output = ob_get_clean();

            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE1DATA:

            $back = array_key_exists("backButton", $_POST);

            // get variables that were passed to us
            $hosts_serial = grab_array_var($inargs, "hosts_serial", "");
            $hosts = json_decode(base64_decode($hosts_serial), true);

            if (!is_array($hosts)) {
                $hosts = grab_array_var($inargs, "host", array());
            }

            // check for errors
            $errors = 0;
            $errmsg = array();

            if (count($hosts) == 0) {
                ob_start();
?>
                <?= _('Please initiate step 1 of the configuration process through the <strong>Unconfigured Objects</strong> page.') ?>
<?php
                $errmsg[$errors++] = ob_get_clean();
            }

            if ($errors > 0) {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
                $result = 1;
            }

            break;


        case CONFIGWIZARD_MODE_GETSTAGE2HTML:
            
            //print_r($inargs);

            // get variables that were passed to us
            $securitycheck = grab_array_var($inargs, "securitycheck", "no");
            $isvolatile = grab_array_var($inargs, "isvolatile", ($securitycheck == "yes") ? "yes" : "no");
            $statestalking = grab_array_var($inargs, "statestalking", ($securitycheck == "yes") ? "yes" : "no");

            $hosts_serial = grab_array_var($inargs, "hosts_serial", "");
            $hosts = json_decode(base64_decode($hosts_serial), true);

            if (!is_array($hosts)) {
                $hosts = grab_array_var($inargs, "host", array());
            }

            ########################################################################################
            # Load the html
            # - The html needs to end up in the $output string, so use ob_start() and ob_get_clean()
            #   to load the PHP from the Step2 file into the $output string.
            ########################################################################################
            ob_start();
            include __DIR__.'/steps/step2.php';
            $output = ob_get_clean();

            break;


        case CONFIGWIZARD_MODE_VALIDATESTAGE2DATA:

            $back = array_key_exists("backButton", $_POST);

            /* If the user came back from CONFIGWIZARD_MODE_GETSTAGE3HTML then we don't need to revalidate and check for errors */
            if ($back) {
                break;
            }

            $hosts_serial = grab_array_var($inargs, "hosts_serial", "");
            $hosts = json_decode(base64_decode($hosts_serial), true);

            if (!is_array($hosts)) {
                $hosts = grab_array_var($inargs, "host", array());
            }

            // check for errors
            $errors = 0;
            $errmsg = array();

            if (!is_array($hosts)) {
                $errmsg[$errors++] = _("No hosts specified.");
            } else if (count($hosts) == 0) {
                $errmsg[$errors++] = _("No hosts specified.");
            }

            if ($errors > 0) {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
                $result = 1;
            }

            break;


        case CONFIGWIZARD_MODE_GETSTAGE3OPTS:

            $output .= _("There are no monitoring options to configure with passive objects.  Click Next to continue.");

            $result = CONFIGWIZARD_HIDE_OPTIONS;

            break;

        case CONFIGWIZARD_MODE_GETSTAGE3HTML:

            //print_r($inargs);

            // get variables that were passed to us
            $securitycheck = grab_array_var($inargs, "securitycheck", "no");
            $isvolatile = grab_array_var($inargs, "isvolatile", ($securitycheck == "yes") ? "yes" : "no");
            $statestalking = grab_array_var($inargs, "statestalking", ($securitycheck == "yes") ? "yes" : "no");

            $hosts_serial = grab_array_var($inargs, "hosts_serial", "");
            $hosts = json_decode(base64_decode($hosts_serial), true);
            if (!is_array($hosts))
                $hosts = grab_array_var($inargs, "host", array());

            $output = '

        <input type="hidden" name="securitycheck" value="' . encode_form_val($securitycheck) . '">
        <input type="hidden" name="isvolatile" value="' . encode_form_val($isvolatile) . '">
        <input type="hidden" name="statestalking" value="' . encode_form_val($statestalking) . '">
        <input type="hidden" name="hosts_serial" value="' . base64_encode(json_encode($hosts)) . '">
';
            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE3DATA:

            break;
        /*
                case CONFIGWIZARD_MODE_GETSTAGE4OPTS:

                    // hide some notification options
                    $output='';
                    $result=CONFIGWIZARD_HIDE_OPTIONS;
                    $outargs[CONFIGWIZARD_HIDDEN_OPTIONS]=array(
                        CONFIGWIZARD_HIDE_NOTIFICATION_DELAY,
                        CONFIGWIZARD_HIDE_NOTIFICATION_INTERVAL,
                        );

                    break;
        */
        case CONFIGWIZARD_MODE_GETFINALSTAGEHTML:


            $output = '
            ';
            break;

        case CONFIGWIZARD_MODE_GETOBJECTS:

            $hosts_serial = grab_array_var($inargs, "hosts_serial", "");
            $hosts = json_decode(base64_decode($hosts_serial), true);
            if (!is_array($hosts))
                $hosts = grab_array_var($inargs, "host", array());

            $securitycheck = grab_array_var($inargs, "securitycheck", "no");
            $isvolatile = grab_array_var($inargs, "isvolatile", ($securitycheck == "yes") ? "yes" : "no");
            $statestalking = grab_array_var($inargs, "statestalking", ($securitycheck == "yes") ? "yes" : "no");

            $objs = array();

            $datas = @file_get_contents(get_root_dir() . "/var/corelog.newobjects");
            if ($datas == "" || $datas == null)
                $newobjects = array();
            else
                $newobjects = @unserialize($datas);

            foreach ($hosts as $hostname => $ts) {


                if (!host_exists($hostname)) {
                    $objs[] = array(
                        "type" => OBJECTTYPE_HOST,
                        "use" => "xiwizard_passive_host",
                        "host_name" => $hostname,
                        "address" => $hostname,
                        "icon_image" => "passiveobject.png",
                        "statusmap_image" => "passiveobject.png",
                        'stalking_options' => ($statestalking == "yes") ? "o,u,d" : "n",
                        "_xiwizard" => $wizard_name,
                    );
                }

                foreach ($newobjects[$hostname]["services"] as $svcname => $sarr) {

                    $objs[] = array(
                        'type' => OBJECTTYPE_SERVICE,
                        'host_name' => $hostname,
                        'service_description' => $svcname,
                        'use' => 'xiwizard_passive_service',
                        'check_interval' => 1,
                        'retry_interval' => 1,
                        'max_check_attempts' => 1,
                        'is_volatile' => ($isvolatile == "yes") ? 1 : 0,
                        'stalking_options' => ($statestalking == "yes") ? "o,w,u,c" : "n",
                        //'icon_image' => 'passivecheck.png',
                        '_xiwizard' => $wizard_name,
                    );
                }

            }

            //echo "OBJECTS:<BR>";
            //print_r($objs);
            //exit();

            // return the object definitions to the wizard
            $outargs[CONFIGWIZARD_NAGIOS_OBJECTS] = $objs;

            break;


        // THE FOLLOWING MODES ARE POST-CONFIGURATION CALLBACKS
        // THEY CAN BE USED TO DO CONFIGURATION TASKS, ETC AFTER A NEW
        //      CONFIGURATION HAS BEEN SUBMITTED

        case CONFIGWIZARD_MODE_COMMITERROR:
            echo "COMMITERROR!\n";
            break;

        case CONFIGWIZARD_MODE_COMMITCONFIGERROR:
            echo "COMMITCONFIGERROR!\n";
            break;

        case CONFIGWIZARD_MODE_COMMITPERMSERROR:
            echo "COMMITPERMSERROR!\n";
            break;

        case CONFIGWIZARD_MODE_COMMITOK:

            $services_serial = grab_array_var($inargs, "services_serial");
            $services = json_decode(base64_decode($services_serial), true);

            break;

        default:
            break;
    }

    return $output;
}