    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="username" value="<?= encode_form_val($username) ?>">
    <input type="hidden" name="password" value="<?= encode_form_val($password) ?>">
    <input type="hidden" name="database" value="<?= encode_form_val($database) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('MongoDB Information') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this MongoDB Database')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="username" class="form-label"><?= _('Username') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="database" class="form-label"><?= _('Database') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="database" id="database" value="<?= encode_form_val($database) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Database") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="database_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('MongoDB Database Metrics') ?></h2>
        <p><?= _('Specify the metrics you would like to monitor on the MongoDB database') ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ds" class="form-check-input" name="services[database_size]"  <?= is_checked(grab_array_var($services, "database_size"), "on") ?> >
                        <label for="ds" class="form-check-label bold"><?= _('Database Size') ?> <?= xi6_info_tooltip(_("Monitor the size of the database in bytes.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[database_size_warning]" name="serviceargs[database_size_warning]" value="<?= encode_form_val($serviceargs['database_size_warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">b</span>
                            <i id="serviceargs_database_size_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[database_size_critical]" name="serviceargs[database_size_critical]" value="<?= encode_form_val($serviceargs['database_size_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">b</span>
                            <i id="serviceargs_database_size_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="no" class="form-check-input" name="services[database_indexes]"  <?= is_checked(grab_array_var($services, "database_indexes"), "on") ?> >
                        <label for="no" class="form-check-label bold"><?= _('Database Indexes Size') ?> <?= xi6_info_tooltip(_("Monitor the size of the database indexes.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[database_indexes_warning]" name="serviceargs[database_indexes_warning]" value="<?= encode_form_val($serviceargs['database_indexes_warning']) ?>" class="form-control form-control-sm monitor">
		                    <span class="input-group-text">b</span>
                            <i id="serviceargs_database_indexes_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[database_indexes_critical]" name="serviceargs[database_indexes_critical]" value="<?= encode_form_val($serviceargs['database_indexes_critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">b</span>
                            <i id="serviceargs_database_indexes_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="nc" class="form-check-input" name="services[collections]"  <?= is_checked(grab_array_var($services, "collections"), "on") ?> >
                        <label for="nc" class="form-check-label bold"><?= _('Number of Collections') ?> <?= xi6_info_tooltip(_("Monitor the number of collections in the database.")) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[collections_warning]" name="serviceargs[collections_warning]" value="<?= encode_form_val($serviceargs['collections_warning']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_collections_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[collections_critical]" name="serviceargs[collections_critical]" value="<?= encode_form_val($serviceargs['collections_critical']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_collections_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
