#!/usr/bin/env python3
import sys
from sys import argv
from subprocess import Popen
from subprocess import PIPE
import argparse

argument_parser = argparse.ArgumentParser()

argument_parser.add_argument( '-H',
                     '--host',
                     required=True,
                     type=str,
                     help='The host you wish to run a plugin against.')

argument_parser.add_argument( '-u',
                     '--user',
                     required=True,
                     type=str,
                     help='Username for connecting to the remote system.')


argument_parser.add_argument( '-a',
                     '--args',
                     required=False,
                     type=str,
                     help='Arguments to be sent to the plugin. e.g. -warning 80 -critical 90'
)

arguments = argument_parser.parse_args(argv[1:])
plugin_code = """

<#
.DESCRIPTION
A PowerShell based plugin for Nagios and Nagios-like systems. This plugin checks the status of a specified service on Windows machines.
.SYNOPSIS
A PowerShell based plugin to check the status of a specified service on Windows machines
.NOTES
Yes, I firmly believe that the Print Spooler should be stopped unless you are monitoring a print server
This plugin does not return performance data.
.PARAMETER expectedstate
The expected state of the service. I.e. running, or stopped.
.PARAMETER servicename
The name of the service you wish to check. Specifically the Service Name (e.g. Spooler), not the Display Name (e.g. Print Spooler)
.EXAMPLE
PS> .\\check_service.ps1 -expectedstate Stopped -servicename Spooler
#>
param (
    [Parameter(Mandatory=$false)][ValidateSet('Running', 'Stopped')][string]$expectedstate = $null,
    [Parameter(Mandatory=$false)][string]$servicename
)

$exitcode = 3
$exitMessage = 'Nothing changed the status output!'

function processCheck {
    param (
        [Parameter(Mandatory=$true)]$checkResult
    )

    [array]$returnArray

    if (!$expectedstate) {
        $returnArray = @(0, "OK: Service $($checkResult.Name) is $($checkResult.State), no expectations set")
    }
    elseif ($expectedstate -eq 'Stopped' -and $checkResult.State -eq 'Running') {
        $returnArray = @(2, "CRITICAL: Service $($checkResult.Name) is $($checkResult.State), should be 'Stopped'")
    }
    elseif ($expectedstate -eq 'Running' -and $checkResult.State -eq 'Stopped') {
        $returnArray = @(2, "CRITICAL: Service $($checkResult.Name) is $($checkResult.State), should be 'Running'")
    }
    else {
        $returnArray = @(0, "OK: Service $($checkResult.Name) is $($checkResult.State), as it should be")
    }

    return $returnArray

}


#Get a list of services
$servicedata = Get-WmiObject -Class Win32_Service | where -Property Name -eq $servicename | select -Property Name,State,ExitCode,ProcessID
$processArray = @()

if ($servicedata -eq $null) {
    $exitcode = 2
    $exitMessage = 'Could not find service named: $servicename'
}
else {
    $processArray = processCheck -checkResult $servicedata
}

$exitcode = $processArray[1]
$exitMessage = $processArray[2]

write-output $exitMessage
exit $exitcode

"""


echo_process = ""
arguments_length = 0
if arguments.args is not None:
    echo_process = Popen(["echo", "function checkplugin {\n", plugin_code, " }\n", "checkplugin ", arguments.args, "\n"], stdout=PIPE)
    arguments_length = len(arguments.args) + 1
else:
    echo_process = Popen(["echo", "function checkplugin {\n", plugin_code, " }\n", "checkplugin  \n"], stdout=PIPE)

ssh_process = Popen(["ssh", "-T", "-l", arguments.user, arguments.host, "powershell.exe"], stdin=echo_process.stdout, stdout=PIPE)
echo_process.stdout.close()
process_output = [ssh_process.communicate(), ssh_process.returncode]

decoded_stdout = process_output[0][0].decode()

if(process_output[1] == 255):
    print("CRITICAL: Connection to host failed. Check that the nagios user can passwordlessly connect to the host.")
    sys.exit(2)     

exit_status_code = process_output[1]
exit_message = decoded_stdout[(decoded_stdout.find("checkplugin  ") + 18 + arguments_length):(len(decoded_stdout) - 1)].rstrip()
print(exit_message)
sys.exit(exit_status_code)