<?php
//
// Simile Timeline
// Copyright (c) 2010-2019 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../../common.inc.php');

// Initialization stuff
pre_init();
init_session();

// grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs();
check_authentication(false);


route_request();


function route_request()
{
    global $request;

    $mode = grab_request_var("mode");
    switch ($mode) {
        default:
            display_timeline();
            break;
    }
}

function similetimeline_insert_includes()
{
    $url = get_base_url() . "includes/components/similetimeline";
    ?>
    <script type="text/javascript">
        Timeline_ajax_url = "<?php echo $url;?>/timeline_2.3.0/timeline_ajax/simile-ajax-api.js";
        Timeline_urlPrefix = '<?php echo $url;?>/timeline_2.3.0/timeline_js/';
        Timeline_parameters = 'bundle=true';
    </script>
    <!-- NOTE: The local copy of timeline does not appear to show time durations properly, but the online version does -->
    <script src="<?php echo $url; ?>/timeline_2.3.0/timeline_js/timeline-api.js" type="text/javascript"></script>

<?php
}

function display_timeline()
{
    global $request;

    register_callback(CALLBACK_PAGE_HEAD, 'similetimeline_insert_includes');

    // Get values passed in GET/POST request
    $reportperiod = grab_request_var("reportperiod", "last24hours");
    $startdate = grab_request_var("startdate", "");
    $enddate = grab_request_var("enddate", "");
    $search = grab_request_var("search", "");
    $host = grab_request_var("host", "");
    $service = grab_request_var("service", "");
    $hostgroup = grab_request_var("hostgroup", "");
    $servicegroup = grab_request_var("servicegroup", "");
    $datatype = grab_request_var("datatype", "events");

    // We search for hosts, so clear host if search is present
    if ($search != "") {
        $host = "";
        $service = "";
    }

    if ($datatype == "nagios") {
        $reportperiod = "custom";
        $startdate = "1999-03-19";
        $enddate = time();
    }

    // Determine start/end times based on period
    get_times_from_report_timeperiod($reportperiod, $starttime, $endtime, $startdate, $enddate);

    $auto_start_date = get_datetime_string(strtotime('yesterday'), DT_SHORT_DATE);
    $auto_end_date = get_datetime_string(strtotime('today'), DT_SHORT_DATE);

    // Get timezone datepicker format
    if (isset($_SESSION['date_format']))
        $format = $_SESSION['date_format'];
    else {
        if (is_null($format = get_user_meta(0, 'date_format')))
            $format = get_option('default_date_format');
    }
    $f = get_date_formats();

    $js_date = 'mm/dd/yy';
    if ($format == DF_ISO8601) {
        $js_date = 'yy-mm-dd';
    } else if ($format == DF_US) {
        $js_date = 'mm/dd/yy';
    } else if ($format == DF_EURO) {
        $js_date = 'dd/mm/yy';
    }

    // Makes sure user has appropriate license level
    licensed_feature_check();

    // Start the HTML page
    do_page_start(array("page_title" => "Event Timeline"), true);
?>

<script type="text/javascript">
$(document).ready(function () {

    $('.datetimepicker').datetimepicker({
        dateFormat: '<?php echo $js_date; ?>',
        timeFormat: 'HH:mm:ss',
        showHour: true,
        showMinute: true,
        showSecond: true
    });

    $('.btn-datetimepicker').click(function() {
        var id = $(this).data('picker');
        $('#' + id).datetimepicker('show');
    });

    $('#startdateBox').click(function () {
        $('#reportperiodDropdown').val('custom');
        if ($('#startdateBox').val() == '' && $('#enddateBox').val() == '') {
            $('#startdateBox').val('<?php echo $auto_start_date;?>');
            $('#enddateBox').val('<?php echo $auto_end_date;?>');
        }
    });

    $('#enddateBox').click(function () {
        $('#reportperiodDropdown').val('custom');
        if ($('#startdateBox').val() == '' && $('#enddateBox').val() == '') {
            $('#startdateBox').val('<?php echo $auto_start_date;?>');
            $('#enddateBox').val('<?php echo $auto_end_date;?>');
        }
    });

    showhidedates();

    $('#reportperiodDropdown').change(function () {
        showhidedates();
    });

    function showhidedates() {
        if ($('#reportperiodDropdown').val() == 'custom')
            $('#customdates').show();
        else
            $('#customdates').hide();
    }

});
</script>

<style type="text/css">
.ui-datepicker { z-index: 99 !important; }
</style>

<script type='text/javascript' src='<?php echo get_base_url(); ?>includes/js/reports.js?<?php echo get_build_id(); ?>'></script>

<form method="get" action="<?php echo encode_form_val($_SERVER["REQUEST_URI"]); ?>">
    <div class="well report-options form-inline">

        <input type="hidden" name="host" value="<?php echo encode_form_val($host); ?>">
        <input type="hidden" name="service" value="<?php echo encode_form_val($service); ?>">
        <input type="hidden" name="hostgroup" value="<?php echo encode_form_val($hostgroup); ?>">
        <input type="hidden" name="servicegroup" value="<?php echo encode_form_val($servicegroup); ?>">

        <div class="reportexportlinks">
            <?php echo get_add_myreport_html("Alert Timeline", $_SERVER["REQUEST_URI"], array()); ?>
        </div>

        <div class="reportsearchbox">
            <?php
            // search box
            $searchclass = "textfield";
            if (have_value($search) == true) {
                $searchstring = $search;
                $searchclass .= " newdata";
            }
            ?>
            <input type="text" size="15" name="search" id="searchBox" value="<?php echo isset($searchstring) ? encode_form_val($searchstring) : ""; ?>" placeholder="<?php echo _('Search'); ?>.." class="<?php echo $searchclass; ?> form-control"/>
        </div>

        <div class="neptune-drawer-options">

        <div class="reportoptionpicker">

            <div class="input-group">
                <label class="input-group-addon"><?php echo _("Period"); ?></label>
                <select id="reportperiodDropdown" name="reportperiod" class="form-control">
                    <?php
                    $tp = get_report_timeperiod_options();
                    foreach ($tp as $shortname => $longname) {
                        echo "<option value='" . $shortname . "' " . is_selected($shortname, $reportperiod) . ">" . $longname . "</option>";
                    }
                    ?>
                </select>
            </div>
            <div id="customdates" class="cal">
                <div class="input-group" style="width: 450px;">
                    <label class="input-group-addon"><?php echo _('From') ?></label>
                    <input class="form-control datetimepicker" type="text" id='startdateBox' name="startdate" value="<?php echo encode_form_val(get_datetime_from_timestring($startdate)); ?>">
                    <div data-picker="startdateBox" class="input-group-btn btn btn-sm btn-default btn-datetimepicker">
                        <i class="fa fa-calendar fa-14"></i>
                    </div>
                    <label class="input-group-addon" style="border-left: 0; border-right: 0;"><?php echo _('to') ?></label>
                    <input class="form-control datetimepicker" type="text" id='enddateBox' name="enddate" value="<?php echo encode_form_val(get_datetime_from_timestring($enddate)); ?>">
                    <div data-picker="enddateBox" class="input-group-btn btn btn-sm btn-default btn-datetimepicker">
                        <i class="fa fa-calendar fa-14"></i>
                    </div>
                </div>
            </div>
            
            <button type="submit" id="run" class="btn btn-sm btn-primary" name="reporttimesubmitbutton"><?php echo _("Run"); ?></button>

        </div>

        <div class="clear"></div>

        </div>

    </div>
</form>

<h1 style="margin: 0 0 10px 0; padding: 0;"><?php echo _("Alert Timeline"); ?></h1>

<?php
if ($service != "") {
?>
    <div class="servicestatusdetailheader">
        <div class="serviceimage">
            <!--image-->
            <?php show_object_icon($host, $service, true); ?>
        </div>
        <div class="servicetitle">
            <div class="servicename"><a
                    href="<?php echo get_service_status_detail_link($host, $service); ?>"><?php echo encode_form_val($service); ?></a>
            </div>
            <div class="hostname"><a
                    href="<?php echo get_host_status_detail_link($host); ?>"><?php echo encode_form_val($host); ?></a>
            </div>
        </div>
    </div>
    <br clear="all">

<?php
} else if ($host != "") {
?>
    <div class="hoststatusdetailheader">
        <div class="hostimage">
            <!--image-->
            <?php show_object_icon($host, "", true); ?>
        </div>
        <div class="hosttitle">
            <div class="hostname"><a
                    href="<?php echo get_host_status_detail_link($host); ?>"><?php echo encode_form_val($host); ?></a>
            </div>
        </div>
    </div>
    <br clear="all">
<?php
}
?>

<div style="clear: left;">
    <?php echo _("From"); ?>:
    <b><?php echo get_datetime_string($starttime, DT_SHORT_DATE_TIME, DF_AUTO, "null"); ?></b> <?php echo _("to"); ?>
     <b><?php echo get_datetime_string($endtime, DT_SHORT_DATE_TIME, DF_AUTO, "null"); ?></b>
</div>

<?php
if ($search != "")
    echo "<p>" . _('Showing results for') . " '<b><i>" . encode_form_val($search) . "</i></b>'</p>";
?>

<?php
$ajaxurl = get_base_url() . "includes/components/similetimeline/getdata.php";
$ajaxurl .= "?1";
foreach ($request as $var => $val)
    $ajaxurl .= "&" . urlencode($var) . "=" . urlencode($val);
$ajaxurl .= "&type=" . urlencode($datatype);
?>

<script type="text/javascript">
    $(document).ready(function () {

        onLoad();

        $(window).resize(function () {
            onResize();
        });

    });
</script>

<?php
// "Jun 28 2006 00:00:00 GMT"
$timeline_starttime = $starttime;
$startdate = date("M j Y G:i:s T", $timeline_starttime);
?>

<div id="my-timeline" style="margin-top: 20px; border: 1px solid #aaa">
    <div class="sk-spinner sk-spinner-pulse"></div>
    <b><?php echo _("Generating data"); ?>...</b>
</div>

<?php
$yearinterval = 250;
if ($datatype == "nagios") {
    $yearinterval = 100;
}
?>

<script type="text/javascript">
    var tl;
    function onLoad() {

        var h = $(window).height() - $('.report-options').outerHeight() - 110;
        $('#my-timeline').css('height', h+'px');

        var eventSource = new Timeline.DefaultEventSource();

        <?php
            if($datatype=="nagios"){
        ?>
        var bandInfos = [
            Timeline.createBandInfo({
                eventSource: eventSource,
                date: "<?php echo date("c", $timeline_starttime);?>",
                width: "80%",
                intervalUnit: Timeline.DateTime.DAY,
                intervalPixels: 200
            }),
            Timeline.createBandInfo({
                showEventText: false, // causes problems if enabled
                //trackHeight:    0.35,
                //trackGap:       0.4,
                eventSource: eventSource,
                date: "<?php echo date("c", $timeline_starttime);?>",
                width: "10%",
                intervalUnit: Timeline.DateTime.MONTH,
                intervalPixels: 200
            }),
            Timeline.createBandInfo({
                showEventText: false,
                trackHeight: 0.3,
                trackGap: 0.6,
                eventSource: eventSource,
                date: "<?php echo date("c", $timeline_starttime);?>",
                width: "10%",
                intervalUnit: Timeline.DateTime.YEAR,
                intervalPixels: <?php echo $yearinterval;?>
            })
        ];

        bandInfos[1].syncWith = 0;
        bandInfos[1].highlight = true;
        bandInfos[2].syncWith = 1;
        bandInfos[2].highlight = true;
        <?php
                }
            else{
        ?>
        var bandInfos = [
            Timeline.createBandInfo({
                //showEventText:  true,
                eventSource: eventSource,
                date: "<?php echo date("c", $timeline_starttime);?>",
                width: "70%",
                intervalUnit: Timeline.DateTime.HOUR,
                intervalPixels: 150
            }),
            Timeline.createBandInfo({
                showEventText: false,
                trackHeight: 0.5,
                trackGap: 0.2,
                eventSource: eventSource,
                date: "<?php echo date("c", $timeline_starttime);?>",
                width: "10%",
                intervalUnit: Timeline.DateTime.DAY,
                intervalPixels: 200
            }),
            Timeline.createBandInfo({
                showEventText: false, // causes problems if enabled
                trackHeight: 0.35,
                trackGap: 0.4,
                eventSource: eventSource,
                date: "<?php echo date("c", $timeline_starttime);?>",
                width: "10%",
                intervalUnit: Timeline.DateTime.MONTH,
                intervalPixels: 200
            }),
            Timeline.createBandInfo({
                showEventText: false,
                trackHeight: 0.3,
                trackGap: 0.6,
                eventSource: eventSource,
                date: "<?php echo date("c", $timeline_starttime);?>",
                width: "10%",
                intervalUnit: Timeline.DateTime.YEAR,
                intervalPixels: <?php echo $yearinterval;?>
            })
        ];

        bandInfos[1].syncWith = 0;
        bandInfos[1].highlight = true;
        bandInfos[2].syncWith = 1;
        bandInfos[2].highlight = true;
        bandInfos[3].syncWith = 2;
        bandInfos[3].highlight = true;
        <?php
            }
        ?>

        tl = Timeline.create(document.getElementById("my-timeline"), bandInfos);

        Timeline.loadJSON("<?php echo $ajaxurl;?>", function (json, url) {
            eventSource.loadJSON(json, url);
        });

    }

    var resizeTimerID = null;
    function onResize() {
        if (resizeTimerID == null) {
            resizeTimerID = window.setTimeout(function () {
                resizeTimerID = null;
                var h = $(window).height() - $('.report-options').outerHeight() - 110;
                $('#my-timeline').css('height', h+'px');
                tl.layout();
            }, 200);
        }
    }
</script>

    <?php

    // closes the HTML page
    do_page_end(true);
}
