    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="securitycheck" value="<?= encode_form_val($securitycheck) ?>">
    <input type="hidden" name="isvolatile" value="<?= encode_form_val($isvolatile) ?>">
    <input type="hidden" name="statestalking" value="<?= encode_form_val($statestalking) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Host Information') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address:') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address:") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name:') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this host')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name:") ?>">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Passive Services') ?></h2>
        <p><?= _('Define one or more service names that should be configured as passive services associated with the host') ?></p>

        <?php foreach ($services as $svcname) { ?>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="services[]" class="form-label"><?= _('Service Name(s):') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="services[]" id="services[]" value="<?= encode_form_val($svcname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Service Name(s):") ?>"  <?= encode_form_val($sid) ?> style="margin-right: 10px;">
                        <div class="invalid-feedback">
                            <?= _("Please enter the ".$labelText) ?>
                        </div>
                        <i id="services__Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
        <?php } ?>

        <h2 class="mt-4 mb-2"><?= _('Service Options') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="isvolatile" class="form-label form-item-required"><?= _('Volatility:') ?> <?= xi6_info_tooltip(_('Should the service(s) be volatile? Volatile services generate alerts each time a non-OK event is received, which can be useful when monitoring security events')) ?></label>
                <div class="input-group position-relative">
                    <select name="isvolatile" id="isvolatile" class="form-select monitor rounded" placeholder="<?= _("Select Volatility:") ?>">
                        <option value="yes" <?= is_selected($isvolatile, "yes") ?>><?= _('Volatile') ?></option>
                        <option value="no" <?= is_selected($isvolatile, "no") ?>><?= _('Non-volatile') ?></option>
                    </select>
                    <div class="invalid-feedback">
                        <?= _("Please select ".$labelText) ?>
                    </div>
                    <i id="isvolatile_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="statestalking" class="form-label form-item-required"><?= _('Stalking:') ?> <?= xi6_info_tooltip(_('Should the service(s) be stalked? Stalked services will have their output data (textual alert information) logged by Nagios each time newly received output differs from the most recent previously received output. This can be useful to track important or security-related information')) ?></label>
                <div class="input-group position-relative">
                    <select name="statestalking" id="statestalking" class="form-select monitor rounded" placeholder="<?= _("Select Stalking:") ?>">
                        <option value="yes" <?= is_selected($statestalking, "yes") ?>><?= _('Enabled') ?></option>
                        <option value="no" <?= is_selected($statestalking, "no") ?>><?= _('Disabled') ?></option>
                    </select>
                    <div class="invalid-feedback">
                        <?= _("Please select ".$labelText) ?>
                    </div>
                    <i id="statestalking_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
