    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2><?= _('MySQL Server') ?></h2>
            <p><?= _('Specify the details for connecting to the MySQL server you want to monitor') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the MySQL server')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Address
                        </div>
                        <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Port') ?> <?= xi6_info_tooltip(_('The port to use to connect to the MySQL server')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Port") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Port
                        </div>
                        <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Username') ?> <?= xi6_info_tooltip(_('The username used to connect to the MySQL server')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Username
                        </div>
                        <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
                <div class="col-sm">
                    <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                    <label for="changePassword" class="form-check-label bold"><?= _('Change Password') ?> <?= xi6_info_tooltip(_("Use to change the password, otherwise, the existing password will be preserved.")) ?></label>
                </div>
            </div>
            <div id="setPassword" class="row mb-2">
                <div class="col-sm-6">
                    <label for="password" class="form-label form-item-required"><?= _("Password") ?> <?= xi6_info_tooltip(_("The password to connect to the MySQL server.")) ?></label>
                    <div class="input-group">
                        <input type="password" name="password" id="password" value="<?=  encode_form_val($password) ?>" class="usermacro-detection form-control rounded-start" autocomplete="off" placeholder="<?= _("Enter Password") ?>" required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the password of your SQL Server account.
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Database') ?> <?= xi6_info_tooltip(_('The database to connect to on the MySQL server')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="database" id="database" value="<?= encode_form_val($database) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Database") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Database
                        </div>
                        <i id="_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
