/*
 * Wizard Tour(s)
 * 
 * Runs through a tour of a wizard and is expandable to include more wizards
 */

/* get wizard page from JS variable
 *
 * this "page" variable gives which page the user is on and in tandem with
 * the document.title variable, we can determine which tour/step to load,
 * allowing us to handle all of the logic in the tours/ folder.
 * 
 * Due to this, the only changes to monitoringwizard.php are the addition
 * of the function get_tour_loading_html() in case we want to rip these out
 * or change them in the future.
 * 
 * console.log("page: " + page); // page is the step from the wizard (1-6 where 1 is the landing page)
 * 
 * page: 0 - all wizards landing page
 * page: 1 - wizard 1
 * page: 2 - wizard 2
 * 
 * 
 * Dev NOTE:
 * I could change it to give extra steps for each wizard page (2-3 per page?) and adding skipIfNoElement to each step
 * or keep it as is and have the logic handled in the TOUR FUNCTIONS section below (the page variable will be equal to the step number).
 *  Currently the tour logic is handled in the TOUR FUNCTIONS section below.
 * 
 * I think keeping it as is is preferable and we should just have an extra tour if we need to add more steps to a wizard page
 * 
 * TODO:
 *  move tour steps to separate files
 */

// console.log("wizard-tour.js loaded on " + document.title);
// console.log("page: " + page);

// Set wizard step to 0 for testing
// ajaxSetStep("wizard-landing", 0);
// ajaxSetStep("wizard-website", 0);

//////////////////
// LOAD TOURS
//////////////////
window.onload=function() {
    targetWizard = "website";
    // load tour css
    var link = document.createElement('link');
    link.rel = 'stylesheet';
    link.type = 'text/css';
    link.href = window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/css/hopscotch.css';
    document.getElementsByTagName('head')[0].appendChild(link);
    

    if (is_neptune()) {
        var theme_link = document.createElement('link');
        theme_link.rel = 'stylesheet';
        theme_link.type = 'text/css';
        theme_link.href = window.location.origin + '/nagiosxi/includes/components/hopscotch-tours/css/hopscotch.neptune.css';
        document.getElementsByTagName('head')[0].appendChild(theme_link);
    }

    // tour loading logic
    let endstr = "Wizard · Nagios XI";

    if (document.title.indexOf("Configuration " + endstr) == 0) { // wizards selection page
        setTimeout(function() {
            $.get("/nagiosxi/includes/components/hopscotch-tours/hopscotch-ajaxhelper.php", {cmd: "get_step", tour: "wizard-landing"}, function(data) {
                data = JSON.parse(data);
                startWizardsLandingTour(targetWizard, data.step);
            });
        }, 100);
    } else if (document.title.indexOf("Monitoring " + endstr !== -1)  || document.title.indexOf("Configuarion " + endstr) !== -1){ // in a wizard
        // get wizard title preceding " Monitoring Wizard · Nagios XI"
        title = document.title;

        if (title.indexOf("Monitoring Wizard") !== -1) {
            endstr = " Monitoring Wizard · Nagios XI";
        } else if (title.indexOf("Configuration Wizard") !== -1) {
            endstr = " Configuration Wizard · Nagios XI";
        }
        titlepos = title.indexOf(endstr);
        title = title.substring(0, titlepos);
        title = title.toLowerCase();

        switch (title) {
            case "website":
                startWizardTour(targetWizard, page);
                break;
            default:
                break;
        }
    }
}

//////////////////
// TOUR FUNCTIONS
//////////////////
function addClassToBubble(){
    document.querySelectorAll('.hopscotch-bubble').forEach(el => el.classList.add('wizardtour'));
}
function startWizardsLandingTour(targetWizard = "website", stepno = 0) {
    targetWizard = targetWizard.toLowerCase();

    stepsarr = getwizardsteps_landing();

    wizTour = {
        id: "wizard-parent",
        steps: stepsarr,
    }
    
    // changed from "<=" to "<" as the last step is blank and startTour was always triggering and causing console errors -AC
    if (stepno < stepsarr.length) {
        if (is_neptune()) {
            hopscotch.configure({bubblePadding: 25});
        }

        hopscotch.startTour(wizTour, stepno);
    }
}

// page is indexed from 2 because the first step is the landing page and monitoringwizard.php is indexed from 1
function startWizardTour(wizard = "website", page = 2) {
    hopscotch.endTour();

    //// get wizard title - TODO: get this working so it can dynamically grab the wizard title from document.title and then use the appropriate tour for that wizard (allow for other wizard tours without hard-coding if we wanted) ////
    // title = document.title;
    // endstr = " Monitoring Wizard · Nagios XI";
    // titlepos = title.indexOf(endstr);
    // title = title.substring(0, titlepos);
    // title = title.toLowerCase();

    // get wizard steps from function getwizardsteps_<title>();
    // steps = getwizardsteps_website();
    let wizardstepsfunc = "getwizardsteps_" + wizard;
    if (window[wizardstepsfunc] && typeof window[wizardstepsfunc] === "function") {
        steps = window[wizardstepsfunc]() || [];
    }

    tour = {
        id: "wizard-child",
        steps: steps,
    }
    $.get("/nagiosxi/includes/components/hopscotch-tours/hopscotch-ajaxhelper.php", {cmd: "get_step", tour: "wizard-website"}, function(data) {
        data = JSON.parse(data);

        // if the tour step (idx from 1) is less than the page (idx from 2), run the tour
        if (data.step <= page - 1) {
            hopscotch.startTour(tour, page - 2);
        }
    });
}

//////////////////
// WIZARD STEPS
//////////////////

counter = [0,1]; // landing page, website wizard
function getwizardsteps_landing() {
    steps = [{
                title: "Configuration Wizards",
                content: "<b>Configuration Wizards</b> help set up monitoring for your network.",
                target: document.querySelector(".wiz-header"),
                placement: "bottom",
                arrowOffset: -1000000, // bye bye arrow
                onShow: function() {
                    // Open the Configuration Tools menu.
                    if (is_neptune()) {
                        var section = parent.document.getElementById("menu-configure-section-wizards-sidemenulink");
                        addClassToBubble();
                        if (section !== null) {
                            section.getElementsByTagName("button")[0].click();
                        }
                    }
                },
            },
            {
                title: "Search for Wizards",
                content: "Use the search box to search for the right wizard for your needs.",
                target: "wizardSearchBox",
                showPrevButton: true,
                placement: "bottom",
                arrowOffset: 15,
            },
            {
                title: "Wizard Categories",
                content: "You can also select a category to filter the list of wizards.",
                target: (is_neptune() ? "categorySelect" : "wizardSearchBox"),
                placement: "bottom",
                showPrevButton: true,
                arrowOffset: 108,
            },
            {
                title: "Website Monitoring Wizard",
                content: "The Website Monitoring Wizard will help you monitor a website. Click the Next button or select the wizard to continue.",
                target: document.querySelector(".wiz-padbox-inner[href$='wizard=website']"),
                yOffset: 15,
                placement: "top",
                showPrevButton: true,
                nextOnTargetClick: true,
                multipage: true,
                onNext: function() {
                    ajaxSetStep("wizard-website", 0);
                    window.location = window.location.origin + "/nagiosxi/config/monitoringwizard.php?update=1&nextstep=2&nsp=" + nsp_str + "&wizard=" + targetWizard;
                }
            },  {
                // empty step to give next button
            }]

    function addBehavior(oldBehavior, extraBehavior, currentStep) {
        return function() {
            if (oldBehavior) {
                oldBehavior();
            }

            if (typeof currentStep !== 'undefined') {
                extraBehavior(currentStep);
            } else {
                extraBehavior();
            }
        };
    }
    steps = steps.map(step => {
        counter[0]++;
        // add onShow behaviors
        step.onShow = addBehavior(step.onShow, () => styleAll("wizard-landing", steps.length));
        // add onPrev behaviors
        step.onPrev = addBehavior(step.onPrev, (currentStep) => {
            ajaxSetStep("wizard-landing", currentStep - 2);
        }, counter[0]);
        // add onNext behaviors
        step.onNext = addBehavior(step.onNext, (currentStep) => {
            ajaxSetStep("wizard-landing", currentStep);
        }, counter[0]);
        
        return step;
    });

    return steps;
}

// wizard steps for website wizard
function getwizardsteps_website() {
    steps = [
        {
            title: "Step 1: Wizard Target Selection",
            content: "Each wizard has a series of steps to help you configure monitoring for your network. The first step typically selects the target for monitoring. Enter the IP address or hostname of a website to continue.",
            target: "url",
            yOffset: (is_neptune() ? -15 : -18),
            xOffset: (is_neptune() ? 10 : 0),
            arrowOffset: (is_neptune() ? 15 : 0),
            placement: "right",
            multipage: true,
            onShow: function() {
                // Open the Configuration Tools menu.
                if (is_neptune()) {
                    addClassToBubble();
                    $('#url').css('border', 'solid 1px #FFF')
                }
            },
            onNext: function() {
                document.getElementById("configWizardForm").submit();
            }
        },
        {
            title: "Step 2: Monitoring Options",
            content: "The second step typically selects the monitoring options for the target. Hit <b>Next</b> to continue.",
            target: "ip",
            yOffset: (is_neptune() ? -10 : -18),
            xOffset: (is_neptune() ? 10 : 0),
            arrowOffset: (is_neptune() ? 0 : 0),
            placement: "right",
            multipage: true,
            onShow: function() {
                addClassToBubble();
            },
            onNext: function() {
                document.getElementById("configWizardForm").submit();
            }
        },
        {
            title: "Step 3: Nagios Monitoring Options",
            content: "The third step typically selects how frequently Nagios will monitor the target. You may hit <b>Finish</b> to complete the wizard using the defaults or hit next to modify notification and host/service grouping options.",
            target: document.querySelector("button[name='finishButton']"),
            placement: "bottom",
            yOffset: (is_neptune() ? 10 : 0),
            arrowOffset: (is_neptune() ? 0 : 0),
            nextOnTargetClick: true,
            multipage: true,
            onShow: function() {
                addClassToBubble();
                $('[name="finishButton"]').css('border', 'solid 1px #FFF')
                document.querySelector(".hopscotch-next").addEventListener("click", function() {
                    ajaxSetStep("wizard-website", 6);
                    document.getElementById("configWizardForm").submit();
                });
            },
        },
        {
            // empty step 4
        },
        {
            // empty step 5
        },
        { // TODO:? add a configured successfully step?

        }
        
    ]

    // add behaviors to each step:
    function addBehavior(oldBehavior, extraBehavior, currentStep) {
        return function() {
            if (typeof currentStep !== 'undefined') {
                extraBehavior(currentStep);
            } else {
                extraBehavior();
            }

            if (oldBehavior) {
                oldBehavior();
            }
        };
    }
    
    steps = steps.map(step => {
        counter[1]++;
        // add onShow behaviors
        step.onShow = addBehavior(step.onShow, () => styleAll("wizard-website", steps.length));

        // add onPrev behaviors
        step.onPrev = addBehavior(step.onPrev, (currentStep) => {
            ajaxSetStep("wizard-website", currentStep - 2);
        }, counter[1]);
        // add onNext behaviors
        step.onNext = addBehavior(step.onNext, (currentStep) => {
            ajaxSetStep("wizard-website", currentStep);
        }, counter[1]);
        return step;
    });

    return steps;
}

//////////////////
// STYLE FUNCTIONS
//////////////////

//// THESE FUNCTIONS ALREADY INCLUDED THROUGH home-tour.js IN pageparts.inc.php ////

// function styleAll(){
//     stylebubble();
//     stylecircle();
//         ...
// }

// function stylebubble() {
//   // bubble styling stuff
// }

// function stylecircle() {
// }

// function stylenextbtn() {
// }
// ...