    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2 class="mb-2"><?= _('Solaris Server Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('IP Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the Solaris server you would like to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($ip_address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the IP Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Agent') ?> <?= xi6_info_tooltip(_('Which agent do you want to use to monitor the Solaris system')) ?></label>
                    <div class="input-group position-relative">
                        <select name="agent" id="agent" class="form-select monitor rounded" placeholder="<?= _("Select Agent") ?> " required>
                            <option value="ncpa" <?= is_selected($agent, "ncpa") ?>>NCPA</option>
                            <option value="nrpe" <?= is_selected($agent, "nrpe") ?>>NRPE (<?= _('Legacy') ?>)</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Agent
                        </div>
                        <i id="agent_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
