    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="osdistro" value="<?= encode_form_val($osdistro) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
<?php
    if ($osdistro == "AIX" || $osdistro == "Solaris" || $osdistro == "Mac") {
        $dist = ($osdistro == "Solaris") ? "sol" : "aix";
        $url = "monitoringwizard.php?update=1&nextstep=2&nsp=".get_nagios_session_protector_id()."&wizard=ncpa&ip_address=".$address."&os=$dist";
        $name = _("NCPA Config Wizard");

        if ($osdistro == "Mac") {
            $url = "monitoringwizard.php?update=1&nextstep=2&nsp=".get_nagios_session_protector_id()."&wizard=macosx&ip_address=".$address;
            $osdistro = "Mac OS X";
            $name = _("Mac OS X Config Wizard");
        }
?>
        <div style="margin: 10px 0;" class="alert alert-warning"><b><?= _('Warning') ?></b>: <?= sprintf(_('NRPE on %s is deprecated.You should use the <a href="%s">%s</a> unless you are using a legacy NRPE install'), $osdistro, $url, $name) ?></div>
<?php
    }
?>

        <h2 class="ul"><?= _('Server Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('IP Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_("The name you'd like to have associated with this host")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('NRPE Agent') ?></h2>
        <p><?= _('Specify options that should be used to communicate with the remote NRPE agent') ?>.</p>
<?php
    if (!empty($agent_url) && !empty($install_doc_url)) {
?>
        <div class="col-sm-4 border-block ms-3 mb-3">
            <div class="row mb-2">
                <div class="col-sm">
                    <a href="<?= $agent_url ?>"><i class="material-symbols-outlined md-20 md-400 md-action md-middle">download</i></a>
                    <a href="<?= $agent_url ?>"><b><?= _("Download Agent") ?></b></a>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm">
                    <a href="<?= $install_doc_url ?>"><i class="material-symbols-outlined md-20 md-400 md-action md-middle">description</i></a>
                    <a href="<?= $install_doc_url ?>"><b><?= _('Agent Installation Instructions') ?></b></a>
                </div>
            </div>
        </div>
<?php
    }
?>
        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ssl" class="form-label form-item-required"><?= _("SSL Encryption") ?> <?= xi6_info_tooltip(_('Determines whether or not data between the Nagios XI server and NRPE agent is encrypted. Note: Legacy NRPE installations may require that SSL support be disabled')) ?></label>
                <div class="input-group position-relative">
                    <select name="ssl" id="ssl" class="form-control form-control-sm form-select monitor rounded" placeholder="<?= _("Select SSL Encryption") ?>" >
                        <option value="on" <?= is_selected($ssl, "on") ?>><?= _('Enabled (Default)') ?></option>
                        <option value="off" <?= is_selected($ssl, "off") ?>><?= _('Disabled') ?></option>
                    </select>
                    <div class="invalid-feedback">
                        <?= _("Please select ".$labelText) ?>
                    </div>
                    <i id="ssl_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Server Metrics') ?></h2>
        <p><?= _("Specify which services you'd like to monitor for the server") ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ping" class="form-check-input" name="services[ping]"  <?= is_checked(checkbox_binary($services['ping']), "1") ?> >
                        <label for="ping" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_("Monitors the server with an ICMP Ping. Useful for watching network latency and general uptime.")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>
        
        <h2 class="mt-4"><?= _('NRPE Commands') ?></h2>
        <p><?= _('Specify any remote NRPE commands that should be monitored on the server. Multiple command arguments should be separated with a space.') ?><br><?= _('Arguments are defined with check_nrpe using -a and are single quoted on the command line. If you put in <b>-w 10, -c 20</b> then the config wizard will do')." <b>-a '-w 10, -c 20'</b>" ?></p>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-2 mb-1">
                    <div class="col-sm-4">
                        <label class="form-check-label bold ps-3"><?= _('Display Name') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Remote NRPE Command') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Command Args') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="position-relative adddeleterow commandsList">
<?php
    for ($x = 0; $x < count($serviceargs['commands']); $x++) {
        $commandstring = encode_form_val($serviceargs['commands'][$x]['command']);
        $commandargs = encode_form_val($serviceargs['commands'][$x]['args']);
        $commandname = encode_form_val($serviceargs['commands'][$x]['name']);
        $is_checked = (isset($services['commands'][$x]) ? is_checked($services['commands'][$x]) : '');
?>
            <div class="row">
                <div class="col-sm-10">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0 pt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[commands][<?= $x ?>]" id="services[commands][<?= $x ?>][monitor]" <?= $is_checked ?>>
                                <input type="text" class="form-control form-control-sm ps-1 rounded" name="serviceargs[commands][<?= $x ?>][name]" id="services[commands][<?= $x ?>][name]" value="<?= $commandname ?>">
                                <i id="serviceargs_commands_<?= $x ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-4 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm monitor" name="serviceargs[commands][<?= $x ?>][command]" id="services[commands][<?= $x ?>][command]" value="<?= $commandstring ?>">
                                <i id="services_commands_<?= $x ?>_name_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-4 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="text" class="form-control form-control-sm rounded monitor" name="serviceargs[commands][<?= $x ?>][args]" id="services[commands][<?= $x ?>][args]" value="<?= $commandargs ?>">
                                <i id="serviceargs_commands_<?= $x ?>_args_Alert-cust-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- commandsList -->

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
