    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($ip_address) ?>">
    <input type="hidden" name="version" value="<?= encode_form_val($version) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="token" value="<?= encode_form_val($token) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Exchange Server Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('IP Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($ip_address) ?>" class="form-control form-control-sm rounded" placeholder="<?= _("Enter IP Address") ?>" disabled="on">
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this Exchange server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="owa_url" class="form-label"><?= _('URL') ?> <?= xi6_info_tooltip(_('The URL used to access OWA on the Exchange server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="owa_url" id="owa_url" value="<?= encode_form_val($owa_url) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter URL") ?>" >
                    <i id="owa_url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Basic Services') ?></h2>
        <p><?= _('Specify which services you would like to monitor for the Exchange server') ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[ping]" class="form-check-input" name="services[ping]" <?= is_checked(checkbox_binary($services['ping']), "1") ?> >
                    <label for="services[ping]" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_('Monitors the server with an ICMP ping. Useful for watching network latency and general uptime.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[smtp]" class="form-check-input" name="services[smtp]"  <?= is_checked(checkbox_binary($services['smtp']), "1") ?> >
                        <label for="services[smtp]" class="form-check-label bold"><?= _('SMTP') ?> <?= xi6_info_tooltip(_('Monitors SMTP service availability.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[imap]" class="form-check-input" name="services[imap]"  <?= is_checked(checkbox_binary($services['imap']), "1") ?> >
                        <label for="services[imap]" class="form-check-label bold"><?= _('IMAP') ?> <?= xi6_info_tooltip(_('Monitors IMAP service availability.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[pop]" class="form-check-input" name="services[pop]"  <?= is_checked(checkbox_binary($services['pop']), "1") ?> >
                        <label for="services[pop]" class="form-check-label bold"><?= _('POP') ?> <?= xi6_info_tooltip(_('Monitors POP service availability.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[rbl]" class="form-check-input" name="services[rbl]"  <?= is_checked(checkbox_binary($services['rbl']), "1") ?> >
                        <label for="services[rbl]" class="form-check-label bold"><?= _('RBL Blacklist Check') ?> <?= xi6_info_tooltip(_('Checks to see if your mail server is listed on any public RBLs (real time blackhole lists)')) ?></label>
                    </div>
                    <div class="col-sm-6 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <span class="form-label m-0 ms-1 align-middle"><?= _('Blacklist Servers') ?></span>
                            </span>
                            <input type="text" id="serviceargs[rbl_servers]" name="serviceargs[rbl_servers]" value="<?= encode_form_val($serviceargs['rbl_servers']) ?>" class="form-control form-control-sm form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_rbl_servers_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    if ($use_2003_deprecated_stats) {
?>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[owa_http]" class="form-check-input" name="services[owa_http]"  <?= is_checked(checkbox_binary($services['owa_http']), "1") ?> >
                        <label for="services[owa_http]" class="form-check-label bold"><?= _('OWA HTTP') ?> <?= xi6_info_tooltip(_('Monitors the availability of Outlook Web Access over HTTP.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    }
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[owa_https]" class="form-check-input" name="services[owa_https]"  <?= is_checked(checkbox_binary($services['owa_https']), (($use_2003_deprecated_stats) ? "1" : "0")) ?> >
                        <label for="services[owa_https]" class="form-check-label bold"><?= _('OWA HTTPS') ?> <?= xi6_info_tooltip(_('Monitors the availability of Outlook Web Access over HTTPS (secured with SSL).')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Exchange Services') ?></h2>
        <p><?= _('Specify which Exchange services you would like to monitor (these require installation of the Windows agent)') ?>.<br><b><?= _('You must have the listed core service classes available for the wizard services to run correctly') ?></b></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[core_services]" class="form-check-input" name="services[core_services]"  <?= is_checked(checkbox_binary($services['core_services']), "1") ?> >
                        <label for="services[core_services]" class="form-check-label bold"><?= _('Core Services') ?> <?= xi6_info_tooltip(_('Checks to make sure core services (specified below) that are essential to Exchange are running')) ?></label>
                    </div>
                    <div class="col-sm-6 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <span class="form-label m-0 ms-1 align-middle"><?= _('Services') ?></span>
                            </span>
                            <input type="text" id="serviceargs[core_service_names]" name="serviceargs[core_service_names]" value="<?= encode_form_val($serviceargs['core_service_names']) ?>" class="form-control form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_core_service_names_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[web_services]" class="form-check-input" name="services[web_services]"  <?= is_checked(checkbox_binary($services['web_services']), "1") ?> >
                        <label for="services[web_services]" class="form-check-label bold"><?= _('Web Services') ?> <?= xi6_info_tooltip(_('Checks to make sure web services (specified below) that are essential to Exchange are running')) ?></label>
                    </div>
                    <div class="col-sm-6 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <span class="form-label m-0 ms-1 align-middle"><?= _('Services') ?></span>
                            </span>
                            <input type="text" id="serviceargs[web_service_names]" name="serviceargs[web_service_names]" value="<?= encode_form_val($serviceargs['web_service_names']) ?>" class="form-control form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_web_service_names_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Exchange Metrics') ?></h2>
        <p><?= _('Specify which metrics you would like to monitor on the Exchange server (these require installation of the Windows agent)') ?>.</p>

<?php
    if ($use_2003_deprecated_stats) {
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[pending_routing]" class="form-check-input" name="services[pending_routing]"  <?= is_checked(checkbox_binary($services['pending_routing']), "1") ?> >
                        <label for="services[pending_routing]" class="form-check-label bold"><?= _('Messages Pending Routing') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[pending_routing_warning]" name="serviceargs[pending_routing_warning]" value="<?= encode_form_val($serviceargs['pending_routing_warning']) ?>" class="form-control form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_pending_routing_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[pending_routing_critical]" name="serviceargs[pending_routing_critical]" value="<?= encode_form_val($serviceargs['pending_routing_critical']) ?>" class="form-control form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_pending_routing_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[remote_queue_length]" class="form-check-input" name="services[remote_queue_length]"  <?= is_checked(checkbox_binary($services['remote_queue_length']), "1") ?> >
                        <label for="services[remote_queue_length]" class="form-check-label bold"><?= _('Remote Queue Length') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[remote_queue_length_warning]" name="serviceargs[remote_queue_length_warning]" value="<?= encode_form_val($serviceargs['remote_queue_length_warning']) ?>" class="form-control form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_remote_queue_length_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[remote_queue_length_critical]" name="serviceargs[remote_queue_length_critical]" value="<?= encode_form_val($serviceargs['remote_queue_length_critical']) ?>" class="form-control form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_remote_queue_length_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    }

    if ($use_2007_plus_stats) {
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[messages_queued_for_delivery]" class="form-check-input" name="services[messages_queued_for_delivery]" <?= is_checked(checkbox_binary($services['messages_queued_for_delivery']), "1") ?> >
                        <label for="services[messages_queued_for_delivery]" class="form-check-label bold"><?= _('Messages Queued For Delivery') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[messages_queued_for_delivery_warning]" name="serviceargs[messages_queued_for_delivery_warning]" value="<?= encode_form_val($serviceargs['messages_queued_for_delivery_warning']) ?>" class="form-control form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_messages_queued_for_delivery_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[messages_queued_for_delivery_critical]" name="serviceargs[messages_queued_for_delivery_critical]" value="<?= encode_form_val($serviceargs["messages_queued_for_delivery_critical"]) ?>" class="form-control form-control-sm monitor rounded-end">
		                    
                            <i id="serviceargs_messages_queued_for_delivery_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    }
?>
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
