// Function used to switch form options between host/sort select in both cool and normal mode
function switch_sort(option) {
    if (option === 'pie' || option === 'donut') {
        $("#sort_select").hide();
        $("#group_select option[value='host']").show();
    } else {
        $("#group_select option[value='host']").hide();
        $("#sort_select").show();
    }
}

// The functions below are only used in cool mode
function highchart_add_formdata() {
    hide_throbber();

    if ($('#addToDashboardBoardSelect').val() != '') {
        var boardName = $('#addToDashboardBoardSelect').val();
        var dashletName = $('#addtoDashboardTitleBox').val();
        var sortChoice = $('#sortChoiceSelect').val();
        var hostChoice = $('#host').val();
        var hostgroupChoice = $('#hostgroup').val();
        var servicegroupChoice = $('#servicegroup').val();
        var graphChoice = $('#graphChoiceSelect').val();
        var group = $('#group_select').val();

        if (!sortChoice) {
            sortChoice = "default";
        }
        if (hostChoice.length == 0) {
            hostChoice = "total";
        }
        if (hostgroupChoice.length == 0) {
            hostgroupChoice = "";
        }
        if (servicegroupChoice.length == 0) {
            servicegroupChoice = "";
        }
        if (group.length == 0) {
            group = "all";
        }
        url = "/nagiosxi/includes/dashifygraph.php";

        // Send request to dashify
        $.post(url, {dashletName: dashletName, boardName: boardName, sortChoice: sortChoice, graphChoice: graphChoice, hostChoice: hostChoice, hostgroupChoice: hostgroupChoice, servicegroupChoice, servicegroupChoice, group_select: group}, function (data) {
            // If it was a success show created message
            if (data.success == 1) {
                var content = "<div id='child_popup_header' style='margin-bottom: 5px;'><b>"+_('Dashlet Added')+"</b></div><div id='child_popup_data'><p>"+_('The dashlet has been added and will now show up on your dashboard.')+"</p></div>";
                set_child_popup_content(content);
                display_child_popup();
                fade_child_popup('green');
            }
        }, 'json');

    } else {
        alert(_('You must fill out the entire form.'));
    }
}

function dashify_highchart(graphChoice, sortChoice, dashletName) {
    show_throbber();
        
    var dashlet = JSON.parse(get_ajax_data("getadddashletdata", dashletName)); // get the dashlet data and parse it

    get_ajax_data_innerHTML("getdashboardselectmenuhtml", "", true, '#addToDashboardBoardSelect');

    var content = `
        <form>
            <div id='popup_header'><b>` + _("Add to Dashboard") + `</b></div>
            <div id='popup_data'><p>` + _("Add this powerful little dashlet to one of your dashboards for visual goodness.") + `</p></div>
            <div class='popup-form-box'>
                <label for='addToDashboardTitleBox'>` + _("Dashlet Title") + `</label>
                <input type='text' size='30' name='title' id='addtoDashboardTitleBox' value='`+_('Highchart Dashlet')+`' class='form-control' />
            </div>
            <div class='popup-form-box'>
                <label for='addToDashboardBoardSelect'>` + _("Select a Dashboard to Add To") + `</label>
                <select class='form-control' id='addToDashboardBoardSelect'></select>
            </div>`;
    content += dashlet.confightml;
    content +=
        `</form>
        <div id='addToDashboardFormButtons' style='margin-top:5px;'><br>
            <button class='btn btn-sm btn-primary' id='AddToDashButton' onclick='highchart_add_formdata()'>` + _('Add It') + `</button>
        </div>`;

    hide_throbber();
    set_child_popup_content(content);
    // Sets the default form-choice values to those shown in the graphs
    $("select#graphChoiceSelect option[value='" + graphChoice + "']").prop("selected", "selected");
    $("select#sortChoiceSelect option[value='" + sortChoice + "']").prop("selected", "selected");
    switch_sort(graphChoice);
    display_child_popup();
}