    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <div class="container m-0 g-0">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <div class="col-sm-6 border-block mb-4">
                <h2 class="mb-2">Auto-Discovery Jobs</h2>
                <p>Configure a new Auto-Discovery Job in <a href="<?= str_replace(get_base_url(false), '', get_base_url()) ?>/nagiosxi/includes/components/autodiscovery/" target="maincontentframe">Auto-Discovery</a></p>
            </div>

            <h2 class="mt-4 mb-2"><?= _('Auto-Discovery Job') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="job" class="form-label form-item-required">
                        <?= _('Job') ?>
                        <?= xi6_info_tooltip(_('Select the auto-discovery job you want to use, to choose new hosts and services to monitor.')) ?>
                    </label>
                    <div class="input-group position-relative">
                        <select name="job" id="job" class="form-select monitor rounded" placeholder="<?= _("Select Job") ?> " required>
<?php
    // Get jobs
    $jobs = autodiscovery_component_getjobs();

    // sort jobs by start time
    $search = array();

    foreach ($jobs as $jobid => $row) {
        $search[$jobid] = $row['start_date'];
    }

    array_multisort($search, SORT_DESC, $jobs);

    if (is_array($search)) {
        array_multisort($search, SORT_DESC, $jobs);
    }

    $visible_jobs = 0;

    foreach ($jobs as $jobid => $jobarr) {
        $output_file = get_component_dir_base("autodiscovery")."/jobs/".$jobid.".xml";

        // job is still running - skip it
        if (!file_exists($output_file)) {
            continue;
        }

        $visible_jobs++;

        $total_hosts = 0;
        $new_hosts = 0;
        $xml = @simplexml_load_file($output_file);

        if ($xml) {
            foreach ($xml->device as $d) {
                $status = strval($d->status);
                if ($status == "new")
                    $new_hosts++;
                $total_hosts++;
            }
        }

        $jobdesc = 'Scan of '.$jobarr["address"].' @ '.get_datetime_string($jobarr["start_date"]).' - '._('Found').' '.$new_hosts.' '._('New').' / '.$total_hosts.' '._('Total Hosts');
?>
                            <option value="<?= encode_form_val($jobid) ?>" <?= is_selected($job, $jobid) ?>><?= $jobdesc ?></option>
<?php
    }

    if ($visible_jobs == 0) {
?>
                            <option value=""><?= _('No completed auto-discovery jobs found') ?>.</option>
<?php
    }
?>
                        </select>
                        <div class="invalid-feedback">
                            Please select Job
                        </div>
                        <i id="job_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="show" class="form-label form-item-required"><?= _('Show') ?> <?= xi6_info_tooltip(_('Choose whether you would like to see results from all hosts that were found during the scan, or only new hosts that are not currently being monitored')) ?></label>
                    <div class="input-group position-relative">
                        <select name="show" id="show" class="form-select monitor rounded" placeholder="<?= _("Select Show") ?> " required>
                            <option value="new" <?= is_selected($show, "new") ?>><?= _('New Hosts') ?></option>
                            <option value="all" <?= is_selected($show, "all") ?>><?= _('All Hosts') ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Show
                        </div>
                        <i id="show_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="defaultservices" class="form-label form-item-required"><?= _('Default Services') ?> <?= xi6_info_tooltip(_('Select the types of services that you would like to be selected for monitoring by default. You can override individual services on the next page')) ?></label>
                    <div class="input-group position-relative">
                        <select name="defaultservices" id="defaultservices" class="form-select monitor rounded" placeholder="<?= _("Select Default Services") ?> " required>
                            <option value="common" <?= is_selected($defaultservices, "common") ?>><?= _('Common') ?></option>
                            <option value="none" <?= is_selected($defaultservices, "none") ?>><?= _('None') ?></option>
                            <option value="all" <?= is_selected($defaultservices, "all") ?>><?= _('All') ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Default Services
                        </div>
                        <i id="defaultservices_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="addresstype" class="form-label form-item-required"><?= _('Host Addresses') ?> <?= xi6_info_tooltip(_('Select the type of addresses that you would prefer to use for newly configured hosts')) ?></label>
                    <div class="input-group position-relative">
                        <select name="addresstype" id="addresstype" class="form-select monitor rounded" placeholder="<?= _("Select Host Addresses") ?> " required>
                            <option value="ip" <?= is_selected($addresstype, "ip") ?>><?= _('IP Addresses') ?></option>
                            <option value="dns" <?= is_selected($addresstype, "dns") ?>><?= _('DNS Names') ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Host Addresses
                        </div>
                        <i id="addresstype_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
