#!/bin/bash

# Load configuration file

BASEDIR=$(dirname $(readlink -f $0))
cfgfile="$BASEDIR/../../../../xi-sys.cfg"
cfgfile_installed="/usr/local/nagiosxi/var/xi-sys.cfg"

if [ -f $cfgfile ]; then
    . $cfgfile
elif [ -f $cfgfile_installed ]; then
    . $cfgfile_installed
fi

package="boto3"

# Check if boto3 is installed and try to install it

ret=$(python -c "import boto3")
if [ $? == 1 ]; then
    ret=$(pip)
    if [ $? == 127 ]; then
        if [[ $EUID -eq 0 ]]; then
            python -m pip install $package
        fi
    else
        pip install $package
    fi
fi