<?php
//
// Hypermap Replay
// Copyright (c) 2008-2020 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../../common.inc.php');
include_once(dirname(__FILE__) . '/ajax.inc.php');

// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs();
check_authentication(false);


route_request();


function route_request()
{
    global $request;

    // Only certain people can see this
    if (is_authorized_for_all_objects() == false) {
        echo _("You are not authorized to view all hosts and services.");
        exit();
    }

    $mode = grab_request_var("mode");
    switch ($mode) {
        case "getdata":
            hypermap_replay_get_data();
            break;
        default:
            display_hypermap_replay();
            break;
    }
}

function display_hypermap_replay()
{
    include_once(dirname(__FILE__) . '/dashlet.inc.php');

    // Get values passed in GET/POST request
    $reportperiod = grab_request_var("reportperiod", "last24hours");
    $startdate = grab_request_var("startdate", "");
    $enddate = grab_request_var("enddate", "");
    $type = grab_request_var("type", "");
    $timepoints = grab_request_var("timepoints", 10);
    $refresh = grab_request_var("refresh", 6);

    // Determine start/end times based on period
    get_times_from_report_timeperiod($reportperiod, $starttime, $endtime, $startdate, $enddate);

    $auto_start_date = get_datetime_string(strtotime('yesterday'), DT_SHORT_DATE);
    $auto_end_date = get_datetime_string(strtotime('today'), DT_SHORT_DATE);

    // Get timezone datepicker format
    if (isset($_SESSION['date_format']))
        $format = $_SESSION['date_format'];
    else {
        if (is_null($format = get_user_meta(0, 'date_format')))
            $format = get_option('default_date_format');
    }
    $f = get_date_formats();

    $js_date = 'mm/dd/yy';
    if ($format == DF_ISO8601) {
        $js_date = 'yy-mm-dd';
    } else if ($format == DF_US) {
        $js_date = 'mm/dd/yy';
    } else if ($format == DF_EURO) {
        $js_date = 'dd/mm/yy';
    }

    // Makes sure user has appropriate license level
    licensed_feature_check();

    // Start the HTML page
    do_page_start(array("page_title" => "Network Replay"), true);
?>

<script type="text/javascript">
$(document).ready(function () {

    $('.datetimepicker').datetimepicker({
        dateFormat: '<?php echo $js_date; ?>',
        timeFormat: 'HH:mm:ss',
        showHour: true,
        showMinute: true,
        showSecond: true
    });

    $('.btn-datetimepicker').click(function() {
        var id = $(this).data('picker');
        $('#' + id).datetimepicker('show');
    });

    $('#startdateBox').click(function () {
        $('#reportperiodDropdown').val('custom');
        if ($('#startdateBox').val() == '' && $('#enddateBox').val() == '') {
            $('#startdateBox').val('<?php echo $auto_start_date;?>');
            $('#enddateBox').val('<?php echo $auto_end_date;?>');
        }
    });

    $('#enddateBox').click(function () {
        $('#reportperiodDropdown').val('custom');
        if ($('#startdateBox').val() == '' && $('#enddateBox').val() == '') {
            $('#startdateBox').val('<?php echo $auto_start_date;?>');
            $('#enddateBox').val('<?php echo $auto_end_date;?>');
        }
    });

    showhidedates();

    $('#reportperiodDropdown').change(function () {
        showhidedates();
    });

    function showhidedates() {
        if ($('#reportperiodDropdown').val() == 'custom')
            $('#customdates').show();
        else
            $('#customdates').hide();
    }

});
</script>

<script type='text/javascript' src='<?php echo get_base_url(); ?>includes/js/reports.js?<?php echo get_build_id(); ?>'></script>

<form method="get" action="<?php echo encode_form_val($_SERVER["REQUEST_URI"]); ?>">
    <div class="well report-options form-inline">

        <div class="reportexportlinks">
            <?php echo get_add_myreport_html("Network Replay", $_SERVER["REQUEST_URI"], array()); ?>
        </div>

        <div class="neptune-drawer-options">

        <div class="reportoptionpicker">

            <div class="input-group">
                <label class="input-group-addon"><?php echo _("Period"); ?></label>
                <select id="reportperiodDropdown" name="reportperiod" class="form-control">
                    <?php
                    $tp = get_report_timeperiod_options();
                    foreach ($tp as $shortname => $longname) {
                        echo "<option value='" . $shortname . "' " . is_selected($shortname, $reportperiod) . ">" . $longname . "</option>";
                    }
                    ?>
                </select>
            </div>
            <div id="customdates" class="cal">
                <div class="input-group" style="width: 450px;">
                    <label class="input-group-addon"><?php echo _('From') ?></label>
                    <input class="form-control datetimepicker" type="text" id='startdateBox' name="startdate" value="<?php echo encode_form_val(get_datetime_from_timestring($startdate)); ?>">
                    <div data-picker="startdateBox" class="input-group-btn btn btn-sm btn-default btn-datetimepicker">
                        <i class="fa fa-calendar fa-14"></i>
                    </div>
                    <label class="input-group-addon" style="border-left: 0; border-right: 0;"><?php echo _('to') ?></label>
                    <input class="form-control datetimepicker" type="text" id='enddateBox' name="enddate" value="<?php echo encode_form_val(get_datetime_from_timestring($enddate)); ?>">
                    <div data-picker="enddateBox" class="input-group-btn btn btn-sm btn-default btn-datetimepicker">
                        <i class="fa fa-calendar fa-14"></i>
                    </div>
                </div>
            </div>

            <button type="submit" id="run" class="btn btn-sm btn-primary" name="reporttimesubmitbutton"><?php echo _("Run"); ?></button>

        </div>

        </div>

    </div>
</form>

<h1 style="padding: 0 0 20px 0;"><?php echo _("Network Replay"); ?></h1>

<?php
// don't dislpay this as a dashlet - just call the function directly.  we might want it as a dashlet in the future
$args = array(
    "starttime" => $starttime,
    "endtime" => $endtime,
    "timepoints" => $timepoints,
    "refresh" => $refresh,
);
$output = hypermap_replay_dashlet(DASHLET_MODE_OUTBOARD, "", $args);
echo $output;
?>

<?php
    /*
    $dargs=array(
        DASHLET_ARGS => array(
            "type" => $type,
            ),
        );

        echo "ARGS GOING IN=";
    print_r($dargs);
    echo "<BR>";
    display_dashlet("hypermap_replay","",$dargs,DASHLET_MODE_OUTBOARD);
    */
    ?>

    <script>
        window.onpopstate = function(event) {
            if (event.state) {
                // Reload the page with the previous state parameters
                var params = new URLSearchParams(event.state).toString();
                window.location.search = params;
            }
        };

        // Push current state to history when form is submitted
        $('form').on('submit', function(e) {
            var form = $(this);
            var params = form.serializeArray();
            var state = {};
            params.forEach(function(item) {
                state[item.name] = item.value;
            });
            history.pushState(state, '', '?' + $.param(state));
        });
    </script>

    <?php

    // closes the HTML page
    do_page_end(true);
}