    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container-fluid m-0 g-0">

        <h2 class="mb-2"><?= _('Server Information') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="address" class="form-label"><?= _('Server Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="address" id="address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Server Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label form-item-required"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The host name you would like to have associated with this server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Integer Value Checks') ?></h2>
        <p><?= _('Fill in fields to create services that checks the value of field containing an integer') ?>.</p>

        <div class="row g-2 mb-2">
            <div class="col-sm-2 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Service Description') ?>  <?= xi6_info_tooltip(_('Give a name for the new service. This will identify the purpose of the check, such as the specific integer value or key being monitored.')) ?></label>
            </div>
            <div class="col-sm-3 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('URL') ?> <?= xi6_info_tooltip(_('Enter the URL of the endpoint or resource to be monitored. Ensure it includes the protocol (e.g., http:// or https://) and the full path to the resource.')) ?></label>
            </div>
            <div class="col-sm-2 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Key') ?> <?= xi6_info_tooltip(_('The key can be used the same way as a JavaScript variable, some examples:').' &nbsp; list[5].host_status &nbsp; object.health.status_code &nbsp; temperature') ?></label>
            </div>
            <div class="col-sm-2 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Thresholds') ?> <?= xi6_info_tooltip(_('Use the following syntax to define value ranges for the thresholds:<br>10 -> alert triggered when outside range of {0 .. 10}<br> 10: -> alert triggered when outside range of {10 .. inf}<br> ~10 -> alert triggered when outside range of {-inf .. 10}<br>10:20 -> alert triggered when outside range of {10 .. 20}<br> @10:20 -> alert triggered when inside range of {10 .. 20}')) ?></label>
            </div>
            <div class="col-sm d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Additional Header') ?> <?= xi6_info_tooltip(_('Specify any custom HTTP headers to be sent with the request. Use this to pass authentication details or other required metadata.')) ?></label>
            </div>
        </div>

        <div id="integerChecksDiv">
            <div class="adddeleterow">
<?php
    for ($x = 0; $x < count($services["integer_check"]); $x++) {
?>
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="col-sm-2 mt-0 ps-0 pe-1">
                        <input type="text" name="services[integer_check][<?= $x ?>][desc]" id="string_check_desc<?= $x ?>" value="<?= encode_form_val(array_key_exists("desc", $services["integer_check"][$x]) ? $services["integer_check"][$x]["desc"] : "") ?>" class="form-control form-control-sm">
                    </div>
                    <div class="col-sm-3 mt-0 ps-0 pe-1">
                        <input type="text" name="services[integer_check][<?= $x ?>][url]" id="integer_check_url<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["url"]) ?>" class="form-control form-control-sm">
                    </div>
                    <div class="col-sm-2 mt-0 ps-0 pe-1">
                        <input type="text" name="services[integer_check][<?= $x ?>][key]" id="integer_check_key<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["key"]) ?>" class="form-control form-control-sm">
                    </div>
                    <div class="col-sm-1 mt-0 ps-0 pe-1">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" name="services[integer_check][<?= $x ?>][warning]" id="integer_check_warning<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["warning"]) ?>" class="form-control form-control-sm">
                        </div>
                    </div>
                    <div class="col-sm-1 mt-0 ps-0 pe-1">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" name="services[integer_check][<?= $x ?>][critical]" id="integer_check_critical<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["critical"]) ?>" class="form-control form-control-sm">
                        </div>
                    </div>
                    <div class="col-sm mt-0 ps-0 pe-1">
                        <input type="text" name="services[integer_check][<?= $x ?>][header]" id="integer_check_header<?= $x ?>" value="<?= encode_form_val($services["integer_check"][$x]["header"]) ?>" class="form-control form-control-sm">
                    </div>
                </fieldset>
<?php
    }
?>
            </div> <!-- adddeleterow -->
        </div> <!-- integerChecksDiv -->

        <h2 class="mt-4"><?= _('String Match Checks') ?></h2>
        <p><?= _('Fill in fields to create a service that checks the value of field containing a string') ?>.</p>

        <div class="row g-2 mb-2">
            <div class="col-sm-2 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Service Description') ?> <?= xi6_info_tooltip(_('Give a name for the new service. This will identify the purpose of the check, such as the specific string value or key being monitored.')) ?></label>
            </div>
            <div class="col-sm-2 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('URL') ?> <?= xi6_info_tooltip(_('Enter the URL of the endpoint or resource to be monitored. Ensure it includes the protocol (e.g., http:// or https://) and the full path to the resource.')) ?></label>
            </div>
            <div class="col-sm-2 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Key') ?> <?= xi6_info_tooltip(_('The key can be used the same way as a JavaScript variable, some examples:').' &nbsp; list[5].host_status &nbsp; object.health.status_code &nbsp; tempurature') ?></i></label>
            </div>
            <div class="col-sm-2 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('String') ?> <?= xi6_info_tooltip(_('String matches are exact match only. The full string must be found to be a match')) ?></i></label>
            </div>
            <div class="col-sm-1 p-0 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Match Found') ?></label>
            </div>
            <div class="col-sm-1 p-0 text-center d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Match Not Found') ?></label>
            </div>
            <div class="col-sm-2 p-0 d-flex align-items-end">
                <label class="form-check-label bold"><?= _('Additional Header') ?> <?= xi6_info_tooltip(_('Specify any custom HTTP headers to be sent with the request. Use this to pass authentication details or other required metadata.')) ?></label>
            </div>
        </div>

        <div id="stringMatchChecksDiv">
            <div class="adddeleterow">
<?php
    for ($x = 0; $x < count($services["string_check"]); $x++) {
?>
            <fieldset class="row g-2 mb-1 wz-fieldset">
                <div class="col-sm-2 mt-0 ps-0 pe-1">
                    <input type="text" name="services[string_check][<?= $x ?>][desc]" id="string_check_desc<?= $x ?>" value="<?= encode_form_val(array_key_exists("desc", $services["string_check"][$x]) ? $services["string_check"][$x]["desc"] : "") ?>" class="form-control form-control-sm">
                </div>
                <div class="col-sm-2 mt-0 ps-0 pe-1">
                    <input type="text" name="services[string_check][<?= $x ?>][url]" id="string_check_url<?= $x ?>" value="<?= encode_form_val($services["string_check"][$x]["url"]) ?>" class="form-control form-control-sm">
                </div>
                <div class="col-sm-2 mt-0 ps-0 pe-1">
                    <input type="text" name="services[string_check][<?= $x ?>][key]" id="string_check_key<?= $x ?>" value="<?= encode_form_val($services["string_check"][$x]["key"]) ?>" class="form-control form-control-sm">
                </div>
                <div class="col-sm-2 mt-0 ps-0 pe-1">
                    <input type="text" name="services[string_check][<?= $x ?>][string]" id="string_check_string<?= $x ?>" value="<?= encode_form_val($services["string_check"][$x]["string"]) ?>" class="form-control form-control-sm">
                </div>
                <div class="col-sm-1 mt-0 ps-0 pe-1">
                    <select name="services[string_check][<?= $x ?>][result_code_if_match]" class="form-control form-control-sm">
                        <option value="0" <?= is_selected(0, $services["string_check"][$x]["result_code_if_match"]) ?>>OK</option>
                        <option value="1" <?= is_selected(1, $services["string_check"][$x]["result_code_if_match"]) ?>>WARNING</option>
                        <option value="2" <?= is_selected(2, $services["string_check"][$x]["result_code_if_match"]) ?>>CRITICAL</option>
                        <option value="3" <?= is_selected(3, $services["string_check"][$x]["result_code_if_match"]) ?>>UNKNOWN</option>
                    </select>
                </div>
                <div class="col-sm-1 mt-0 ps-0 pe-1">
                    <select name="services[string_check][<?= $x ?>][result_code_if_no_match]" class="form-control form-control-sm">
                        <option value="0" <?= is_selected(0, $services["string_check"][$x]["result_code_if_no_match"]) ?>>OK</option>
                        <option value="1" <?= is_selected(1, $services["string_check"][$x]["result_code_if_no_match"]) ?>>WARNING</option>
                        <option value="2" <?= is_selected(2, $services["string_check"][$x]["result_code_if_no_match"]) ?>>CRITICAL</option>
                        <option value="3" <?= is_selected(3, $services["string_check"][$x]["result_code_if_no_match"]) ?>>UNKNOWN</option>
                    </select>
                </div>
                <div class="col-sm-2 mt-0 ps-0 pe-1">
                    <input type="text" name="services[string_check][<?= $x ?>][header]" id="string_check_header<?= $x ?>" value="<?= encode_form_val(array_key_exists("header", $services["string_check"][$x]) ? $services["string_check"][$x]["header"] : "") ?>" class="form-control form-control-sm">
                </div>
            </fieldset>
<?php
    }
?>
            </div> <!-- adddeleterow -->
        </div> <!-- stringMatchChecksDiv -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
