<?php
//
// Windows Server Config Wizard
// Copyright (c) 2020-2024 Nagios Enterprises, LLC. All rights reserved.
// 

include_once(dirname(__FILE__) . '/../configwizardhelper.inc.php');

nsclient_configwizard_init();

function nsclient_configwizard_init()
{
    $name = "nsclient";
    $args = array(
        CONFIGWIZARD_NAME => $name,
        CONFIGWIZARD_VERSION => "2.0.0",
        CONFIGWIZARD_TYPE => CONFIGWIZARD_TYPE_MONITORING,
        CONFIGWIZARD_DESCRIPTION => _("Monitor Windows using NSClient++."),
        CONFIGWIZARD_DISPLAYTITLE => _("NSClient++"),
        CONFIGWIZARD_FUNCTION => "nsclient_configwizard_func",
        CONFIGWIZARD_PREVIEWIMAGE => "nsclient.png",
        CONFIGWIZARD_FILTER_GROUPS => array('windows'),
        CONFIGWIZARD_REQUIRES_VERSION => 60100
    );
    register_configwizard($name, $args);
}

/**
 * @param string $mode
 * @param null   $inargs
 * @param        $outargs
 * @param        $result
 *
 * @return string
 */
function nsclient_configwizard_func($mode = "", $inargs = null, &$outargs = null, &$result = null)
{
    // $wizard_name = $inargs['wizard']; // I'm not sure why this was set up this way, but I found it would break under certain conditions by setting it to nsclient++, so I changed this. If this is wrong, this can be changed back.
    $wizard_name = "nsclient";

    $agents_url = "http://nsclient.org/download/";
    $nscp_version = "0.5.2.41";
    $nscp_releases_url = "https://github.com/mickem/nscp/releases";
    $agent32_stable_url = "$nscp_releases_url/download/$nscp_version/NSCP-$nscp_version-Win32.msi";
    $agent64_stable_url = "$nscp_releases_url/download/$nscp_version/NSCP-$nscp_version-x64.msi";

    // Initialize return code and output
    $result = 0;
    $output = "";

    // Initialize output args - pass back the same data we got
    $outargs[CONFIGWIZARD_PASSBACK_DATA] = $inargs;

    switch ($mode) {
        case CONFIGWIZARD_MODE_GETSTAGE1HTML:

            $address = grab_array_var($inargs, "ip_address", "");
            $check_method = grab_array_var($inargs, "check_method", "");

            # Get the existing host/node configurations. -- Pulled from NRPE wizard. This should be implemented in the future.
            # TODO: Include passwords/secrets?
            $nodes = get_configwizard_hosts($wizard_name);

            ########################################################################################
            # Load the html
            # - The html needs to end up in the $output string, so use ob_start() and ob_get_clean()
            #   to load the PHP from the Step1 file into the $output string.
            ########################################################################################
            ob_start();
            include __DIR__.'/steps/step1.php';
            $output = ob_get_clean();
            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE1DATA:

            // Get variables that were passed to us
            $address = grab_array_var($inargs, "ip_address", "");
            $address = nagiosccm_replace_user_macros($address);

            $check_method = grab_array_var($inargs, "check_method", "");
            $check_method = nagiosccm_replace_user_macros($check_method);

            // Check for errors
            $errors = 0;
            $errmsg = array();

            if (have_value($address) == false)
                $errmsg[$errors++] = _("No address specified.");
            else if (!valid_ip($address))
                $errmsg[$errors++] = _("Invalid IP address.");

            if (have_value($check_method) == false)
                $errmsg[$errors++] = _("No check method specified.");
            if ($check_method != "check_nt" && $check_method != "check_nrpe") {
                $errmsg[$errors++] = _("Invalid check method specified. Must be either 'check_nt' or 'check_nrpe'.");
            }

            if ($errors > 0) {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
                $result = 1;
            }

            break;

        case CONFIGWIZARD_MODE_GETSTAGE2HTML:

            $address = grab_array_var($inargs, "ip_address", "");
            $check_method = grab_array_var($inargs, "check_method", "");

            if ($check_method == "check_nt") { // legacy
                ob_start();
                include __DIR__.'/steps/step2_nt.php';
                $output = ob_get_clean();
            } elseif ($check_method == "check_nrpe") {
                ob_start();
                include __DIR__.'/steps/step2_nrpe.php';
                $output = ob_get_clean();
            }

            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE2DATA:
            $back = array_key_exists("backButton", $_POST);
            if ($back) break;

            $address = grab_array_var($inargs, "ip_address", "");
            $address = nagiosccm_replace_user_macros($address);
            $check_method = grab_array_var($inargs, "check_method", "");
            $check_method = nagiosccm_replace_user_macros($check_method);

            if ($check_method == "check_nt") { // legacy
                ob_start();
                include __DIR__.'/steps/step2_validation_nt.php';
                $output = ob_get_clean();
            } elseif ($check_method == "check_nrpe") {
                ob_start();
                include __DIR__.'/steps/step2_validation_nrpe.php';
                $output = ob_get_clean();
            }

            if ($errors > 0) {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
                $result = 1;
            }

            break;

        case CONFIGWIZARD_MODE_GETSTAGE3HTML:

            include __DIR__.'/steps/step3.php';

            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE3DATA:

            $error = grab_array_var($inargs, "error", "");
            if ($error != "") {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = array($error);
                $result = 1;
            }
            break;

        case CONFIGWIZARD_MODE_GETFINALSTAGEHTML:
            break;

        case CONFIGWIZARD_MODE_GETOBJECTS:

            $check_method = grab_array_var($inargs, "check_method", "");

            if ($check_method == "check_nt") { // legacy
                include __DIR__.'/steps/getobjects_nt.php';
            } elseif ($check_method == "check_nrpe") {
                include __DIR__.'/steps/getobjects_nrpe.php';
            }   

            break;

        default:
            break;
    }

    return $output;
}
