<?php
$hostname = grab_array_var($inargs, "hostname", "");
$address = grab_array_var($inargs, "ip_address", "");
$password = grab_array_var($inargs, "password", "");
$hostaddress = $address;

$services_serial = grab_array_var($inargs, "services_serial", "");
$serviceargs_serial = grab_array_var($inargs, "serviceargs_serial", "");

$services = json_decode(base64_decode($services_serial), true);
$serviceargs = json_decode(base64_decode($serviceargs_serial), true);

// save data for later use in re-entrance
$meta_arr = array();
$meta_arr["hostname"] = $hostname;
$meta_arr["ip_address"] = $address;
$meta_arr["password"] = $password;
$meta_arr["services"] = $services;
$meta_arr["serivceargs"] = $serviceargs;
save_configwizard_object_meta($wizard_name, $hostname, "", $meta_arr);

$objs = array();

if (!host_exists($hostname)) {
    $objs[] = array(
        "type" => OBJECTTYPE_HOST,
        "use" => "xiwizard_nsclient_host",
        "host_name" => $hostname,
        "address" => $hostaddress,
        "icon_image" => "nsclient.png",
        "statusmap_image" => "nsclient.png",
        "_xiwizard" => $wizard_name,
    );
}

// see which services we should monitor
foreach ($services as $svc => $svcstate) {

    //echo "PROCESSING: $svc -> $svcstate<BR>\n";

    switch ($svc) {

        case "ping":
            $objs[] = array(
                "type" => OBJECTTYPE_SERVICE,
                "host_name" => $hostname,
                "service_description" => "Ping",
                "use" => "xiwizard_nsclient_ping_service",
                "_xiwizard" => $wizard_name,
            );
            break;

        case "cpu":
            $objs[] = array(
                "type" => OBJECTTYPE_SERVICE,
                "host_name" => $hostname,
                "service_description" => "CPU Usage",
                "use" => "xiwizard_nsclient_service",
                "check_command" => "check_xi_service_nsclient!" . $password . "!CPULOAD!-l 5," . $serviceargs["cpu_warning"] . "," . $serviceargs["cpu_critical"],
                "_xiwizard" => $wizard_name,
            );
            break;

        case "memory":
            $objs[] = array(
                "type" => OBJECTTYPE_SERVICE,
                "host_name" => $hostname,
                "service_description" => "Memory Usage",
                "use" => "xiwizard_nsclient_service",
                "check_command" => "check_xi_service_nsclient!" . $password . "!MEMUSE!-w " . $serviceargs["memory_warning"] . " -c " . $serviceargs["memory_critical"],
                "_xiwizard" => $wizard_name,
            );
            break;

        case "uptime":
            $objs[] = array(
                "type" => OBJECTTYPE_SERVICE,
                "host_name" => $hostname,
                "service_description" => "Uptime",
                "use" => "xiwizard_nsclient_service",
                "check_command" => "check_xi_service_nsclient!" . $password . "!UPTIME",
                "_xiwizard" => $wizard_name,
            );
            break;

        case "disk":
            $donedisks = array();
            $diskid = 0;
            foreach ($serviceargs["disk"] as $diskname) {

                if ($diskname == "")
                    continue;

                //echo "HANDLING DISK: $diskname<BR>";

                // we already configured this disk
                if (in_array($diskname, $donedisks))
                    continue;
                $donedisks[] = $diskname;

                $objs[] = array(
                    "type" => OBJECTTYPE_SERVICE,
                    "host_name" => $hostname,
                    "service_description" => "Drive " . $diskname . ": Disk Usage",
                    "use" => "xiwizard_nsclient_service",
                    "check_command" => "check_xi_service_nsclient!" . $password . "!USEDDISKSPACE!-l " . $diskname . " -w " . $serviceargs["disk_warning"][$diskid] . " -c " . $serviceargs["disk_critical"][$diskid],
                    "_xiwizard" => $wizard_name,
                );

                $diskid++;
            }
            break;

        case "servicestate":

            $enabledservices = $svcstate;
            foreach ($enabledservices as $sid => $sstate) {

                $sname = $serviceargs["servicestate"][$sid]["service"];
                $sdesc = $serviceargs["servicestate"][$sid]["name"];

                $objs[] = array(
                    "type" => OBJECTTYPE_SERVICE,
                    "host_name" => $hostname,
                    "service_description" => $sdesc,
                    "use" => "xiwizard_nsclient_service",
                    "check_command" => "check_xi_service_nsclient!" . $password . "!SERVICESTATE!-l " . $sname . " -d SHOWALL",
                    "_xiwizard" => $wizard_name,
                );
            }
            break;

        case "processstate":

            $enabledprocs = $svcstate;
            foreach ($enabledprocs as $pid => $pstate) {

                $pname = $serviceargs["processstate"][$pid]["process"];
                $pdesc = $serviceargs["processstate"][$pid]["name"];

                $objs[] = array(
                    "type" => OBJECTTYPE_SERVICE,
                    "host_name" => $hostname,
                    "service_description" => $pdesc,
                    "use" => "xiwizard_nsclient_service",
                    "check_command" => "check_xi_service_nsclient!" . $password . "!PROCSTATE!-l " . $pname . " -d SHOWALL",
                    "_xiwizard" => $wizard_name,
                );
            }
            break;

        case "counter":

            $enabledcounters = $svcstate;
            foreach ($enabledcounters as $cid => $cstate) {

                $cname = $serviceargs["counter"][$cid]["counter"];
                $cdesc = $serviceargs["counter"][$cid]["name"];
                $cformat = $serviceargs["counter"][$cid]["format"];
                $cwarn = $serviceargs["counter"][$cid]["warning"];
                $ccrit = $serviceargs["counter"][$cid]["critical"];

                $checkcommand = "check_xi_service_nsclient!" . $password . "!COUNTER!-l \"" . $cname . "\"";
                if ($cformat != "")
                    $checkcommand .= ",\"" . $cformat . "\"";
                if ($cwarn != "")
                    $checkcommand .= " -w " . $cwarn;
                if ($ccrit != "")
                    $checkcommand .= " -c " . $ccrit;

                $objs[] = array(
                    "type" => OBJECTTYPE_SERVICE,
                    "host_name" => $hostname,
                    "service_description" => $cdesc,
                    "use" => "xiwizard_nsclient_service",
                    "check_command" => $checkcommand,
                    "_xiwizard" => $wizard_name,
                );
            }
            break;

        default:
            break;
    }
}

$outargs[CONFIGWIZARD_NAGIOS_OBJECTS] = $objs;
?>