    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?php echo encode_form_val(grab_array_var($inargs, "selectedhostconfig", "")); ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?php echo (!empty($services)) ? base64_encode(json_encode($services)) : ""; ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?php echo (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : ""; ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?php echo (!empty($config)) ? base64_encode(json_encode($config)) : ""; ?>" />

    <?php
        #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
    ?>
    <div class="container m-0 g-0 d-flex">
        <div id="configForm" class="flex-grow-1 me-3">
            <h2 class="mb-2"><?php echo _('Host Information'); ?></h2>

            <div class="mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required">
                        <?php echo _('IP Address'); ?> 
                        <?= xi6_info_tooltip(_('The IP address of your system hosting NSClient++')) ?>
                    </label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?php echo encode_form_val($address); ?>" class="form-control monitor rounded" placeholder="<?php echo _('Enter IP Address'); ?>" required>
                        <div class="invalid-feedback">
                            <?php echo _('Please enter the IP Address'); ?>
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
            <!-- <?php echo "check_method: " . $check_method; ?> --> <!-- TODO: remove -->
            <div class="hmb-2">
                <div class="col-sm-6">
                    <label for="check_method" class="form-label form-item-required">
                        <?php echo _('Check Method'); ?> 
                        <?= xi6_info_tooltip(_('Which plugin to use to communicate with NSClient++')) ?>
                    </label>
                    <div class="input-group position-relative">
                        <select name="check_method" id="check_method" class="form-select monitor rounded" placeholder="<?php echo _('Select Check Method'); ?>" required>
                            <option value="check_nrpe" <?= isset($check_method) && $check_method == "check_nrpe" ? "selected" : "" ?>>
                                <?php echo _('check_nrpe'); ?>
                            </option>
                            <option value="check_nt" <?= isset($check_method) && $check_method == "check_nt" ? "selected" : "" ?>>
                                <?php echo _('check_nt'); ?>
                            </option>
                        </select>
                        <div class="invalid-feedback">
                            <?php echo _('Please select Check Method'); ?>
                        </div>
                        <i id="check_method_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
        </div> <!-- configForm -->
        <div id="methodDescription" class="p-3 border rounded flex-shrink-0">
            <h2 class="mb-0"><?php echo _('Check Method'); ?></h2>
            <p id="descriptionText"></p>
            <br>
             <h2 class="mb-0"><?php echo _('Download Agent (version ' . $nscp_version . '):'); ?></h2>    
            <p>
                <a href="<?= $agent32_stable_url ?>" target="_blank"><?php echo _('32bit'); ?></a> |
                <a href="<?= $agent64_stable_url ?>" target="_blank"><?php echo _('64bit'); ?></a>
            </p>    
        </div> <!-- right container -->
    </div>
    <script type="text/javascript">
        document.getElementById('check_method').addEventListener('change', function() {
            var descriptionText = document.getElementById('descriptionText');
            var selectedMethod = this.value;
            if (selectedMethod === 'check_nrpe') {
                descriptionText.innerHTML = '<?php echo _('check_nrpe is the preferred method to communicate with NSClient++.'); ?><br><br> <span style="color: var(--md-unknown);"><?php echo _('WARNING: If you are still using the default NSClient++ DH key, '); ?><br> <?php echo _('you will need to update your NSClient++ DH key and configuration as seen here: '); ?><br><a href="https://assets.nagios.com/downloads/nagiosxi/docs/Enabling-the-NRPE-Listener-in-NSClient-0.4.x-for-Nagios-XI.pdf" target="_blank"><?php echo _('Enabling the NRPE Listener in NSClient 0.4+'); ?></a>';
            } else if (selectedMethod === 'check_nt') {
                descriptionText.innerHTML = '<?php echo _('check_nt is used to monitor Windows services and performance counters.'); ?> <br><br> <?php echo _('NOTE: check_nt is '); ?><span style="color: var(--md-critical);"><?php echo _('deprecated'); ?> </span> <?php echo _('in '); ?><span style="color:var(--md-info);"><?php echo _('NSClient++ 0.6'); ?></span><?php echo _(' and checks will need to be'); ?> <br> <?php echo _('migrated to check_nrpe if you wish to upgrade to version 0.6.'); ?>';
            } else {
                descriptionText.textContent = '<?php echo _('Select a check method to see its description.'); ?>';
            }
        });

        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('check_method').dispatchEvent(new Event('change'));
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
