<?php
$check_method = grab_array_var($inargs, "check_method", "");

if ($check_method == 'check_nt') {
    // get variables that were passed to us
    $address = grab_array_var($inargs, "ip_address");
    $hostname = grab_array_var($inargs, "hostname");
    $password = grab_array_var($inargs, "password");
    
    $services = "";
    $services_serial = grab_array_var($inargs, "services_serial");
    if ($services_serial != "")
        $services = json_decode(base64_decode($services_serial), true);
    else
        $services = grab_array_var($inargs, "services");
    
    $serviceargs = "";
    $serviceargs_serial = grab_array_var($inargs, "serviceargs_serial");
    if ($serviceargs_serial != "")
        $serviceargs = json_decode(base64_decode($serviceargs_serial), true);
    else
        $serviceargs = grab_array_var($inargs, "serviceargs");
    
    $output = '
    <input type="hidden" name="ip_address" value="' . encode_form_val($address) . '">
    <input type="hidden" name="check_method" value="' . encode_form_val($check_method) . '">
    <input type="hidden" name="hostname" value="' . encode_form_val($hostname) . '">
    <input type="hidden" name="password" value="' . encode_form_val($password) . '">
    <input type="hidden" name="services_serial" value="' . base64_encode(json_encode($services)) . '">
    <input type="hidden" name="serviceargs_serial" value="' . base64_encode(json_encode($serviceargs)) . '">
    ';

} elseif ($check_method == 'check_nrpe') {
    // Get variables that were passed to us
    $address = grab_array_var($inargs, "ip_address");
    $hostname = grab_array_var($inargs, "hostname");
    $check_method = grab_array_var($inargs, "check_method", "");
    $services = grab_array_var($inargs, "services", "");
    $serviceargs = grab_array_var($inargs, "serviceargs", "");
    $ssl = grab_array_var($inargs, "ssl", "on");
    $services_serial = (!empty($services) ? base64_encode(json_encode($services)) : grab_array_var($inargs, "services_serial", ''));
    $serviceargs_serial = (!empty($serviceargs) ? base64_encode(json_encode($serviceargs)) : grab_array_var($inargs, "serviceargs_serial", ''));

    if ($services_serial != "") {
        $services = json_decode(base64_decode($services_serial), true);
    }

    if ($serviceargs_serial != "") {
        $serviceargs = json_decode(base64_decode($serviceargs_serial), true);
    }

    $output = '
    <input type="hidden" name="ip_address" value="' . $address . '">
    <input type="hidden" name="hostname" value="' . $hostname . '">
    <input type="hidden" name="check_method" value="' . $check_method . '">
    <input type="hidden" name="ssl" value="' . $ssl . '">
    <input type="hidden" name="services_serial" value="' . base64_encode(json_encode($services)) . '">
    <input type="hidden" name="serviceargs_serial" value="' . base64_encode(json_encode($serviceargs)) . '">';
} else {
    $error = _('Invalid check method');
    $output = '<input type="hidden" name="error" value="' . $error . '">';
}

